// #define NUM_USER_TEXCOORDS 1

#include "CommonParams.h"
#include "UserShader.fx"
#include "Light.fx"

#ifdef SHADOWMAP
#include "ShadowMap.h"
#endif

float4 vModelColor = float4(1.0f, 1.0f, 1.0f, 1.0f);
bool bPointLight = true;

struct vertexInput
{
    float4 Position : POSITION0;
    float3 Normal    : NORMAL0;
    float4 Weights  : BLENDWEIGHT;
    float4 Indices  : BLENDINDICES;
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS] : TEXCOORD0;
#endif
};

struct vertexOutput
{
    float4 outPosition      : POSITION;
    float4 Color          : COLOR0;
    float4 WorldPosition    : TEXCOORD0;
    float4 Normal           : TEXCOORD1; // Normal.w ... fog
    float4 ScreenPosition   : TEXCOORD2;
    float4 VertexPosition   : TEXCOORD3;
    float3 VertexNormal     : TEXCOORD4;
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS] : TEXCOORD5;
#endif
};

MaterialVertexParameters GetMaterialVertexParameters(vertexInput Input)
{
    MaterialVertexParameters Params = (MaterialVertexParameters)0;
    Params.WorldPosition = Input.Position.xyz;
    //Params.VertexColor
    Params.VertexColor = vModelColor;
    Params.VertexPosition = Input.Position.xyz;
    Params.VertexNormal = Input.Normal.xyz;
    return Params;
}

MaterialPixelParameters GetMaterialParameters(vertexOutput Input)
{
    MaterialPixelParameters Params = (MaterialPixelParameters)0;
#if NUM_USER_TEXCOORDS
    [unroll(NUM_USER_TEXCOORDS)]for (int i = 0; i < NUM_USER_TEXCOORDS; i++)
        Params.TexCoords[i] = Input.TexCoords[i];
#endif
    Params.VertexColor = Input.Color;
    Params.WorldNormal = Input.Normal.xyz;//.w fog
    Params.VertexPosition = Input.VertexPosition.xyz;
    Params.VertexNormal = Input.VertexNormal.xyz;
	Params.ScreenPosition = Input.ScreenPosition;
	Params.WorldPosition = Input.WorldPosition.xyz;
    return Params;
}


vertexOutput VertexShaderMain(vertexInput Input)
{
    vertexOutput Output = (vertexOutput)0;

    MaterialVertexParameters Params = GetMaterialVertexParameters(Input);
	ParamsMainVertexNode VertexMainNode = (ParamsMainVertexNode)0;
	CalculateMainVertexNode(Params, VertexMainNode);
    float4 position = Input.Position + float4(VertexMainNode.WorldPositionOffset, 0.0f);
    Output.WorldPosition = mul(position, world);
    Output.ScreenPosition = mul(position, wvp);
    Output.outPosition = Output.ScreenPosition;
    Output.VertexPosition = Input.Position;
    Output.VertexNormal = Input.Normal.xyz;
    Output.Color = vModelColor;

#if NUM_USER_TEXCOORDS
    [unroll(NUM_USER_TEXCOORDS)]for (int i = 0; i < NUM_USER_TEXCOORDS; i++)
    Output.TexCoords[i] = Input.TexCoords[i];
#endif
    float3 normal = Input.Normal;
    if(!any(normal))
        normal=float3(0,1,0);
    Output.Normal.xyz = normalize(mul(normal,GetWorldMatrixforNormal()));
	Output.Normal.w   = CalFogFactor(Output.outPosition.z);
    return Output;
}

float4 PixelShaderMain(vertexOutput Input 
                    #if defined (SHADOWMAP) || defined(COVERPOINTLIGHT) || defined(POINTLIGHT)
                       ,float4 screenSpace : VPOS
                    #endif    
                       ) : COLOR0
{
    float4 retColor = 0;
    MaterialPixelParameters Params = GetMaterialParameters(Input);
	ParamsMainPixelNode PixelMainNode = (ParamsMainPixelNode)0;
	CalculateMainPixelNode(Params, PixelMainNode);
	CalcMaterialNormalParams(Params, PixelMainNode);

    //˫ʱжNormalǷҪת
    if(bTwoSide)
    {
        float3 V = normalize(eyes - Params.WorldPosition);
        float d = dot(V,Params.WorldNormal);
        Params.WorldNormal = Params.WorldNormal * sign(d);
    }
    
	//ֹģ ⲿظģҪҪᵽmaterialtemplateȥ
#ifdef LM_UNLIGHT
    retColor.rgb = PixelMainNode.Emissive;
    retColor.a = PixelMainNode.Opacity;
#endif
#ifdef LM_LAMBERT
    float3 ambientColor = PixelMainNode.Ambient;
    float3 emissiveColor = PixelMainNode.Emissive;
    float3 diffuseColor = PixelMainNode.Diffuse;
#ifdef SHADOWMAP
    float shadowMask = 1.0f;
    if (shadowMapParam.bShadowMask)
    {
                float2 screenpos = GetScreenpos(screenSpace.xy);
                shadowMask = GetShadowMask(screenpos);
    }
#endif  
    retColor.rgb = computeLambert(
        ambientColor,
        emissiveColor,
        diffuseColor,
        Params.WorldNormal
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
        ,screenSpace
#endif
#ifdef SHADOWMAP
        , shadowMask
#endif
        );
    retColor.a = PixelMainNode.Opacity;
#endif
#ifdef LM_PHONG
    float3 ambientColor = PixelMainNode.Ambient;
    float3 emissiveColor = PixelMainNode.Emissive;
    float3 diffuseColor = PixelMainNode.Diffuse;
    float3 specularColor = PixelMainNode.Specular;
    float specularPower = PixelMainNode.SpecularPower;
    if(specularPower<0.00001)
        specularPower = 15;
    float3 V = normalize(eyes - Params.WorldPosition);
#ifdef SHADOWMAP
    float shadowMask = 1.0f;
    if (shadowMapParam.bShadowMask)
    {
                float2 screenpos = GetScreenpos(screenSpace.xy);
                shadowMask = GetShadowMask(screenpos);
    }
#endif  
    retColor.rgb = computePhong(
        ambientColor,
        emissiveColor,
        diffuseColor,
        specularColor,
        specularPower,
        Params.WorldNormal
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
        ,screenSpace
#endif
        ,V
#ifdef SHADOWMAP
        ,shadowMask
#endif
        );
    retColor.a = PixelMainNode.Opacity;
#endif
#ifdef LM_ANISOTROPIC

#endif
#ifdef LM_SSS

#endif
#ifdef LM_CUSTOM//CUSTOMLIGHTING
    retColor = PixelMainNode.CustomLighting;
#endif
#ifdef LM_JX3
    float3 color = 0;
    color = PixelMainNode.Diffuse;
#ifdef SHADOWMAP
    float shadowMask = 1.0f;
    if (shadowMapParam.bShadowMask)
    {
        float2 screenpos = GetScreenpos(screenSpace.xy);
        shadowMask = GetShadowMask(screenpos);
    }
#endif  
#ifdef SPECULAR
    float3 specularColor = PixelMainNode.Specular;
    float specularPower = PixelMainNode.SpecularPower;
    if(specularPower<0.0001)
        specularPower = 15;
#endif
    float3 light = ComputeLight(
                    Params
#ifdef SPECULAR
                    ,specularColor,
                    specularPower,
                    0.5
#endif
#ifdef SSS
                    ,0.1
#endif
#ifdef SHADOWMAP
                    ,shadowMask
#endif
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
				,screenSpace
				,bPointLight
 #endif
                    );   //use worldnormal inside
    color *= light;
    color +=  PixelMainNode.Ambient;
    color +=  PixelMainNode.Emissive;
    retColor.rgb = color;
    retColor.a = PixelMainNode.Opacity;
#endif    //light mode  


#ifdef FOG
    retColor = CalFogColor(retColor, Input.Normal.w);
#endif
    return retColor;
}

technique Color
{
    pass p0
    {
        VertexShader = compile vs_3_0 VertexShaderMain(); 
        PixelShader = compile ps_3_0 PixelShaderMain();
    
        CullMode = cw; 
        ZEnable = true; 
        ZWriteEnable = true;
		ZFunc = LessEqual;
    }
}

technique ColorSoftMask
{
    pass p0
    {
        VertexShader = compile vs_3_0 VertexShaderMain(); 
        PixelShader = compile ps_3_0 PixelShaderMain();
        AlphaTestEnable = true;
        AlphaBlendEnable = false;
        ZEnable = true;
        ZWriteEnable = true;
        ZFunc = LESSEQUAL;
        CullMode = cw; 
    }
    pass p1
    {
        VertexShader = compile vs_3_0 VertexShaderMain(); 
        PixelShader = compile ps_3_0 PixelShaderMain();
        AlphaTestEnable = false;
        AlphaBlendEnable = true;
        ZEnable = true;
        ZWriteEnable = true;
        ZFunc = LESS;
        CullMode = cw; 
    }
}

struct ZOutput
{
    float4    ScreenPos : POSITION;
    float2    Texcoord  : TEXCOORD0;
    float2    RawPos    : TEXCOORD1;
};

ZOutput VS_EarlyZ(vertexInput Input) 
{
    ZOutput Out;
    Out.ScreenPos = mul(Input.Position, wvp);
    Out.RawPos = ComputeZW(Input.Position,Out.ScreenPos);
    Out.Texcoord = Input.TexCoords[0];
    return Out;
}

float4 PS_EarlyZ(ZOutput Input,out float4 col1:COLOR1) : COLOR0
{
    MaterialPixelParameters Params = (MaterialPixelParameters)0;
#if NUM_USER_TEXCOORDS
    [unroll(NUM_USER_TEXCOORDS)]for (int i = 0; i < NUM_USER_TEXCOORDS; i++)
        Params.TexCoords[i] = Input.Texcoord;
#endif
    float4 color = GetOpacityColor(Params);    
    color.rgb = ComputeLinearDepth(Input.RawPos);
	col1.rgba = Input.RawPos.x/Input.RawPos.y;
    return color;
}

technique EARLYZ
{
    pass p0
    {
        VertexShader = compile vs_3_0 VS_EarlyZ(); 
        PixelShader = compile ps_3_0 PS_EarlyZ();
        
        AlphaBlendEnable = false; 
        CullMode = cw; 
        ZWriteEnable = true;
        FogEnable = false;
    }
}

float4 PixelShaderShockWave(vertexOutput Input) : COLOR0
{
    float4 retColor = 0;
    MaterialPixelParameters Params = GetMaterialParameters(Input);
    
	retColor.rg = GetDistortion(Params);
    retColor.a = GetOpacityColor(Params);
    return retColor;
}

technique ShockWave
{
    pass p0
    {
        VertexShader = compile vs_3_0 VertexShaderMain(); 
        PixelShader = compile ps_3_0 PixelShaderShockWave();
        
        AlphaBlendEnable = false; 
        CullMode  = CW; 
        ZEnable = true; 
        ZWriteEnable = false;
    }
}