#include "CommonParams.h"
#include "UserShader.fx"

struct vertexInput
{
    float4 Position : POSITION0;
    float4 Color    : COLOR0;
    float2 TexCoord : TEXCOORD0;
};

struct vertexOutput
{
    float4 outPosition    : POSITION;
    float4 WorldPosition  : TEXCOORD0;
    float4 Normal         : TEXCOORD1; // Normal.w ... fog
    float4 ScreenPosition : TEXCOORD2;
    float2 TexCoord       : TEXCOORD3;
    float4 Color          : COLOR0;
};

vertexOutput VertexShaderMain(vertexInput Input)
{
    vertexOutput Output = (vertexOutput)0;
    
    Output.ScreenPosition = mul(Input.Position, wvp);
    Output.WorldPosition  = mul(Input.Position, world);
    Output.outPosition    = Output.ScreenPosition;    
    Output.TexCoord = Input.TexCoord;
    Output.Color    = Input.Color;
    Output.Normal.xyz     = float3(0.0f, 1.0f, 0.0f);
    Output.Normal.w = CalFogFactor(Output.outPosition.z);
    return Output;
}

MaterialPixelParameters GetMaterialParameters(vertexOutput Input)
{
    MaterialPixelParameters Params = (MaterialPixelParameters)0;
#if NUM_USER_TEXCOORDS
    [unroll(NUM_USER_TEXCOORDS)]for (int i = 0; i < NUM_USER_TEXCOORDS; i++)
        Params.TexCoords[i] = Input.TexCoord;
#endif
    Params.WorldNormal = Input.Normal.xyz;
    Params.VertexColor = Input.Color;
	Params.ScreenPosition = Input.ScreenPosition;
	Params.WorldPosition = Input.WorldPosition.xyz;
    return Params;
}

float4 PixelShaderMain(vertexOutput Input) : COLOR0
{
    float4 retColor = 0;
    MaterialPixelParameters Params = GetMaterialParameters(Input);
	ParamsMainPixelNode PixelMainNode = (ParamsMainPixelNode)0;
	CalculateMainPixelNode(Params, PixelMainNode);
    
#ifdef CUSTOMLIGHTING
    retColor = GetCustomLighting(Params);
#else 
    float3 color = 0;
    color = PixelMainNode.Diffuse;
    color += PixelMainNode.Ambient;
    color += PixelMainNode.Emissive;
    retColor.rgb = color;
    retColor.a   = PixelMainNode.Opacity;
#endif    
#ifdef FOG
    retColor = CalFogColor(retColor, Input.Normal.w);
#endif
    return retColor;
}

technique Color
{
    pass p0
    {
        VertexShader = compile vs_3_0 VertexShaderMain(); 
        PixelShader = compile ps_3_0 PixelShaderMain();
        
        AlphaBlendEnable = true; 
        SRCBLEND = SrcAlpha;
        DestBlend = InvSrcAlpha; 
        CullMode = None; 
        ZEnable = true; 
        ZWriteEnable = false;
		ZFunc = LessEqual;
    }
}

float4 PixelShaderShockWave(vertexOutput Input) : COLOR0
{
    float4 retColor = 0;
    MaterialPixelParameters Params = GetMaterialParameters(Input);
    
	retColor.rg = GetDistortion(Params);
	retColor.a  = GetOpacityColor(Params);
    return retColor;
}

technique ShockWave
{
    pass p0
    {
        VertexShader = compile vs_3_0 VertexShaderMain(); 
        PixelShader = compile ps_3_0 PixelShaderShockWave();
        
        AlphaBlendEnable = false; 
        CullMode = None; 
        ZEnable = true; 
        ZWriteEnable = false;
    }
}