//<ShadowMap>

//#ifndef SHADOWDARKERVALUE
//#define SHADOWDARKERVALUE 7
//#endif
SHARED float ShadowDarkValue = 0.7;
SHARED ShadowMapParam shadowMapParam = 
{
	false,
	{0, 0},
	{0, 0},
};
SHARED texture ShadowTexture;
sampler2D SamplerShadowTexture = sampler_state
{   
	Texture   = <ShadowTexture>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = BORDER;
	AddressV = BORDER;
	BorderColor = float4(0.0f, 0.0f, 0.0f, 0.0f);
};


#ifndef PACKTYPE
#define PACKTYPE 0
#endif
float GetShadowMask(float2 vScreenPos)
{
	return tex2D(SamplerShadowTexture, vScreenPos + 2 * float2(shadowMapParam.vBiasUV.x,shadowMapParam.vBiasUV.y)).r * ShadowDarkValue + (1 - ShadowDarkValue);
}

// for SPECULAR
float GetRealShadowMask(float2 vScreenPos)
{
	return tex2D(SamplerShadowTexture, vScreenPos + 2 * float2(shadowMapParam.vBiasUV.x,shadowMapParam.vBiasUV.y)).r;
}

float2 GetScreenpos(float2 screenSpace)
{
	float2 ScreenPos;
	ScreenPos.x = screenSpace.x * shadowMapParam.vViewPortWidthHeight.x;
	ScreenPos.y = screenSpace.y * shadowMapParam.vViewPortWidthHeight.y; 
	return ScreenPos;
}
//</ShadowMap>