#define TERRAIN
#include "CommonParams.h"
#include "UserShader.fx"
#include "Light.fx"

#ifdef SHADOWMAP
#include "ShadowMap.h"
#endif

float4 vPosOffset = {0.0f, 0.0f, 0.0f, 0.0f}; 
float4 vDiffuseRect = {0.0f, 0.0f, 0.0f, 0.0f}; 
float2 vTexSize = {0.0f, 0.0f};
float2 vBlendMapSize;

float fBlendRange = 0.000125;  // 1/(12800 *2) ??????section????????????????????????
int   nBlendIndex = 0;
float fTexScale   = 0.0025f;

texture g_texHeightFeild;
sampler2D g_samHeightFeild = sampler_state // : register(s0)
{
    Texture = <g_texHeightFeild>;
    MipFilter = Point;
    MinFilter = Point;
    MagFilter = Point;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture g_texNormalFeild;
sampler2D g_samNormalFeild = sampler_state //: register(s1)
{
    Texture = <g_texNormalFeild>;
    MipFilter = Linear;
    MinFilter = Linear;
    MagFilter = Linear;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture g_texBlend;
sampler2D g_SamplerBlend = sampler_state
{
    Texture = <g_texBlend>;
    MipFilter = Linear;
    MinFilter = Linear;
    MagFilter = Linear;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture g_tTexDiffuse;
sampler2D SamplerDiffuse = sampler_state
{
    Texture   = <g_tTexDiffuse>;
    MipFilter = LINEAR;
    MagFilter = LINEAR; 
    MinFilter = LINEAR;
    ADDRESSU = CLAMP;
    ADDRESSV = CLAMP;
};

float GetTerrainHeight(float x, float z)
{
    float2 texUV;
    texUV.x = saturate(x / vTexSize.x);
    texUV.y = saturate(z / vTexSize.y);
    
    float fValue = tex2Dlod(g_samHeightFeild, float4(texUV, 0, 0));
    return fValue;
}

float3 GetVertexPos(float3 pos)
{
    float3 worldPos = pos * vPosOffset.z + float3(vPosOffset.x, 0.0f, vPosOffset.y);
    worldPos.y = GetTerrainHeight(worldPos.x, worldPos.z);
    return worldPos;
}

float3 GetNormal(float2 texUV)
{
    float3 fValue = tex2Dlod(g_samNormalFeild, float4(texUV, 0, 0));
    fValue = 2.0f * fValue - 1.0f;
    return fValue;     
}

float GetBlend(float2 texUV)
{
    float2 vBlendUV;
    
    vBlendUV.x = texUV.x + (0.5f / vBlendMapSize.x);
    vBlendUV.y = texUV.y + (0.5f / vBlendMapSize.y);
    
    float4 fValue = tex2Dlod(g_SamplerBlend, float4(vBlendUV, 0, 0));
    if (nBlendIndex < 4)
        return saturate(fValue[nBlendIndex]);
    else
        return 0.0f;
}

float3 TexUVCalc(float3 Pos)
{
    float3 fUV = Pos * fTexScale * 0.01f;
    return fUV;
}

float2 ConverUVDiffuseBlock(float x,float z)
{
    float2 uv;
    uv.x  = (x - vDiffuseRect.x) / vDiffuseRect.z;
    uv.y  = (z - vDiffuseRect.y) / vDiffuseRect.w;
    return uv;
}
/*
float4 GetTexColorThreeSample(float3 wsCoord,float3 vNormal)
{
    float3 blend_weights = abs(vNormal.xyz);
    
    blend_weights = (blend_weights - 0.45) * 10;
    blend_weights = max(blend_weights,0);
    blend_weights /= (blend_weights.x + blend_weights.y + blend_weights.z).x;
   
    float2 coord1 = wsCoord.zy;
    float2 coord2 = wsCoord.xz;
    float2 coord3 = wsCoord.xy;
   
    float4 col1 = tex2D(SamplerTex_0,coord1);
    float4 col2 = tex2D(SamplerTex_0,coord2);
    float4 col3 = tex2D(SamplerTex_0,coord3);
   
    float4 OutColor = col1.xyzw * blend_weights.x + 
                      col2.xyzw * blend_weights.y + 
                      col3.xyzw * blend_weights.z;
    return OutColor;                                        
}
*/
struct vertexInput
{
    float4 Position : POSITION0;
};

struct vertexOutput
{
    float4 ScreenPosition : POSITION;
    float4 WorldPosition  : TEXCOORD0;
    float4 Normal         : TEXCOORD1; // Normal.w ... fog
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS] : TEXCOORD2;
#endif
};

MaterialPixelParameters GetMaterialParameters(vertexOutput Input)
{
    MaterialPixelParameters Params = (MaterialPixelParameters)0;
#if NUM_USER_TEXCOORDS
    [unroll(NUM_USER_TEXCOORDS)]for (int i = 0; i < NUM_USER_TEXCOORDS; i++)
        Params.TexCoords[i] = Input.TexCoords[i];
    #if NUM_USER_TEXCOORDS >= 2
    Params.WorldNormal = GetNormal(Input.TexCoords[1].xy);
    #endif
#endif    
    return Params;
}

vertexOutput VertexShaderMain(vertexInput Input)
{
    vertexOutput Output = (vertexOutput)0;
    float3 vPos = GetVertexPos(Input.Position);
    float3 vLocalUV = TexUVCalc(vPos);
    
    Output.ScreenPosition = mul(float4(vPos, 1.0f), wvp);
    Output.WorldPosition  = float4(vPos, 1.0f);
    
#if NUM_USER_TEXCOORDS
    #if NUM_USER_TEXCOORDS >= 1
	Output.TexCoords[0] = vLocalUV.xz;	
    #if NUM_USER_TEXCOORDS >= 2
	Output.TexCoords[1].xy  = ConverUV(vPos.x, vPos.z);    
    #if NUM_USER_TEXCOORDS >= 3
    Output.TexCoords[2] = vLocalUV.xy;
    #if NUM_USER_TEXCOORDS >= 4
    Output.TexCoords[3] = vLocalUV.yz;
    #endif
    #endif
    #endif
    #endif
#endif

    Output.Normal.w = CalFogFactor(Output.ScreenPosition.z);
    return Output;
}

float4 PixelShaderMain(vertexOutput Input
                    #if defined (SHADOWMAP) || defined(COVERPOINTLIGHT) || defined(POINTLIGHT)
                       ,float4 screenSpace : VPOS
                    #endif
                       ) : COLOR0
{
    float4 retColor = 0;
    MaterialPixelParameters Params = GetMaterialParameters(Input);
    CalcMaterialPixelParameters(Params,Input.ScreenPosition,Input.WorldPosition.xyz);

	//ֹģ ⲿظģҪҪᵽmaterialtemplateȥ
#ifdef LM_UNLIGHT
	retColor.rgb = GetEmissiveColor(Params);
#endif
#ifdef LM_LAMBERT
	float3 ambientColor = GetAmbientColor(Params);
	float3 emissiveColor = GetEmissiveColor(Params);
	float3 diffuseColor = GetDiffuseColor(Params);
#ifdef SHADOWMAP
	float shadowMask = 1.0f;
	if (shadowMapParam.bShadowMask)
	{
        		float2 screenpos = GetScreenpos(screenSpace.xy);
        		shadowMask = GetShadowMask(screenpos);
	}
#endif  
	retColor.rgb = computeLambert(
		ambientColor,
		emissiveColor,
		diffuseColor,
		Params.WorldNormal
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
		,screenSpace
#endif
#ifdef SHADOWMAP
		, shadowMask
#endif
		);
#endif
#ifdef LM_PHONG
	float3 ambientColor = GetAmbientColor(Params);
	float3 emissiveColor = GetEmissiveColor(Params);
	float3 diffuseColor = GetDiffuseColor(Params);
	float3 specularColor = GetSpecularColor(Params);
	float specularPower = GetSpecularPower(Params);
	if(specularPower<0.00001)
		specularPower = 15;
	float3 V = normalize(eyes - Params.WorldPosition);
#ifdef SHADOWMAP
	float shadowMask = 1.0f;
	if (shadowMapParam.bShadowMask)
	{
        float2 screenpos = GetScreenpos(screenSpace.xy);
        shadowMask = GetShadowMask(screenpos);
	}
#endif  
	retColor.rgb = computePhong(
		ambientColor,
		emissiveColor,
		diffuseColor,
		specularColor,
		specularPower,
		Params.WorldNormal
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
		,screenSpace
#endif
		,V
#ifdef SHADOWMAP
		,shadowMask
#endif
		);
#endif
#ifdef LM_ANISOTROPIC

#endif
#ifdef LM_SSS

#endif
#ifdef LM_CUSTOM//CUSTOMLIGHTING
    retColor = GetCustomLighting(Params);
#endif
#ifdef LM_JX3
    float3 color = 0;
    color = GetDiffuseColor(Params);
#ifdef SHADOWMAP
	float shadowMask = 1.0f;
    if (shadowMapParam.bShadowMask)
    {
        float2 screenpos = GetScreenpos(screenSpace.xy);
        shadowMask = GetShadowMask(screenpos);
    }
#endif  
#ifdef SPECULAR
	float3 specularColor = GetSpecularColor(Params);
	float specularPower = GetSpecularPower(Params);
	if(specularPower<0.0001)
		specularPower = 15;
#endif
    float3 light = ComputeLight(
					Params
#ifdef SPECULAR
					,specularColor,
					specularPower,
					0.5
#endif
#ifdef SSS
					,0.1
#endif
#ifdef SHADOWMAP
					,shadowMask
#endif
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
		,screenSpace
 #endif
					);   //use worldnormal inside
    color *= light;
    color +=  GetAmbientColor(Params);
    color +=  GetEmissiveColor(Params);
    retColor.rgb = color;
#endif    //light mode     
    retColor.a = 1.0f;
#if NUM_USER_TEXCOORDS >= 2
    float fBlend = GetBlend(Input.TexCoords[1].xy);
    retColor *= fBlend;
#endif
    return retColor;
}

technique Color
{  
    pass p0 
    {         
        VertexShader = compile vs_3_0 VertexShaderMain(); 
        PixelShader = compile ps_3_0 PixelShaderMain();         
    }  
}

vertexOutput VertexShaderLow(vertexInput Input)
{
    vertexOutput Output = (vertexOutput)0;
    float3 vPos = GetVertexPos(Input.Position);
    
    Output.ScreenPosition = mul(float4(vPos, 1.0f), wvp);
    Output.WorldPosition  = float4(vPos, 1.0f);
    
#if NUM_USER_TEXCOORDS
    #if NUM_USER_TEXCOORDS >= 1
	Output.TexCoords[0].xy = ConverUVDiffuseBlock(vPos.x, vPos.z);
	#if NUM_USER_TEXCOORDS >= 2
	Output.TexCoords[1].xy = ConverUV(vPos.x, vPos.z);
    for (int i = 2; i < NUM_USER_TEXCOORDS; i++)
		Output.TexCoords[i] = Output.TexCoords[1];
    #endif
    #endif
#endif
    Output.Normal.w = CalFogFactor(Output.ScreenPosition.z);
    return Output;
}


float4 PixelShaderLow(vertexOutput Input
                    #if defined (SHADOWMAP) || defined(COVERPOINTLIGHT)
                       ,float4 screenSpace : VPOS
                    #endif
                       ) : COLOR0
{
    float4 retColor = 0;
    MaterialPixelParameters Params = GetMaterialParameters(Input);
    CalcMaterialPixelParameters(Params,Input.ScreenPosition,Input.WorldPosition.xyz);

    //calculate Light
    float3 color = 0;
    
    float2 texUV = Input.TexCoords[0].xy;
    texUV.x = 1.0f - Input.TexCoords[0].x;
    color = tex2D(SamplerDiffuse, texUV);

#ifdef LM_JX3
#ifdef SHADOWMAP
	float shadowMask = 1.0f;
    if (shadowMapParam.bShadowMask)
    {
        float2 screenpos = GetScreenpos(screenSpace.xy);
        shadowMask = GetShadowMask(screenpos);
    }
#endif  
#ifdef SPECULAR
	float3 specularColor = GetSpecularColor(Params);
	float specularPower = GetSpecularPower(Params);
	if(specularPower<0.0001)
		specularPower = 15;
#endif
    float3 light = ComputeLight(
					Params
#ifdef SPECULAR
					,specularColor,
					specularPower,
					0.5
#endif
#ifdef SSS
					,0.1
#endif
#ifdef SHADOWMAP
					,shadowMask
#endif
#if defined(POINTLIGHT) || defined(COVERPOINTLIGHT)
		,screenSpace
 #endif
					);   //use worldnormal inside
    color *= light;
    color +=  GetAmbientColor(Params);
    color +=  GetEmissiveColor(Params);
    retColor.rgb = color;
#endif    //light mode    
    retColor.a = 1.0f;    
    return retColor;
}

technique TerrainLow
{
    pass p0
    {
        VertexShader = compile vs_3_0 VertexShaderLow();
        PixelShader  = compile ps_3_0 PixelShaderLow();
    }
}

struct ZOutput
{
    float4    ScreenPos : POSITION;
    float2    RawPos    : TEXCOORD0;
};

ZOutput VS_EarlyZ(vertexInput Input)
{
    ZOutput Out = (ZOutput)0;
    float3 vPos = GetVertexPos(Input.Position);
    Out.ScreenPos = float4(mul(float4(vPos,1.0f), wvp));
    Out.RawPos.x = Out.ScreenPos.z;
    Out.RawPos.y = Out.ScreenPos.w;
    return Out;
}

float4 PS_EarlyZ(float2 RawPos : TEXCOORD0,out float4 col1 : COLOR1) : COLOR0
{     
     float4 color = PackingFloatToRGB(RawPos.x / RawPos.y);
	 col1.rgba = RawPos.x / RawPos.y;
     return color;
}

technique EARLYZ
{
    pass p0
    {
        VertexShader = compile vs_3_0 VS_EarlyZ(); 
        PixelShader  = compile ps_3_0 PS_EarlyZ();
    }
}
