#ifndef NORMALMAP
	#define NORMALMAP 1
#endif
#define SM_Reflection 2
#define SM_Diffuse 1
#define SM_Specular 1
texture local1;
sampler2D local1__Sampler = sampler_state
{
	Texture = <local1>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
	BorderColor = float4(0.0f, 0.0f, 0.0f, 0.0f);
};

texture local2;
sampler2D local2__Sampler = sampler_state
{
	Texture = <local2>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
	BorderColor = float4(0.0f, 0.0f, 0.0f, 0.0f);
};

//defined by c++
#define NUM_USER_TEXCOORDS 2
#ifdef TERRAIN
	#if NUM_USER_TEXCOORDS < 2
	#define NUM_USER_TEXCOORDS 2
	#endif
#endif

struct MaterialVertexParameters
{
    float3 VertexPosition;
    float3 VertexNormal;
    float3 WorldPosition;
    float4 VertexColor;
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS];
#endif
};

struct MaterialPixelParameters
{
#if NUM_USER_TEXCOORDS
    float2 TexCoords[NUM_USER_TEXCOORDS];
#endif
    //float3 TangentNormal;    
    float3 WorldNormal;
    float3 WorldPosition; 
    float3 VertexPosition;
    float3 VertexNormal;
    float4 ScreenPosition;
    float4 VertexColor;
	float3 Tangent;
	float3 Binormal;
};

struct ParamsMainVertexNode
{
	float3 WorldPositionOffset;
};

struct ParamsMainPixelNode
{
	float3 Albedo;//Diffuse
	float3 SpecularColor;
	float Reflectivity;
	float Fresnel;
	float Roughness;
	float3 Normal;
	float3 Emissive;
	float  AO;
	float  Opacity;
	float4 CustomLighting;
	float3 Ambient;
	float  SpecularPower;
	float Anisotropic;
	float AnisoAngle;
	float SSSWidth;
	float3 SSSStrength;
	float3 SSSFallOff;
};

//PSм߿ռ
//#define NORMALMAP
#ifdef NORMALMAP
float3x3 ComputeTangentFrame(float3 N,float3 p,float2 uv)
{
	float3 dp1 = ddx(p);
	float3 dp2 = ddy(p);
	float2 duv1 = ddx(uv);
	float2 duv2 = ddy(uv);
	
	float3x3 M = float3x3(dp1,dp2,cross(dp1,dp2));
	float2x3 inversetransposeM = 
		float2x3(cross(M[1],M[2]),cross(M[2],M[0]));
	float3 T = mul(float2(duv1.x,duv2.x),inversetransposeM);
	float3 B = mul(float2(duv1.y,duv2.y),inversetransposeM);

	//float r = (dot(cross(T,B),N)<0.0f) ? -1.0f : 1.0f;
	return float3x3(normalize(T),normalize(B),N);
}

float4 CalcNormalfromTangentSpaceTexture(float4 normalTex,MaterialPixelParameters Parameters)
{
		float3 normal = normalize(2*normalTex.rgb -1);
		float4 wnormal = float4(normal,normalTex.a);
		return wnormal;
}

float3x3 GetTangentToLocalMatrix(MaterialPixelParameters Parameters)
{
		float3x3 TangentToLocal = float3x3(Parameters.Tangent, Parameters.Binormal, Parameters.WorldNormal);
		#if defined(NORMALMAP) && defined(TERRAIN)
			TangentToLocal = ComputeTangentFrame(Parameters.WorldNormal,Parameters.WorldPosition,Parameters.TexCoords[0]);
		#endif
		return TangentToLocal;
}

float4 CalcNormalfromLocalSpaceTexture(float4 normalTex)
{
		float3 normal = normalize(2*normalTex.rbg -1);
		//normal.b *= -1;
		float4 wnormal = mul(float4(normal,1),worldIT);
		return wnormal;
}
#endif


void CalcMaterialNormalParams(in out MaterialPixelParameters Parameters, in out ParamsMainPixelNode MainPixelNode)
{
    float3 normal = MainPixelNode.Normal;
    if(!any(normal))
    {
    	normal = Parameters.WorldNormal;
    }
		Parameters.WorldNormal =  normalize(normal);
}

/** Rotates Position about the given axis by the given angle, in radians, and returns the offset to Position. */
float3 RotateAboutAxis(float4 NormalizedRotationAxisAndAngle, float3 PositionOnAxis, float3 Position)
{
	// Project Position onto the rotation axis and find the closest point on the axis to Position
	float3 ClosestPointOnAxis = PositionOnAxis + NormalizedRotationAxisAndAngle.xyz * dot(NormalizedRotationAxisAndAngle.xyz, Position - PositionOnAxis);
	// Construct orthogonal axes in the plane of the rotation
	float3 UAxis = Position - ClosestPointOnAxis;
	float3 VAxis = cross(NormalizedRotationAxisAndAngle.xyz, UAxis);
	float CosAngle;
	float SinAngle;
	sincos(NormalizedRotationAxisAndAngle.w, SinAngle, CosAngle);
	// Rotate using the orthogonal axes
	float3 R = UAxis * CosAngle + VAxis * SinAngle;
	// Reconstruct the rotated world space position
	float3 RotatedPosition = ClosestPointOnAxis + R;
	// Convert from position to a position offset
	return RotatedPosition - Position;
}

float2 Rotator(float2 Position,float2 Center,float Angle)
{
	Position=Position-Center;
	float2 rot=float2(cos(Angle),sin(Angle));
	float x=Position.x*rot.x-Position.y*rot.y+Center.x;
	float y=Position.x*rot.y+Position.y*rot.x+Center.y;
	return float2(x,y);
}

float3 Reflection(MaterialPixelParameters Parameters,float3 InputDir)
{
	float3 N = Parameters.WorldNormal;
	float3 I = normalize(InputDir);
	float3 Reflection = reflect(InputDir,N);
	return Reflection;
}

float Fresnel(MaterialPixelParameters Parameters,float3 Normal,float addend,float multiplier, float exponent)
{
	//saturate(A + B * pow(1 - dot(ViewDir,Normal),C));
	float3 V = normalize(eyes-Parameters.WorldPosition);
	float3 N = normalize(Normal);
	float x = abs(1-max(0,dot(V,N)));
	x = x < 0.0001f ? 0 : pow(x, exponent);
	float result = addend + multiplier * x;
	return result;
}

float Random(float2 seed)
{
	float2 r = float2(23.1406926327792690,  // e^pi (Gelfond's constant)
			  2.6651441426902251); // 2^sqrt(2) (GelfondCSchneider constant)
	return frac( cos( fmod( 123456789., 1e-7 + 256. * dot(seed,r) ) ) );  
}

 // * UnMirrored == 1 if normal
 // * UnMirrored == -1 if mirrored ,how to know?
float UnMirror(float Coordinate,float UnMirrored )
{
	return ((Coordinate)*(UnMirrored)*0.5+0.5);
}

float2 CalculateTextureCoordinate(float2 UV,float Utiling,float Vtiling,bool UnMirroredU,bool UnMirroredV)
{
	float2 Coordinates = float2(UV.x * Utiling , UV.y * Vtiling);
	if(UnMirroredU)
		Coordinates.x = UnMirror(Coordinates.x, 1);
	if(UnMirroredV)
		Coordinates.y = UnMirror(Coordinates.y, 1);
	return Coordinates;
}

float4 GetTexColorThreeSample(sampler2D SamplerTex, float3 wsCoord,float3 vNormal)
{
    wsCoord.y = 1 - wsCoord.y; 

    float2 coord1 = wsCoord.zy;
    float2 coord2 = wsCoord.zx;
    float2 coord3 = wsCoord.xy;
   
    float4 col1 = tex2D(SamplerTex,coord1);
    float4 col2 = tex2D(SamplerTex,coord2);
    float4 col3 = tex2D(SamplerTex,coord3);
   
    float4 OutColor = col1.xyzw * vNormal.x + 
                      col2.xyzw * vNormal.y + 
                      col3.xyzw * vNormal.z;
    return OutColor;                                        
}

//Blend Methods

float3 blend_linear(float4 n1, float4 n2)
{
    float3 r = (n1 + n2);//*2 - 2;
    return normalize(r);
}

float3 blend_overlay(float4 n1, float4 n2)
{
/*
    n1 = n1*4 - 2;
    float4 a = n1 >= 0 ? -1 : 1;
    float4 b = n1 >= 0 ?  1 : 0;
    n1 =  2*a + n1;
    n2 = n2*a + b;
    float3 r = n1*n2 - a;
    return normalize(r);
	*/
	float3 r  = (n1 < 0.5 ? 2*n1*n2 : 1 - 2*(1 - n1)*(1 - n2)).xyz;
	r = normalize(r);
	return r;
}

float3 blend_pd(float4 n1, float4 n2)
{
/*
    n1 = n1*2 - 1;
    n2 = n2.xyzz*float4(2, 2, 2, 0) + float4(-1, -1, -1, 0);
    float3 r = n1.xyz*n2.z + n2.xyw*n1.z;
    return normalize(r);
*/
	float2 pd = n1.xy/n1.z + n2.xy/n2.z; // Add the PDs
	float3 r  = normalize(float3(pd, 1));
	return r;
}

float3 blend_whiteout(float4 n1, float4 n2)
{
    //n1 = n1*2 - 1;
    //n2 = n2*2 - 1;
    float3 r = float3(n1.x + n2.x, n1.y + n2.y, n1.z*n2.z);
    return normalize(r);
}

float3 blend_udn(float4 n1, float4 n2)
{
/*
    float3 c = float3(2, 1, 0);
    float3 r;
    r = n2*c.yyz + n1.xyz;
    r =  r*c.xxx -  c.xxy;
    return normalize(r);
*/
	float3 r = normalize(float3(n1.x + n2.x, n1.y + n2.y, n1.z));
	return r;
}

float3 blend_rnm(float4 n1, float4 n2)
{
    //float3 t = n1.xyz*float3( 2,  2, 2) + float3(-1, -1,  0);
    //float3 u = n2.xyz*float3(-2, -2, 2) + float3( 1,  1, -1);
	float3 t = n1.xyz;
	t.z += 1;
    float3 u = n2.xyz*float3(-1, -1, 1);
    float3 r = t*dot(t, u) - u*t.z;
    return normalize(r);
}

float3 blend_unity(float4 n1, float4 n2)
{
    //n1 = n1.xyzz*float4(2, 2, 2, -2) + float4(-1, -1, -1, 1);
    //n2 = n2*2 - 1;
	n1.w = -n1.z;
    float3 r;
    r.x = dot(n1.zxx,  n2.xyz);
    r.y = dot(n1.yzy,  n2.xyz);
    r.z = dot(n1.xyw, -n2.xyz);
    return normalize(r);
}
void CalculateMainVertexNode(MaterialVertexParameters Parameters, in out ParamsMainVertexNode MainNodeParam)
{
}
void CalculateMainPixelNode(in out MaterialPixelParameters Parameters, in out ParamsMainPixelNode MainNodeParam)
{
	float4 local2_ = tex2D(local2__Sampler, Parameters.TexCoords[0].xy);
#ifdef NORMALMAP
	local2_ = CalcNormalfromTangentSpaceTexture( local2_, Parameters);
#endif


#ifdef NORMALMAP
	bool bIsTangentNormal = false;
	bIsTangentNormal = true;
#endif
	MainNodeParam.Normal = local2_.rgb;
#ifdef NORMALMAP
	if(bIsTangentNormal)
	{
		float3x3 TangentToLocal =  GetTangentToLocalMatrix(Parameters);
		MainNodeParam.Normal = mul(MainNodeParam.Normal.xyz,TangentToLocal).xyz;
	}
#endif
	CalcMaterialNormalParams(Parameters, MainNodeParam); 
	float4 local3 = tex2D(SamplerConver, ConverUV(Parameters.WorldPosition.x, Parameters.WorldPosition.z));
	float3 local5 = local3.rgb * float3(float(1.3333), float(1.3333), float(1.3333));
	float4 local1_ = tex2D(local1__Sampler, Parameters.TexCoords[0].xy);

	local1_ = pow(abs(local1_), 2.2f);

	float3 local6 = local5 * local1_.rgb;
	MainNodeParam.Albedo = local6;
	MainNodeParam.Reflectivity = float(0);
	MainNodeParam.Fresnel = float(0);
	MainNodeParam.Roughness = float(1);
	MainNodeParam.AO = 1.0f;
	MainNodeParam.Opacity = local1_.a;
}
float GetOpacityColor(MaterialPixelParameters Parameters)
{
	float4 local1_ = tex2D(local1__Sampler, Parameters.TexCoords[0].xy);

	local1_ = pow(abs(local1_), 2.2f);

	return local1_.a;
}
float2 GetDistortion(MaterialPixelParameters Parameters)
{
	return float2(0.8f, 0.8f);
}
float GetDistortionPower(MaterialPixelParameters Parameters)
{
	return 1.0f;
}
