using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using ScriptPlugin;
using Script;
using GameEvent;

namespace PluginSample
{
    public class PluginB : IPlugin
    {
        public bool Load()
        {
            GameWorldEvent.SceneLoadedEvent += OnSceneLoaded;

            Debug.Output("B");
            return true;
        }

        public bool Unload()
        {
            GameWorldEvent.SceneLoadedEvent -= OnSceneLoaded;
            return true;
        }

        public void Update()
        {

        }

        private void OnSceneLoaded(object sender, EventArgs args)
        {
            GameWorldEvent.SceneLoadedArgs param = (GameWorldEvent.SceneLoadedArgs)args;
            string strMsg = "PluginB Get Scene Loaded [ID]: " + param.SceneID;
            Debug.Output(strMsg);

            //System.Diagnostics.Debugger.Break();

        }
    }
}
