---@class Actor
Actor = Actor or class("Actor");

function Actor:ctor(actorId)
	self.m_Id = actorId or 0;
	self.m_name = string.format("Actor_%s", string.match(tostring(self), "[^table: ]+"));
	print("Actor:ctor()", self.m_name);
end

function Actor:dtor()
    self.m_Id = 0;
	print("Actor:dtor()");
end

---@return number
function Actor:GetId()
	return self.m_Id;
end

---@param actorId number
function Actor:SetId(actorId)
	if nil ~= actorId then
		self.m_Id = actorId;
	end
end

---@return string
function Actor:GetName()
	return self.m_name;
end

---@param name string
function Actor:SetName(name)
	if name then
		self.m_name = name;
	end
end

---@return boolean 
function Actor:IsValid()
	return KLGameWorld:IsValidActor(self.m_Id);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
function Actor:SetWorldPosition(fX, fY, fZ)
	return KLGameWorld:SetActorWorldPosition(self.m_Id, fX, fY, fZ);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
---@return number fX 
---@return number fY 
---@return number fZ 
function Actor:GetWorldPosition(fX, fY, fZ)
	return KLGameWorld:GetActorWorldPosition(self.m_Id, fX, fY, fZ);
end

---@param fYaw number 
---@param fPitch number 
---@param fRoll number 
---@return boolean 
function Actor:SetWorldRotation(fYaw, fPitch, fRoll)
	return KLGameWorld:SetActorWorldRotation(self.m_Id, fYaw, fPitch, fRoll);
end

---@param fYaw number 
---@param fPitch number 
---@param fRoll number 
---@return boolean 
---@return number fYaw 
---@return number fPitch 
---@return number fRoll 
function Actor:GetWorldRotation(fYaw, fPitch, fRoll)
	return KLGameWorld:GetActorWorldRotation(self.m_Id, fYaw, fPitch, fRoll);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
function Actor:SetWorldScale(fX, fY, fZ)
	return KLGameWorld:SetActorWorldScale(self.m_Id, fX, fY, fZ);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
---@return number fX 
---@return number fY 
---@return number fZ 
function Actor:GetWorldScale(fX, fY, fZ)
	return KLGameWorld:GetActorWorldScale(self.m_Id, fX, fY, fZ);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
function Actor:SetRelativePosition(fX, fY, fZ)
	return KLGameWorld:SetActorRelativePosition(self.m_Id, fX, fY, fZ);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
---@return number fX 
---@return number fY 
---@return number fZ 
function Actor:GetRelativePosition(fX, fY, fZ)
	return KLGameWorld:GetActorRelativePosition(self.m_Id, fX, fY, fZ);
end

---@param fYaw number 
---@param fPitch number 
---@param fRoll number 
---@return boolean 
function Actor:SetRelativeRotation(fYaw, fPitch, fRoll)
	return KLGameWorld:SetActorRelativeRotation(self.m_Id, fYaw, fPitch, fRoll);
end

---@param fYaw number 
---@param fPitch number 
---@param fRoll number 
---@return boolean 
---@return number fYaw 
---@return number fPitch 
---@return number fRoll 
function Actor:GetRelativeRotation(fYaw, fPitch, fRoll)
	return KLGameWorld:GetActorRelativeRotation(self.m_Id, fYaw, fPitch, fRoll);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
function Actor:SetRelativeScale(fX, fY, fZ)
	return KLGameWorld:SetActorRelativeScale(self.m_Id, fX, fY, fZ);
end

---@param fX number 
---@param fY number 
---@param fZ number 
---@return boolean 
---@return number fX 
---@return number fY 
---@return number fZ 
function Actor:GetRelativeScale(fX, fY, fZ)
	return KLGameWorld:GetActorRelativeScale(self.m_Id, fX, fY, fZ);
end

---@param bVisible boolean 
---@return boolean 
function Actor:SetVisible(bVisible)
	return KLGameWorld:SetActorVisible(self.m_Id, bVisible);
end

---@return boolean 
function Actor:IsVisible()
	return KLGameWorld:IsActorVisible(self.m_Id);
end

---@param strModelRes string 
---@return boolean 
function Actor:SetModelRes(strModelRes)
    return KLGameWorld:SetActorModelRes(self.m_Id, strModelRes);
end
