require("Script.src.Core.Actor")

---@class GameWorld
GameWorld = GameWorld or class("GameWorld");

function GameWorld:ctor()
    self.m_actorTable = {};
end

function GameWorld:dtor()
    self.m_actorTable = nil;
end

function GameWorld:IsEditMode()
    return KLGameWorld:Instance():IsEditMode();
end

---@return Actor
function GameWorld:CreateActor()
    local actorId = KLGameWorld:CreateActor(0);
    if false == KLGameWorld:IsValidActor(actorId) then
        return nil;
    end
    local actor = Actor:new(actorId);
    self.m_actorTable[actorId] = actor;
    return actor;
end

---@param actorId number
function GameWorld:DestoryActor(actorId)
    if nil == actorId then
        return;
    end
    if true == KLGameWorld:IsValidActor(actorId) then
        KLGameWorld:DestoryActor(actorId);
    end
    self.m_actorTable[actorId] = nil;
end

---@param actorId number
---@return boolean
function GameWorld:IsValidActor(actorId)
    return KLGameWorld:IsValidActor(actorId);
end

---@param actorId number
---@return Actor
function GameWorld:GetActorById(actorId)
    return self.m_actorTable[actorId];
end

function GameWorld:GetAllActorID()
    local tbID = {};
    for key, value in pairs(self.m_actorTable) do
        table.insert(tbID, key);
    end
    return tbID;
end

---@param nScreenX number 
---@param nScreenY number 
---@param fWorldX number 
---@param fWorldY number 
---@param fWorldZ number 
---@return boolean 
---@return number fWorldX 
---@return number fWorldY 
---@return number fWorldZ 
function GameWorld:GetRayHitPointFromScreen(nScreenX, nScreenY, fWorldX, fWorldY, fWorldZ)
    return KLGameWorld:GetRayHitPointFromScreen(nScreenX, nScreenY, fWorldX, fWorldY, fWorldZ);
end

---@param worldX number 
---@param worldY number 
---@param worldZ number 
---@param screenX number 
---@param screenY number 
---@return boolean 
---@return number screenX 
---@return number screenY 
function GameWorld:WorldPosToScreenPos(worldX, worldY, worldZ, screenX, screenY)
    return KLGameWorld:WorldPosToScreenPos(worldX, worldY, worldZ, screenX, screenY);
end

---@type GameWorld
GameWorld.Instance = GameWorld:new();
