--Create By BuildApi, Create time: 2019-12-24 14:21:17 
-----------------------------------------------------------------
--enum define
-----------------------------------------------------------------
KTOUCH_EVENT={
  TOUCH_DOWN_EVENT = 'TOUCH_DOWN_EVENT',
  TOUCH_RIGHT_DOWN_EVENT = 'TOUCH_RIGHT_DOWN_EVENT',
  TOUCH_MIDDLE_DOWN_EVENT = 'TOUCH_MIDDLE_DOWN_EVENT',
  TOUCH_UP_EVENT = 'TOUCH_UP_EVENT',
  TOUCH_MOVE_EVENT = 'TOUCH_MOVE_EVENT',
  TOUCH_RIGHT_MOVE_EVENT = 'TOUCH_RIGHT_MOVE_EVENT',
  TOUCH_MIDDLE_MOVE_EVENT = 'TOUCH_MIDDLE_MOVE_EVENT',
  TOUCH_CANCEL_EVENT = 'TOUCH_CANCEL_EVENT',
  TOUCH_ZOOM_EVENT = 'TOUCH_ZOOM_EVENT',
  MOUSE_MOVE_EVENT = 'MOUSE_MOVE_EVENT'
}

-----------------------------------------------------------------
--classes define
-----------------------------------------------------------------
---@class IKEngineCore 
IKEngineCore = IKEngineCore or {}

---@return boolean 
function IKEngineCore:Init() end 

---@return boolean 
function IKEngineCore:Unint() end 

---@param deltaTime number 
function IKEngineCore:FrameMove(deltaTime) end 

function IKEngineCore:Render() end 

function IKEngineCore:RenderDebug() end 

---@param pScene IKScene 
function IKEngineCore:SetCurScene(pScene) end 

---@return IKScene 
function IKEngineCore:GetCurScene() end 

---@return IKScene 
function IKEngineCore:CreateScene() end 

---@param pScene IKScene 
---@return boolean 
function IKEngineCore:RemovScene(pScene) end 

---@param nWidth number 
---@param nHeight number 
---@return boolean 
function IKEngineCore:OnResize(nWidth, nHeight) end 

---@param pTouchListenter IKTouchMessageListener 
function IKEngineCore:AddTouchMessageListener(pTouchListenter) end 

---@param pTouchListenter IKTouchMessageListener 
function IKEngineCore:RemoveTouchMessageListener(pTouchListenter) end 

---@return number 
function IKEngineCore:GetTouchState() end 

---@return number 
function IKEngineCore:GetTouchX() end 

---@return number 
function IKEngineCore:GetTouchY() end 

---@return number 
function IKEngineCore:GetRenderViewWidth() end 

---@return number 
function IKEngineCore:GetRenderViewHeight() end 


-----------------------------------------------------------------
---@class KResource 
KResource = KResource or {}

---@return boolean 
function KResource:IsLoaded() end 

---@return virtual 
function KResource:AddRef() end 

---@return virtual 
function KResource:Release() end 

---@return virtual 
function KResource:GetRef() end 


-----------------------------------------------------------------
---@class KResourcePool 
KResourcePool = KResourcePool or {}

---@param szResName string 
---@param bMipmap boolean 
---@param bRepeat boolean 
---@param bCubeTexture boolean @default value:FALSE 
---@param bThreadLoad boolean @default value:FALSE 
---@param bPushThreadLoad boolean @default value:FALSE 
---@param bLowTexureQuality boolean @default value:FALSE 
---@return KResource 
function KResourcePool:RequestTexture(szResName, bMipmap, bRepeat, bCubeTexture, bThreadLoad, bPushThreadLoad, bLowTexureQuality) end 


-----------------------------------------------------------------
---@class KTexture : KResource
KTexture = KTexture or {}

---@return number 
function KTexture:GetId() end 


-----------------------------------------------------------------
---@class X3D 
X3D = X3D or {}

---@return KResourcePool 
function X3D.GetResourePool() end 

---@return IKEngineCore 
function X3D.GetEngineCoreInterface() end 

---@return number 
function X3D.GetLoopPastTime() end 


-----------------------------------------------------------------
--global function define
-----------------------------------------------------------------

