--Create By BuildApi, Create time: 2020-10-27 14:51:04 
-----------------------------------------------------------------
--enum define
-----------------------------------------------------------------
KLActorManager={
  Core::APhysicsConstraintActor* = 'Core::APhysicsConstraintActor*',
  Core::APhysicsRopeMeshActor* = 'Core::APhysicsRopeMeshActor*',
  ELCM_FREE = 'ELCM_FREE',
  ELCM_LIMITED = 'ELCM_LIMITED',
  ELCM_LOCKED = 'ELCM_LOCKED'
}

-----------------------------------------------------------------
--classes define
-----------------------------------------------------------------
---@class AActor 
AActor = AActor or {}

---@return string 
function AActor:GetClassName() end 

---@param bUpdate2Latest boolean @default value:false 
---@param bCreateIfNotExist boolean @default value:true 
---@return FAttributeSet 
function AActor:GetAttributeObj(bUpdate2Latest, bCreateIfNotExist) end 

---@return number 
function AActor:GetId() end 

---@return number 
function AActor:GetTemplateId() end 

---@param bVisible boolean 
---@return boolean 
function AActor:SetVisible(bVisible) end 

---@return KTransform 
function AActor:GetWorldTransform() end 

---@param f3Position KVec3 
---@param bTeleport boolean @default value:false 
---@return KVec3 f3Position 
function AActor:SetWorldPosition(f3Position, bTeleport) end 

---@param qRotation KQuaternion 
---@param bTeleport boolean @default value:false 
---@return KQuaternion qRotation 
function AActor:SetWorldRotation(qRotation, bTeleport) end 

---@param f3Position KVec3 
---@param f4Rotation KQuaternion 
---@param bTeleport boolean @default value:false 
---@return KVec3 f3Position 
---@return KQuaternion f4Rotation 
function AActor:SetWorldPositionAndRotation(f3Position, f4Rotation, bTeleport) end 

---@param f3Scale KVec3 
---@return KVec3 f3Scale 
function AActor:SetWorldScale(f3Scale) end 

---@param f3Position KVec3 
---@param bTeleport boolean @default value:false 
---@return KVec3 f3Position 
function AActor:SetLocalPosition(f3Position, bTeleport) end 

---@param qRotation KQuaternion 
---@param bTeleport boolean @default value:false 
---@return KQuaternion qRotation 
function AActor:SetLocalRotation(qRotation, bTeleport) end 

---@param f3Position KVec3 
---@param f4Rotation KQuaternion 
---@param bTeleport boolean @default value:false 
---@return KVec3 f3Position 
---@return KQuaternion f4Rotation 
function AActor:SetLocalPositionAndRotation(f3Position, f4Rotation, bTeleport) end 

---@param f3Scale KVec3 
---@return KVec3 f3Scale 
function AActor:SetLocalScale(f3Scale) end 

---@param fX number 
---@param fY number 
---@param fZ number 
---@param bTeleport boolean @default value:false 
function AActor:SetWorldPosition(fX, fY, fZ, bTeleport) end 

---@param fPitch number 
---@param fYaw number 
---@param fRoll number 
---@param bTeleport boolean @default value:false 
function AActor:SetWorldRotation(fPitch, fYaw, fRoll, bTeleport) end 

---@param fXScale number 
---@param fYScale number 
---@param fZScale number 
function AActor:SetWorldScale(fXScale, fYScale, fZScale) end 

---@param fX number 
---@param fY number 
---@param fZ number 
---@param bTeleport boolean @default value:false 
function AActor:SetLocalPosition(fX, fY, fZ, bTeleport) end 

---@param fPitch number 
---@param fYaw number 
---@param fRoll number 
---@param bTeleport boolean @default value:false 
function AActor:SetLocalRotation(fPitch, fYaw, fRoll, bTeleport) end 

---@param fXScale number 
---@param fYScale number 
---@param fZScale number 
function AActor:SetLocalScale(fXScale, fYScale, fZScale) end 

---@return KTransform 
function AActor:GetReviseTransform() end 

---@return KVec3 
function AActor:GetFaceDirection() end 

---@param dir KVec3 
---@return KVec3 dir 
function AActor:SetFaceDirection(dir) end 

---@param pParent AActor 
---@return boolean 
---@return AActor pParent 
function AActor:IsAttachedTo(pParent) end 

---@param pParent AActor 
---@param strBoneName string 
---@param eAttachRule EActorAttachRule 
---@return boolean 
---@return AActor pParent 
function AActor:AttachToBone(pParent, strBoneName, eAttachRule) end 

---@param pParent AActor 
---@param strSocketName string 
---@param eAttachRule EActorAttachRule 
---@return boolean 
---@return AActor pParent 
function AActor:AttachToSocket(pParent, strSocketName, eAttachRule) end 

---@param pParent AActor 
---@param strAnchorPoint string 
---@param eAttachRule EActorAttachRule 
---@return boolean 
---@return AActor pParent 
function AActor:AttachToAnchorPoint(pParent, strAnchorPoint, eAttachRule) end 

---@param pParent AActor 
---@param eAttachRule EActorAttachRule 
---@return boolean 
---@return AActor pParent 
function AActor:AttachToParent(pParent, eAttachRule) end 

---@param bFromParent boolean @default value:false 
---@return boolean 
function AActor:DetachFromParent(bFromParent) end 

---@return FBodyInstance 
function AActor:GetBodyInstance() end 


-----------------------------------------------------------------
---@class AEmitter : AActor
AEmitter = AEmitter or {}

---@return string 
function AEmitter:GetParticleSystemRes() end 

---@param strParticleSystemRes string 
---@param nCreateOption number @default value:0 
---@return boolean 
---@return string strParticleSystemRes 
function AEmitter:SetParticleSystemRes(strParticleSystemRes, nCreateOption) end 

---@return boolean 
function AEmitter:IsPlaying() end 

---@param bLoop boolean @default value:false 
---@return boolean 
function AEmitter:Play(bLoop) end 

---@return boolean 
function AEmitter:IsPaused() end 

---@return boolean 
function AEmitter:Pause() end 

---@return boolean 
function AEmitter:IsStopped() end 

---@return boolean 
function AEmitter:Stop() end 

---@param fSpeed number 
---@return boolean 
function AEmitter:SetPlaySpeed(fSpeed) end 

---@return number 
function AEmitter:GetPlaySpeed() end 


-----------------------------------------------------------------
---@class FPartMeshBinder 
FPartMeshBinder = FPartMeshBinder or {}

---@param nPart number 
---@return boolean 
function FPartMeshBinder:ExistPartMesh(nPart) end 

---@param nPart number 
---@param pcszMesh string 
---@param pcszSocket string 
---@return boolean 
function FPartMeshBinder:BindPartMesh(nPart, pcszMesh, pcszSocket) end 

---@param nPart number 
---@return boolean 
function FPartMeshBinder:UnBindPartMesh(nPart) end 

---@return boolean 
function FPartMeshBinder:ClearPartMesh() end 


-----------------------------------------------------------------
--global function define
-----------------------------------------------------------------
---@return string 
function GetMeshRes() end 

---@param strModelRes string 
---@return boolean 
function SetMeshRes(strModelRes) end 

---@param strJsonRes string 
---@return boolean 
---@return string strJsonRes 
function SetCollisionGeometry(strJsonRes) end 

---@param strModelRes string 
---@param t KTransform 
---@return boolean 
---@return string strModelRes 
---@return KTransform t 
function BindMeshRes(strModelRes, t) end 

---@param bDrawOutline boolean 
---@return boolean 
function SetOutlineState(bDrawOutline) end 

---@param strMeshRes string 
---@param t KTransform 
---@return boolean 
---@return string strMeshRes 
---@return KTransform t 
function CollisionDetectionWithMesh(strMeshRes, t) end 

---@param pActor AActor 
---@param t KTransform 
---@return boolean 
---@return AActor pActor 
---@return KTransform t 
function CollisionDetectionWithMesh(pActor, t) end 

---@return FPartMeshBinder 
function GetPartMeshBinder() end 

---@param strModelRes string 
---@return boolean 
function SetMeshRes(strModelRes) end 

---@param newState enuAnimState 
---@return boolean 
function ChangeAnimState(newState) end 

---@return FPartMeshBinder 
function GetPartMeshBinder() end 

---@param strModelRes string 
---@return boolean 
function SetMeshRes(strModelRes) end 

---@param newState enuAnimState 
---@return boolean 
function ChangeAnimState(newState) end 

---@param fValue number 
function SetMoveSpeedScale(fValue) end 

---@return number 
function GetMoveSpeedScale() end 

---@return FConstraintInstance 
function GetConstraintInstance() end 

---@return boolean 
function BeginControl() end 

---@return boolean 
function EndControl() end 

---@param strResPath string 
---@return boolean 
function SetupVehicle(strResPath) end 

---@param strAsset string 
---@param nWheelIndex number 
---@return boolean 
---@return string strAsset 
function SetupVehicleComponent(strAsset, nWheelIndex) end 

---@return boolean 
function BeginControl() end 

---@return boolean 
function EndControl() end 

---@param strLogicSocketName string 
---@param mNewMatrix KMatrix 
---@return boolean 
---@return string strLogicSocketName 
---@return KMatrix mNewMatrix 
function SetLogicSocketMatrix(strLogicSocketName, mNewMatrix) end 

---@return boolean 
function BeginControl() end 

---@return boolean 
function EndControl() end 

---@param bStatic boolean 
function SetStatic(bStatic) end 

---@return boolean 
function IsStatic() end 

---@return ECollisionType 
function GetCollisionType() end 

---@param eType ECollisionType 
function SetCollisionType(eType) end 

---@param bSimulate boolean 
function SetSimulatePhysics(bSimulate) end 

---@return boolean 
function IsSimulatePhysics() end 

---@param x number 
---@param y number 
---@param z number 
---@param bAddToCurrent boolean 
function SetLinearVelocity(x, y, z, bAddToCurrent) end 

---@param strJsonRes string 
---@return boolean 
---@return string strJsonRes 
function SetCollisionGeometry(strJsonRes) end 

---@param fMaxStepHeight number 
---@return boolean 
function SetMaxStepHeight(fMaxStepHeight) end 

---@param eType ELinearConstraintMotion 
function SetLinearXMotion(eType) end 

---@param eType ELinearConstraintMotion 
function SetLinearYMotion(eType) end 

---@param eType ELinearConstraintMotion 
function SetLinearZMotion(eType) end 

---@param fLinearLimit number 
---@param fContactDistance number @default value:-1.0f 
---@param fRestitution number @default value:0.0f 
function SetLinearLimit(fLinearLimit, fContactDistance, fRestitution) end 

---@param eType ELinearConstraintMotion 
function SetAngularTwistMotion(eType) end 

---@param eType ELinearConstraintMotion 
function SetAngularSwing1Motion(eType) end 

---@param eType ELinearConstraintMotion 
function SetAngularSwing2Motion(eType) end 

---@param fSwing1LimitAngle number 
function SetAngularSwing1Limit(fSwing1LimitAngle) end 

---@param fSwing2LimitAngle number 
function SetAngularSwing2Limit(fSwing2LimitAngle) end 

---@param fTwistLimitAngle number 
function SetAngularTwistLimit(fTwistLimitAngle) end 

---@param force number 
---@param torque number 
function SetBreakForce(force, torque) end 


