--Create By BuildApi, Create time: 2020-10-27 14:51:01 
-----------------------------------------------------------------
--enum define
-----------------------------------------------------------------
Core={
  EOAT_Integer = 'EOAT_Integer',
  EOAT_Bool = 'EOAT_Bool',
  EOAT_Float = 'EOAT_Float',
  EOAT_String = 'EOAT_String',
  EOAT_Array = 'EOAT_Array',
  EOAT_Struct = 'EOAT_Struct',
  EOAT_Object = 'EOAT_Object',
  EOAT_Count = 'EOAT_Count'
}

-----------------------------------------------------------------
--classes define
-----------------------------------------------------------------
---@class FAttribute 
FAttribute = FAttribute or {}

---@return string 
function FAttribute:GetDisplayName() end 

---@return string 
function FAttribute:GetCategory() end 

---@return string 
function FAttribute:GetDesc() end 

---@return boolean 
function FAttribute:IsEditorVisible() end 

---@return boolean 
function FAttribute:IsReadOnly() end 

---@return boolean 
function FAttribute:IsInRange() end 

---@return FAttributeFloatRange 
function FAttribute:GetRange() end 

---@return boolean 
function FAttribute:IsInCollection() end 

---@return FAttributeFloatCollection 
function FAttribute:GetCollection() end 

---@return string 
function FAttribute:GetName() end 

---@param nVal number 
---@param bCallback boolean @default value:true 
---@return virtual 
function FAttribute:SetInt(nVal, bCallback) end 

---@return virtual 
function FAttribute:GetInt() end 

---@param fVal number 
---@param bCallback boolean @default value:true 
---@return virtual 
function FAttribute:SetFloat(fVal, bCallback) end 

---@return virtual 
function FAttribute:GetFloat() end 

---@param pcszStr string 
---@param bCallback boolean @default value:true 
---@return virtual 
function FAttribute:SetString(pcszStr, bCallback) end 

---@return virtual 
function FAttribute:GetString() end 

---@param bVal boolean 
---@param bCallback boolean @default value:true 
---@return virtual 
function FAttribute:SetBool(bVal, bCallback) end 

---@return virtual 
function FAttribute:GetBool() end 

---@return virtual 
function FAttribute:GetChildAttrSet() end 

---@return virtual 
function FAttribute:GetArray() end 

---@return virtual 
function FAttribute:GetStruct() end 

---@return virtual 
function FAttribute:GetObject() end 


-----------------------------------------------------------------
---@class FAttributeFloatCollection 
FAttributeFloatCollection = FAttributeFloatCollection or {}

---@return number 
function FAttributeFloatCollection:GetNum() end 

---@param nIdx number 
---@return number 
function FAttributeFloatCollection:GetValue(nIdx) end 

---@param nIdx number 
---@return number 
function FAttributeFloatCollection:GetIntValue(nIdx) end 

---@param nIdx number 
---@return string 
function FAttributeFloatCollection:GetName(nIdx) end 

---@return boolean 
function FAttributeFloatCollection:IsValid() end 


-----------------------------------------------------------------
---@class FAttributeSet 
FAttributeSet = FAttributeSet or {}

---@return number 
function FAttributeSet:GetChildAttrNum() end 

---@param nIdx number 
---@return FAttribute 
function FAttributeSet:GetChildAttrByIdx(nIdx) end 

---@param pcszName string 
---@return FAttribute 
function FAttributeSet:FindChildAttrByName(pcszName) end 

---@param pcszName string 
---@param nDefault number 
---@return number 
function FAttributeSet:GetChildInteger(pcszName, nDefault) end 

---@param pcszName string 
---@param fDefault number 
---@return number 
function FAttributeSet:GetChildFloat(pcszName, fDefault) end 

---@param pcszName string 
---@param pcszDefault string 
---@return string 
function FAttributeSet:GetChildString(pcszName, pcszDefault) end 

---@param pcszName string 
---@param bDefault boolean 
---@return boolean 
function FAttributeSet:GetChildBool(pcszName, bDefault) end 

---@param pcszName string 
---@return FAttributeSet 
function FAttributeSet:GetChildArray(pcszName) end 

---@param pcszName string 
---@return FAttributeSet 
function FAttributeSet:GetChildStruct(pcszName) end 

---@param pcszName string 
---@return FAttributeSet 
function FAttributeSet:GetChildObject(pcszName) end 


-----------------------------------------------------------------
---@class FVariant 
FVariant = FVariant or {}

---@return FVariant 
function FVariant:new() end 

---@return FVariant 
function FVariant:new_local() end 

function FVariant:delete() end 

---@return virtual 
function FVariant:GetType() end 

---@return virtual 
function FVariant:GetInt() end 

---@param nVal number 
---@return virtual 
function FVariant:SetInt(nVal) end 

---@return virtual 
function FVariant:GetBool() end 

---@param bVal boolean 
---@return virtual 
function FVariant:SetBool(bVal) end 

---@return virtual 
function FVariant:GetFloat() end 

---@param fVal number 
---@return virtual 
function FVariant:SetFloat(fVal) end 

---@return virtual 
function FVariant:GetPointer() end 

---@param pVal userdata 
---@return virtual 
function FVariant:SetPointer(pVal) end 

---@return virtual 
function FVariant:GetString() end 

---@param pcszStr string 
---@return virtual 
function FVariant:SetString(pcszStr) end 

---@return virtual 
function FVariant:Clear() end 

---@return virtual 
function FVariant:Length() end 

---@param nIdx number 
---@return virtual 
function FVariant:GetVariant(nIdx) end 

---@param nVal number 
---@return virtual 
function FVariant:AddInt(nVal) end 

---@param fVal number 
---@return virtual 
function FVariant:AddFloat(fVal) end 

---@param bVal boolean 
---@return virtual 
function FVariant:AddBool(bVal) end 

---@param pVal userdata 
---@return virtual 
function FVariant:AddPointer(pVal) end 

---@param pcszVal string 
---@return virtual 
function FVariant:AddString(pcszVal) end 

---@return virtual 
function FVariant:AddArray() end 

---@return virtual 
function FVariant:AddMap() end 

---@param nIdx number 
---@return virtual 
function FVariant:GetIntByIdx(nIdx) end 

---@param nIdx number 
---@return virtual 
function FVariant:GetFloatByIdx(nIdx) end 

---@param nIdx number 
---@return virtual 
function FVariant:GetBoolByIdx(nIdx) end 

---@param nIdx number 
---@return virtual 
function FVariant:GetPointerByIdx(nIdx) end 

---@param nIdx number 
---@return virtual 
function FVariant:GetStringByIdx(nIdx) end 

---@param nIdx number 
---@return virtual 
function FVariant:GetArrayByIdx(nIdx) end 

---@param nIdx number 
---@return virtual 
function FVariant:GetMapByIdx(nIdx) end 

---@return virtual 
function FVariant:Size() end 

---@return virtual 
function FVariant:GetKeys() end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetVariant(pcszKey) end 

---@param pcszKey string 
---@param nVal number 
---@return virtual 
function FVariant:AddInt(pcszKey, nVal) end 

---@param pcszKey string 
---@param fVal number 
---@return virtual 
function FVariant:AddFloat(pcszKey, fVal) end 

---@param pcszKey string 
---@param bVal boolean 
---@return virtual 
function FVariant:AddBool(pcszKey, bVal) end 

---@param pcszKey string 
---@param pVal userdata 
---@return virtual 
function FVariant:AddPointer(pcszKey, pVal) end 

---@param pcszKey string 
---@param pcszVal string 
---@return virtual 
function FVariant:AddString(pcszKey, pcszVal) end 

---@param pcszKey string 
---@return virtual 
function FVariant:AddArray(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:AddMap(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetInt(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetFloat(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetBool(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetPointer(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetString(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetArray(pcszKey) end 

---@param pcszKey string 
---@return virtual 
function FVariant:GetMap(pcszKey) end 


-----------------------------------------------------------------
---@class FVariantArray : FVariant
FVariantArray = FVariantArray or {}

---@return FVariantArray 
function FVariantArray:new() end 

---@return FVariantArray 
function FVariantArray:new_local() end 

function FVariantArray:delete() end 


-----------------------------------------------------------------
---@class FVariantBool : FVariant
FVariantBool = FVariantBool or {}

---@return FVariantBool 
function FVariantBool:new() end 

---@return FVariantBool 
function FVariantBool:new_local() end 

function FVariantBool:delete() end 


-----------------------------------------------------------------
---@class FVariantFloat : FVariant
FVariantFloat = FVariantFloat or {}

---@return FVariantFloat 
function FVariantFloat:new() end 

---@return FVariantFloat 
function FVariantFloat:new_local() end 

function FVariantFloat:delete() end 


-----------------------------------------------------------------
---@class FVariantInteger : FVariant
FVariantInteger = FVariantInteger or {}

---@return FVariantInteger 
function FVariantInteger:new() end 

---@return FVariantInteger 
function FVariantInteger:new_local() end 

function FVariantInteger:delete() end 


-----------------------------------------------------------------
---@class FVariantMap : FVariant
FVariantMap = FVariantMap or {}

---@return FVariantMap 
function FVariantMap:new() end 

---@return FVariantMap 
function FVariantMap:new_local() end 

function FVariantMap:delete() end 


-----------------------------------------------------------------
---@class FVariantPointer : FVariant
FVariantPointer = FVariantPointer or {}

---@return FVariantPointer 
function FVariantPointer:new() end 

---@return FVariantPointer 
function FVariantPointer:new_local() end 

function FVariantPointer:delete() end 


-----------------------------------------------------------------
---@class FVariantString : FVariant
FVariantString = FVariantString or {}

---@return FVariantString 
function FVariantString:new() end 

---@return FVariantString 
function FVariantString:new_local() end 

function FVariantString:delete() end 


-----------------------------------------------------------------
--global function define
-----------------------------------------------------------------
---@return number 
function GetMax() end 

---@return boolean 
function IsValid() end 


