--Create By BuildApi, Create time: 2020-07-15 14:39:17 
-----------------------------------------------------------------
--enum define
-----------------------------------------------------------------
KTOUCH_EVENT={
  TOUCH_DOWN_EVENT = 'TOUCH_DOWN_EVENT',
  TOUCH_RIGHT_DOWN_EVENT = 'TOUCH_RIGHT_DOWN_EVENT',
  TOUCH_MIDDLE_DOWN_EVENT = 'TOUCH_MIDDLE_DOWN_EVENT',
  TOUCH_UP_EVENT = 'TOUCH_UP_EVENT',
  TOUCH_MOVE_EVENT = 'TOUCH_MOVE_EVENT',
  TOUCH_RIGHT_MOVE_EVENT = 'TOUCH_RIGHT_MOVE_EVENT',
  TOUCH_MIDDLE_MOVE_EVENT = 'TOUCH_MIDDLE_MOVE_EVENT',
  TOUCH_CANCEL_EVENT = 'TOUCH_CANCEL_EVENT',
  TOUCH_ZOOM_EVENT = 'TOUCH_ZOOM_EVENT',
  MOUSE_MOVE_EVENT = 'MOUSE_MOVE_EVENT'
}

-----------------------------------------------------------------
--classes define
-----------------------------------------------------------------
---@class IKEngineCore 
IKEngineCore = IKEngineCore or {}

---@param bMultiThreadRender number @default value:0 
---@return boolean 
function IKEngineCore:Init(bMultiThreadRender) end 

---@return boolean 
function IKEngineCore:Unint() end 

function IKEngineCore:FrameMove() end 

function IKEngineCore:ClearMainRenderBuffer() end 

function IKEngineCore:RenderDebug() end 

---@param pScene IKScene 
function IKEngineCore:RenderUIDebug(pScene) end 

---@return IKScene 
function IKEngineCore:CreateScene() end 

---@param pScene IKScene 
---@return boolean 
function IKEngineCore:RemoveScene(pScene) end 

---@param nRenderViewWidth number 
---@param nRenderViewHeight number 
---@param bMoblieQuality boolean @default value:false 
---@return boolean 
function IKEngineCore:OnResize(nRenderViewWidth, nRenderViewHeight, bMoblieQuality) end 

---@return number 
function IKEngineCore:GetScreenWidth() end 

---@return number 
function IKEngineCore:GetScreenHeight() end 

---@return number 
function IKEngineCore:GetRenderBufferWidth() end 

---@return number 
function IKEngineCore:GetRenderBufferHeight() end 

---@param pTouchListenter IKTouchMessageListener 
function IKEngineCore:AddTouchMessageListener(pTouchListenter) end 

---@param pTouchListenter IKTouchMessageListener 
function IKEngineCore:RemoveTouchMessageListener(pTouchListenter) end 

---@param pModelName string 
---@param pMtlName string 
---@param pMatWorld KMATRIX @default value:nullptr 
---@param dwOption DWORD32 @default value:0 
---@return IKModel 
function IKEngineCore:CreateModel(pModelName, pMtlName, pMatWorld, dwOption) end 

---@return IKSoundEngine 
function IKEngineCore:GetSoundEngine() end 

---@param strFileName string 
---@return DWORD32 
function IKEngineCore:CheckModelTypeByKeyWord(strFileName) end 

---@param pShell IKSoundShell 
function IKEngineCore:SetSoundShell(pShell) end 

---@return IKSoundShell 
function IKEngineCore:GetSoundShell() end 

---@return IKDynamicWeather 
function IKEngineCore:GetDynamicWeather() end 

---@return boolean 
function IKEngineCore:IsMultiThreadedRender() end 

---@param bMultiThread boolean 
function IKEngineCore:SetMultiThread(bMultiThread) end 

---@param piSrcMesh IKMesh 
---@param piDestMesh IKMesh 
---@param nSubsetCount number 
---@param cszMeshName string 
---@return IKMesh 
function IKEngineCore:MergeMesh(piSrcMesh, piDestMesh, nSubsetCount, cszMeshName) end 

---@return number 
function IKEngineCore:GetTouchState() end 

---@return number 
function IKEngineCore:GetTouchX() end 

---@return number 
function IKEngineCore:GetTouchY() end 


-----------------------------------------------------------------
---@class IKG3DModel : IKG3DResourceBase
IKG3DModel = IKG3DModel or {}

---@param pModel IKG3DModel 
---@param cszSocketName string 
---@param bPositionOnly boolean @default value:FALSE 
---@return HRESULT 
function IKG3DModel:BindToSocket(pModel, cszSocketName, bPositionOnly) end 

---@param prModel IKG3DModel 
---@param strBoneName string 
---@param bPositionOnly boolean @default value:FALSE 
---@return HRESULT 
function IKG3DModel:BindToBone(prModel, strBoneName, bPositionOnly) end 

---@param prModel IKG3DModel 
---@return HRESULT 
function IKG3DModel:BindToNone(prModel) end 

---@return HRESULT 
function IKG3DModel:UnBindFromOther() end 

---@param pModel IKG3DModel 
---@return number 
function IKG3DModel:AttachModel(pModel) end 

---@param pModel IKG3DModel 
function IKG3DModel:DetachModel(pModel) end 

---@param pSubPart string 
---@return HRESULT 
function IKG3DModel:DetachModelByPart(pSubPart) end 


-----------------------------------------------------------------
---@class IKG3DResourceBase 
IKG3DResourceBase = IKG3DResourceBase or {}

---@return ULONG 
function IKG3DResourceBase:AddRef() end 

---@return ULONG 
function IKG3DResourceBase:Release() end 

---@return ULONG 
function IKG3DResourceBase:GetRef() end 

---@return HRESULT 
function IKG3DResourceBase:Init() end 

---@return HRESULT 
function IKG3DResourceBase:UnInit() end 

---@param cszFileName string 
---@param uFileNameHash number 
---@param uOption number 
---@return HRESULT 
function IKG3DResourceBase:LoadFromFile(cszFileName, uFileNameHash, uOption) end 

---@param cszFileName string 
---@param uOption number 
---@return HRESULT 
function IKG3DResourceBase:SaveToFile(cszFileName, uOption) end 

---@return number 
function IKG3DResourceBase:GetType() end 

---@return number 
function IKG3DResourceBase:GetID() end 

---@param uOption number 
---@return HRESULT 
function IKG3DResourceBase:PrepareRender(uOption) end 

---@return HRESULT 
function IKG3DResourceBase:PostRender() end 

---@param pnMemory number 
---@param pnVideoMemory number 
---@param pnCompressMem number 
---@param pnCompressVideoMem number 
---@return HRESULT 
function IKG3DResourceBase:GetDateInformation(pnMemory, pnVideoMemory, pnCompressMem, pnCompressVideoMem) end 

---@return number 
function IKG3DResourceBase:GetLastUseTime() end 

---@return number 
function IKG3DResourceBase:GetUseFrequency() end 

---@param cszFileName string 
---@param uFileNameHash number 
---@param uOption number 
---@param WParam DWORD_PTR 
---@param LParam DWORD_PTR 
---@return HRESULT 
function IKG3DResourceBase:LoadFromFileEx(cszFileName, uFileNameHash, uOption, WParam, LParam) end 

---@param uOption number 
---@return HRESULT 
function IKG3DResourceBase:RefreshOption(uOption) end 


-----------------------------------------------------------------
---@class IKResource 
IKResource = IKResource or {}

---@return boolean 
function IKResource:IsLoaded() end 

---@return number 
function IKResource:AddRef() end 

---@return number 
function IKResource:Release() end 

---@return number 
function IKResource:GetRef() end 


-----------------------------------------------------------------
---@class IKTexture : IKResource
IKTexture = IKTexture or {}

---@return number 
function IKTexture:GetId() end 


-----------------------------------------------------------------
---@class KActorModelHelper 
KActorModelHelper = KActorModelHelper or {}

---@param pFileName string 
---@return number 
function KActorModelHelper:LoadFromFile(pFileName) end 

---@return number 
function KActorModelHelper:LoadDefaultAnimation() end 

---@return number 
function KActorModelHelper:GetRoleType() end 

---@return IKG3DModel 
function KActorModelHelper:GetActorModel() end 

---@param fX number 
---@param fY number 
---@param fZ number 
function KActorModelHelper:SetWorldPosition(fX, fY, fZ) end 

---@param fYaw number 
---@param fPitch number 
---@param fRoll number 
function KActorModelHelper:SetWorldRotation(fYaw, fPitch, fRoll) end 

---@param nPartIdx number 
---@param szMeshPath string 
---@param szBindPoint string 
---@return number 
function KActorModelHelper:BindPartMesh(nPartIdx, szMeshPath, szBindPoint) end 

---@param nPartIdx number 
---@return number 
function KActorModelHelper:UnBindPartMesh(nPartIdx) end 

function KActorModelHelper:ClearPartMesh() end 

---@return number 
function KActorModelHelper:GetId() end 

---@return number 
function KActorModelHelper:LoadDefaultAnimation() end 

---@return number 
function KActorModelHelper:GetRoleType() end 

---@param fXScale number 
---@param fYScale number 
---@param fZScale number 
function KActorModelHelper:SetWorldScale(fXScale, fYScale, fZScale) end 

---@param szFileName string 
---@param playMode number 
---@return number 
function KActorModelHelper:LoadAnimation(szFileName, playMode) end 

---@return number 
function KActorModelHelper:RegisterEventHandler() end 

---@return number 
function KActorModelHelper:UnregisterEventHandler() end 


---@param nRoleType number
---@param nType number
---@param nID number
---@param nColorID number
---@return number R
---@return number G
---@return number B
---@return number A
function KActorModelHelper:GetFaceDecalColor(nRoleType,nType,nID,nColorID)end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function KActorModelHelper:GetModelFaceCenter()end


---@param tbFaceBoneValueChoosed table
------@param nValuesCount number
function KActorModelHelper:GetFaceBoneDefinition(tbFaceBoneValueChoosed,nValuesCount)end

---@param tbFaceDecalsValueChoosed table
function KActorModelHelper:GetFaceDecalsDefinition(tbFaceDecalsValueChoosed)end

---@param tbFaceColorValueChoosed table
function KActorModelHelper:GetFaceColorsDefinition(tbFaceColorValueChoosed)end

---@param tbFaceCustomDecalValueChoosed table
function KActorModelHelper:GetFaceCustomDecalsDefinition(tbFaceCustomDecalValueChoosed)end

---@param tbFaceBoneValues table
---@param nValuesCount number
function KActorModelHelper:SetFaceBoneParams(tbFaceBoneValues,nValuesCount)end

---@param nRoleType number
---@param tbFaceDecalValues table
function KActorModelHelper:SetFaceDecal(nRoleType,tbFaceDecalValues)end

---@param nRoleType number
---@param tbFaceColorValues table
function KActorModelHelper:SetFaceColor(nRoleType,tbFaceColorValues)end

---@param nRoleType number
---@param tbFaceCustomDecalValues table
function KActorModelHelper:SetFaceCustomDecal(nRoleType,tbFaceCustomDecalValues)end

---@param szFilePath string
function KActorModelHelper:SetRandomFace(szFilePath)end

---@param szFilePath string
function KActorModelHelper:SetFaceINIFile(szFilePath)end

-----------------------------------------------------------------
---@class KG3DModel : IKG3DModel
KG3DModel = KG3DModel or {}

---@param pModel IKG3DModel 
---@param cszSocketName string 
---@param bPositionOnly boolean @default value:FALSE 
---@return HRESULT 
function KG3DModel:BindToSocket(pModel, cszSocketName, bPositionOnly) end 

---@param prModel IKG3DModel 
---@param strBoneName string 
---@param bPositionOnly boolean @default value:FALSE 
---@return HRESULT 
function KG3DModel:BindToBone(prModel, strBoneName, bPositionOnly) end 

---@param prModel IKG3DModel 
---@return HRESULT 
function KG3DModel:BindToNone(prModel) end 

---@return HRESULT 
function KG3DModel:UnBindFromOther() end 

---@param pModel IKG3DModel 
---@return number 
function KG3DModel:AttachModel(pModel) end 

---@param pModel IKG3DModel 
function KG3DModel:DetachModel(pModel) end 

---@param pSubModel string 
---@return HRESULT 
function KG3DModel:DetachModelByPart(pSubModel) end 


-----------------------------------------------------------------
---@class KLActorManager 
KLActorManager = KLActorManager or {}

---@param pcszFileName string 
---@return KActorModelHelper 
function KLActorManager.CreateActorByFile(pcszFileName) end 

---@param pcszMeshPath string 
---@return KActorModelHelper 
function KLActorManager.CreateMeshModel(pcszMeshPath) end 

---@param pActorInst KActorModelHelper 
---@return number 
function KLActorManager.DestroyActor(pActorInst) end 


-----------------------------------------------------------------
---@class KResourcePool 
KResourcePool = KResourcePool or {}

---@param szResName string 
---@param bMipmap boolean 
---@param bRepeat boolean 
---@param bCubeTexture boolean @default value:FALSE 
---@param bThreadLoad boolean @default value:FALSE 
---@param bLowTexureQuality boolean @default value:FALSE 
---@return IKTexture 
function KResourcePool:RequestTexture(szResName, bMipmap, bRepeat, bCubeTexture, bThreadLoad, bLowTexureQuality) end 


-----------------------------------------------------------------
---@class X3D 
X3D = X3D or {}

---@return KResourcePool 
function X3D.GetResourePool() end 

---@return IKEngineCore 
function X3D.GetEngineCoreInterface() end 

---@return number 
function X3D.GetLoopPastTime() end 


-----------------------------------------------------------------
--global function define
-----------------------------------------------------------------
---@param pcszResPath string 
---@return boolean 
function BrowseMapByResPath(pcszResPath) end 

---@param angle number 
---@return boolean 
function SetCameraFovAngleY(angle) end 

---@param ratio number 
---@return boolean 
function SetCameraAspectRatio(ratio) end 

---@param fNearPlane number 
---@return boolean 
function SetCameraNearPlane(fNearPlane) end 

---@param fFarPlane number 
---@return boolean 
function SetCameraFarPlane(fFarPlane) end 

---@param x number 
---@param y number 
---@param z number 
---@return boolean 
function SetPosition(x, y, z) end 

---@param x number 
---@param y number 
---@param z number 
---@return boolean 
function SetLookDir(x, y, z) end 

---@param x number 
---@param y number 
---@param z number 
---@return boolean 
function SetUpDir(x, y, z) end 

---@param pKGModel IKG3DModel 
function AddModelToScene(pKGModel) end 

---@param fX number 
---@param fY number 
---@return number 
function GetModelFromScenePos(fX, fY) end 

---@return boolean 
function DestroyCurMap() end 


