--Create By BuildApi, Create time: 2020-10-27 14:51:05 
-----------------------------------------------------------------
--enum define
-----------------------------------------------------------------
KLWEATHER_TYPE={
  NONE = 'NONE',
  SNOW = 'SNOW',
  RAIN = 'RAIN'
}

-----------------------------------------------------------------
KLEngineOption={
  KG3D_GIZMO_AXIS_COMMON = 'KG3D_GIZMO_AXIS_COMMON',
  KG3D_GIZMO_AXIS_TRANSLATION = 'KG3D_GIZMO_AXIS_TRANSLATION',
  KG3D_GIZMO_AXIS_SCALE = 'KG3D_GIZMO_AXIS_SCALE',
  KG3D_GIZMO_AXIS_ROTATION = 'KG3D_GIZMO_AXIS_ROTATION'
}

-----------------------------------------------------------------
--classes define
-----------------------------------------------------------------
---@class KLGCommands 
KLGCommands = KLGCommands or {}

---@param x number 
---@param y number 
---@param z number 
---@return string 
function KLGCommands.MoveTo(x, y, z) end 

---@return string 
function KLGCommands.ReloadConfig() end 

---@return string 
function KLGCommands.PrintAllCharacterInfo() end 

---@param dwID number 
---@return string 
function KLGCommands.AddMorLiveLink(dwID) end 

---@param dwID number 
---@return string 
function KLGCommands.RemoveMorLiveLink(dwID) end 

---@param fScale number 
---@return string 
function KLGCommands.SetDynamicWeatherSpeedScale(fScale) end 

---@param nMinite number 
---@return string 
function KLGCommands.SetDynamicWeatherStaticTime(nMinite) end 

---@param strModelRes string 
---@param x number 
---@param y number 
---@param z number 
---@return string 
function KLGCommands.CreateTestActor(strModelRes, x, y, z) end 


-----------------------------------------------------------------
---@class KLGConsole 
KLGConsole = KLGConsole or {}

---@param msg string 
---@return string 
function KLGConsole.Error(msg) end 

---@param msg string 
---@return string 
function KLGConsole.Info(msg) end 

---@param msg string 
---@return string 
function KLGConsole.Warn(msg) end 


-----------------------------------------------------------------
---@class KLGameWorld 
KLGameWorld = KLGameWorld or {}

---@return string 
function KLGameWorld.GetWorkDirectory() end 

---@return boolean 
function KLGameWorld.DestroyCurMap() end 

---@param pcszResPath string 
---@param pcszPlotPath string 
---@return boolean 
function KLGameWorld.BrowseMapByResPath(pcszResPath, pcszPlotPath) end 

---@param strBnkName string 
---@param nChannel number 
---@param nMidiNote number 
---@param nByVelocity number 
---@param nFrameOffset number 
---@return boolean 
function KLGameWorld.PlayMIDI(strBnkName, nChannel, nMidiNote, nByVelocity, nFrameOffset) end 

---@param strBnkName string 
---@param nChannel number 
---@param nMidiNote number 
---@param nByVelocity number 
---@param nFrameOffset number 
---@return boolean 
function KLGameWorld.StopMIDI(strBnkName, nChannel, nMidiNote, nByVelocity, nFrameOffset) end 

---@param nScreenX number 
---@param nScreenY number 
---@param fWorldX number 
---@param fWorldY number 
---@param fWorldZ number 
---@return boolean 
---@return number fWorldX 
---@return number fWorldY 
---@return number fWorldZ 
function KLGameWorld.GetRayHitPointFromScreen(nScreenX, nScreenY, fWorldX, fWorldY, fWorldZ) end 

---@param worldX number 
---@param worldY number 
---@param worldZ number 
---@param screenX number 
---@param screenY number 
---@return boolean 
---@return number screenX 
---@return number screenY 
function KLGameWorld.WorldPosToScreenPos(worldX, worldY, worldZ, screenX, screenY) end 

---@param f number 
---@param bUpdateProperty boolean @default value:true 
---@return boolean 
function KLGameWorld.SetCameraFovAngleY(f, bUpdateProperty) end 

---@param f number 
---@param bUpdateProperty boolean @default value:true 
---@return boolean 
function KLGameWorld.SetCameraAspectRatio(f, bUpdateProperty) end 

---@param f number 
---@param bUpdateProperty boolean @default value:true 
---@return boolean 
function KLGameWorld.SetCameraNearPlane(f, bUpdateProperty) end 

---@param f number 
---@param bUpdateProperty boolean @default value:true 
---@return boolean 
function KLGameWorld.SetCameraFarPlane(f, bUpdateProperty) end 

---@param pfFovy number @default value:NULL 
---@param pfAspect number @default value:NULL 
---@param pfNear number @default value:NULL 
---@param pfFar number @default value:NULL 
---@return boolean 
---@return number pfFovy 
---@return number pfAspect 
---@return number pfNear 
---@return number pfFar 
function KLGameWorld.GetCameraPerspective(pfFovy, pfAspect, pfNear, pfFar) end 

---@param x number 
---@param y number 
---@param z number 
---@return boolean 
---@return number x 
---@return number y 
---@return number z 
function KLGameWorld.GetCameraLookAt(x, y, z) end 

---@param pcszMode string 
function KLGameWorld.CameraSwitch(pcszMode) end 

---@return number 
function KLGameWorld.GetSimWorldSize() end 

---@return number 
function KLGameWorld.GetSimWorldOriginX() end 

---@return number 
function KLGameWorld.GetSimWorldOriginY() end 

---@return number 
function KLGameWorld.GetSimWorldZoneSize() end 

---@return number 
function KLGameWorld.GetSimWorldZoneColumns() end 

---@param x number 
---@param z number 
---@return number 
function KLGameWorld.GetSimWorldFloor(x, z) end 

---@param fScale number 
---@return boolean 
function KLGameWorld.SetPlotPlayingSpeedScale(fScale) end 

---@param nFrame number 
---@return boolean 
function KLGameWorld.SetPlotPlayingFrame(nFrame) end 

---@param nFrame number 
---@return boolean 
---@return number nFrame 
function KLGameWorld.GetPlotPlayingFrame(nFrame) end 


-----------------------------------------------------------------
---@class KLNet 
KLNet = KLNet or {}


-----------------------------------------------------------------
---@class KLWeather 
KLWeather = KLWeather or {}

---@param bEnable boolean 
---@return boolean 
function KLWeather.Enable(bEnable) end 

---@return boolean 
function KLWeather.IsEnable() end 

---@param bEnable boolean 
---@return boolean 
function KLWeather.EnableSnowCover(bEnable) end 

---@return boolean 
function KLWeather.IsEnableSnowCover() end 

---@param bEnable boolean 
---@return boolean 
function KLWeather.EnableSplash(bEnable) end 

---@return boolean 
function KLWeather.IsEnableSplash() end 

---@param bEnable boolean 
---@return boolean 
function KLWeather.EnableWaterDrop(bEnable) end 

---@return boolean 
function KLWeather.IsEnableWaterDrop() end 

---@param bEnable boolean 
---@return boolean 
function KLWeather.EnableDropShockWave(bEnable) end 

---@return boolean 
function KLWeather.IsEnableDropShockWave() end 

---@param bUse boolean 
---@return boolean 
function KLWeather.UseMaterial(bUse) end 

---@return boolean 
function KLWeather.IsUseMaterial() end 

---@param fDensity number 
---@return boolean 
function KLWeather.SetDensity(fDensity) end 

---@return number 
function KLWeather.GetDensity() end 

---@param fGate number 
---@return boolean 
function KLWeather.SetDensityGate(fGate) end 

---@return number 
function KLWeather.GetDensityGate() end 

---@param fSpeed number 
---@return boolean 
function KLWeather.SetSpeed(fSpeed) end 

---@return number 
function KLWeather.GetSpeed() end 

---@param fGate number 
---@return boolean 
function KLWeather.SetSpeedGate(fGate) end 

---@return number 
function KLWeather.GetSpeedGate() end 

---@param fLength number 
---@return boolean 
function KLWeather.SetLength(fLength) end 

---@return number 
function KLWeather.GetLength() end 

---@param fWidth number 
---@return boolean 
function KLWeather.SetWidth(fWidth) end 

---@return number 
function KLWeather.GetWidth() end 

---@param fAlpha number 
---@return boolean 
function KLWeather.SetAlpha(fAlpha) end 

---@return number 
function KLWeather.GetAlpha() end 

---@param fWind number 
---@return boolean 
function KLWeather.SetWind(fWind) end 

---@return number 
function KLWeather.GetWind() end 

---@param fAlphaFadeSpeedBegin number 
---@return boolean 
function KLWeather.SetAlphaFadeSpeedBegin(fAlphaFadeSpeedBegin) end 

---@return number 
function KLWeather.GetAlphaFadeSpeedBegin() end 

---@param fAlphaFadeSpeedEnd number 
---@return boolean 
function KLWeather.SetAlphaFadeSpeedEnd(fAlphaFadeSpeedEnd) end 

---@return number 
function KLWeather.GetAlphaFadeSpeedEnd() end 

---@param fSnowPercent number 
---@return boolean 
function KLWeather.SetSnowPercent(fSnowPercent) end 

---@return number 
function KLWeather.GetSnowPercent() end 

---@param fBrightness number 
---@return boolean 
function KLWeather.SetBrightness(fBrightness) end 

---@return number 
function KLWeather.GetBrightness() end 

---@param szTexture string 
---@return boolean 
function KLWeather.SetParticleTexture(szTexture) end 

---@return string 
function KLWeather.GetParticleTexture() end 

---@param szMaterialFile string 
---@return boolean 
function KLWeather.SetMaterialFile(szMaterialFile) end 

---@return string 
function KLWeather.GetMaterialFile() end 

---@param eType number 
---@return boolean 
function KLWeather.SetType(eType) end 

---@return number 
function KLWeather.GetType() end 

---@return boolean 
function KLWeather.Apply() end 


-----------------------------------------------------------------
--global function define
-----------------------------------------------------------------
---@param hostAddress string 
---@param hostPort number 
---@return number 
function connect(hostAddress, hostPort) end 

function tick() end 

---@return number 
function isConnected() end 

---@param nProtocolID number 
---@param msg string 
---@return number 
function sendPacketEx(nProtocolID, msg) end 

function disconnect() end 

---@return boolean 
function IsVisible() end 

---@param mTransform KTransform 
---@return boolean 
---@return KTransform mTransform 
function SetTransform(mTransform) end 

---@param mTransform KTransform 
---@return boolean 
---@return KTransform mTransform 
function GetTransform(mTransform) end 

---@param f4AxisXColor KQuaternion 
---@param f4AxisYColor KQuaternion 
---@param f4AxisZColor KQuaternion 
---@return KQuaternion f4AxisXColor 
---@return KQuaternion f4AxisYColor 
---@return KQuaternion f4AxisZColor 
function SetAxisColor(f4AxisXColor, f4AxisYColor, f4AxisZColor) end 

---@param FlipX boolean 
---@param FlipY boolean 
---@param FlipZ boolean 
function SetAxisFlip(FlipX, FlipY, FlipZ) end 

---@param pFlipX boolean 
---@param pFlipY boolean 
---@param pFlipZ boolean 
---@return boolean pFlipX 
---@return boolean pFlipY 
---@return boolean pFlipZ 
function GetAxisFlip(pFlipX, pFlipY, pFlipZ) end 

---@param fAxisLength number 
---@param fArrowScaling number 
---@return boolean 
function SetAxisScaling(fAxisLength, fArrowScaling) end 

---@param uAxisDirFlags number 
---@return boolean 
function SetSelected(uAxisDirFlags) end 

---@return number 
function GetSelected() end 

---@param eAxisType KG3D_GIZMO_AXIS_TYPE 
---@return boolean 
function SetAxisType(eAxisType) end 

---@return KG3D_GIZMO_AXIS_TYPE 
function GetAxisType() end 

---@param RayOrigin KVec3 
---@param RayDirection KVec3 
---@param pRetDistance number 
---@return number 
---@return KVec3 RayOrigin 
---@return KVec3 RayDirection 
---@return number pRetDistance 
function RayIntersectAxis(RayOrigin, RayDirection, pRetDistance) end 

---@param StartPoint KVec3 
---@param EndPoint KVec3 
---@param MidPoint KVec3 
---@return KVec3 StartPoint 
---@return KVec3 EndPoint 
---@return KVec3 MidPoint 
function SetRotationFan(StartPoint, EndPoint, MidPoint) end 

---@param enable boolean 
function EnableRotationFan(enable) end 

---@param AxisDirection KVec3 
---@param SizeRatio number 
---@return KVec3 AxisDirection 
function SetRotationRefAxis(AxisDirection, SizeRatio) end 

---@param enable boolean 
function EnableRotationRefAxis(enable) end 

---@param RayOrigin KVec3 
---@param RayDirection KVec3 
---@param pRetDis number 
---@return boolean 
---@return KVec3 RayOrigin 
---@return KVec3 RayDirection 
---@return number pRetDis 
function RayIntersectRotationSphere(RayOrigin, RayDirection, pRetDis) end 


