---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/6/28 15:22
---

---@class KArray
KArray = KArray or class("KArray")

function KArray:ctor(arr)
    self.data = {};
    if type(arr) == "table" then
        for i = 1, #arr do
            table.insert(self.data, arr[i]);
        end
    end
end

function KArray:PushBack(value)
    table.insert(self.data, value);
end

function KArray:PopBack()
    if self:IsEmpty() then
        return nil;
    end

    local ln = #self.data;
    local value = self.data[ln];
    table.remove(self.data, ln);
    return value;
end

---@return boolean
function KArray:Insert(i, value)
    local p = self.data[i];
    table.insert(self.data, i, value);
    if i ~= 1 and p == nil then      --下标为1的位置是肯定能插入的，但如果不是1，这个位置也没东西，那就插不进去了
        LOGE("KArray:Insert - invalid index %d", i);
        return false;
    else
        return true;
    end
end

---@return boolean
function KArray:Remove(i)
    if table.remove(self.data, i) == nil then
        LOGE("KArray:Remove - invalid index %d", i);
        return false;
    else
        return true;
    end
end

function KArray:IsEmpty()
    if #self.data == 0 then
        return true;
    end
    return false;
end

function KArray:Set(i, v)
    if self.data[i] == nil then
        LOGE("KArray:Set - invalid index %d", i);
        return false;
    else
        self.data[i] = v;
        return true;
    end
end

function KArray:Get(i)
    return self.data[i];
end

---@return number
function KArray:Size()
    return #self.data;
end

function KArray:Sort(func)
    if func == nil then
        table.sort(self.data);
    else
        table.sort(self.data, func);
    end
end

function KArray:Clear()
    self.data = {};
end
