function CreateEnumTable(tbEnumString, nStartIndex) 	
    local tbEnum = {ToString = {}};    
	nStartIndex	= nStartIndex or 0; 	
    for i, v in ipairs(tbEnumString) do
    	local num = nStartIndex + i - 1;
        tbEnum[v] = num;
    	assert(v ~= "ToString");
    	tbEnum.ToString[num] = v;
    end
    return tbEnum 
end 

function SplitStr(szStrConcat, szSep)
	if (not szSep) then
		szSep = ",";
	end;
	local tbStrElem = {};
	
	--תַָ
	local tbSpeSep = {
		["%."] = 1;
	};
	
	local nSepLen = tbSpeSep[szSep] or #szSep;
	local nStart = 1;
	local nAt = string.find(szStrConcat, szSep);
	while nAt do
		tbStrElem[#tbStrElem+1] = string.sub(szStrConcat, nStart, nAt - 1);
		nStart = nAt + nSepLen;
		nAt = string.find(szStrConcat, szSep, nStart);
	end
	tbStrElem[#tbStrElem+1] = string.sub(szStrConcat, nStart);
	return tbStrElem;
end

-- math.randomֵͬ 
-- 0[0, 1)
-- 1:[1, n]
-- 2:[min, max]
function Rand(...)
	math.randomseed(os.time());
	return math.random(...); 
end

function Val2Str(var, szBlank)
	local szType	= type(var);
	if (szType == "nil") then
		return "nil";
	elseif (szType == "number") then
		return tostring(var);
	elseif (szType == "string") then
		return StrVal2Str(var);
	elseif (szType == "function") then
		local szCode	= string.dump(var);
		local arByte	= {string.byte(szCode, i, #szCode)};
		szCode	= "";
		for i = 1, #arByte do
			szCode	= szCode..'\\'..arByte[i];
		end;
		return 'loadstring("' .. szCode .. '")';
	elseif (szType == "table") then
		if not szBlank then
			szBlank	= "";
		end;
		local szTbBlank	= szBlank .. "  ";
		local szCode	= "";
		for k, v in pairs(var) do
			local szPair	= szTbBlank.."[" .. Val2Str(k) .. "]	= " .. Val2Str(v, szTbBlank) .. ",\n";
			szCode	= szCode .. szPair;
		end;
		if (szCode == "") then
			return "{}";
		else
			return "\n"..szBlank.."{\n"..szCode..szBlank.."}";
		end;
	elseif szType == "boolean" then
		return var and "true" or "false";
	else	--if (szType == "userdata") then
		return '"' .. tostring(var) .. '"';
	end;
end

function StrVal2Str(szVal)
	szVal	= string.gsub(szVal, "\\", "\\\\");
	szVal	= string.gsub(szVal, '"', '\\"');
	szVal	= string.gsub(szVal, "\n", "\\n");
	szVal	= string.gsub(szVal, "\r", "\\r");
	--szVal	= string.format("%q", szVal);
	return '"'..szVal..'"';
end

function Str2Val(jsonInfo)
	local t = type(jsonInfo)
	if t == "nil" or jsonInfo == "" then
		return nil
	elseif t == "number" or t == "string" or t == "boolean" then
		jsonInfo = tostring(jsonInfo)
	else
		error("can not unserialize a " .. t .. " type.")
	end
	jsonInfo = "return " .. jsonInfo
	local func = loadstring(jsonInfo)
	if func == nil then
		return nil
	end
	return func()
end

function TableIsEmpty(t)
    return _G.next(t) == nil
end
