---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/6/12 18:04
---

local tableName = "_loader_table_";
if _G[tableName] == nil then
    _G[tableName] = {};
end
g_tab = _G[tableName];

---@param script string
---@return table
function ImportScript(script)
    print("ImportScript", script)
    local vm = g_GetLuaVM()
    local key = "FILE:" .. script;
    if g_tab[key] then
        return g_tab[key]
    end
    local mt = {__index=_G}
    local tab = {}
    setmetatable(tab, mt)
    g_tab[key] = tab
    local text = vm:LoadTextFileToString(script)
    if type(text) ~= "string" then
        print(string.format("ImportScript [%s] failed. LoadTextFileToString ret err", script))
        return nil
    end
    local fn, err = loadstring(text, script)
    if not fn then
        print(string.format("ImportScript [%s] failed. %s", script, err))
        return g_tab[key]
    end
    setfenv(fn, g_tab[key])
    fn();
    return g_tab[key];
end

function ReLoadScript(script)
    print("ReLoadScript", script)
    local vm = g_GetLuaVM()
    local key = "FILE:" .. script;
    local mt = {__index=_G}
    local tab = {}
    setmetatable(tab, mt)
    g_tab[key] = tab
    local text = vm:LoadTextFileToString(script)
    local fn, err = loadstring(text, script)
    if not fn then
        print(string.format("ReLoadScript [%s] failed. %s", script, err))
        return g_tab[key]
    end
    setfenv(fn, g_tab[key])
    fn();
    return g_tab[key]
end
