---
--- Date         : 2020-07-16 11:05:38
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-18 16:42:07
--- Description  : table patch
---

---
--- Returns the elements from the given table.
---
--- @param table table
--- @return any
---
table.unpack = function(table, ...)
    return unpack(table, ...);
end

---
--- Returns the table copied.
---
--- @param table table
--- @param recursive boolean
--- @return table
---
table.copy = function(origin, recursive, target)
    if not recursive then
        return { table.unpack(origin) };
    end

    target = target or {};
    local orig_type = type(origin);
    local copy;
    if orig_type == 'table' then
        if target[origin] then
            copy = target[origin];
        else
            copy = {};
            target[origin] = copy;
            for orig_key, orig_value in next, origin, nil do
                copy[table.copy(orig_key, recursive, target)] = table.copy(orig_value, recursive, target);
            end
            setmetatable(copy, table.copy(getmetatable(origin), recursive, target));
        end
    else
        -- number, string, boolean, function, etc
        copy = origin;
    end
    return copy;
end

---
--- жtableһάǷȣtable
---
--- @param a table
--- @param b table
--- @return boolean
---
table.equal = function(a, b)
    a = a or {};
    b = b or {};
    local bEqual = #a == #b;
    if bEqual then
        for key, value in ipairs(a) do
            if not b[key] or b[key] ~= value then
                bEqual = false;
                break;
            end
        end
    end
    return bEqual;
end
