---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/6/15 15:01
--- 
--- Modified by liaogaocan at 2020-6-30 15:37:35
--- Add function into util.
---

util = _G.util or {};

util.ExtractEssentialsFromKMS = function (szKMSPath)
    local vm = g_GetLuaVM();
    ---@type string
    local szContent = vm:LoadTextFileToString(szKMSPath);
    if nil == szContent or 0 == #szContent then
        return false, nil;
    end

    local mapPath = util.u82a(szContent:match("MapPath=\"(.-)\""));

    local cameraPos = szContent:match("CameraPos=\"(.-)\"");
    if nil == cameraPos then
        cameraPos = {0,0,0};
    end
    cameraPos = string.split(cameraPos, ",");
    for i = 1, #cameraPos do
        cameraPos[i] = tonumber(cameraPos[i]);
    end

    local tabInfo = {};
    tabInfo.MapPath = mapPath;
    tabInfo.CameraPos = cameraPos;

    return true, tabInfo;
end

---@param szJsonmapPath string
util.ReadMainCameraPositionFromJsonmap = function (szJsonmapPath)
    if nil == szJsonmapPath or 0 == #szJsonmapPath then
        return false;
    end

    local szPath = string.gsub(szJsonmapPath, "/", "\\");
    local breadcrumbs = string.split(szPath, "\\");
    if nil ~= breadcrumbs then
        table.remove(breadcrumbs);
        table.insert(breadcrumbs, "systemCamera.json");
        szPath = table.concat(breadcrumbs, "\\");
    end

    local vm = g_GetLuaVM();
    local szContent = vm:LoadTextFileToString(szPath);
    if nil == szContent or 0 == #szContent then
        return false;
    end

    local systemCameraJson = cjson.decode(szContent);
    if nil == systemCameraJson or nil == systemCameraJson.worldObjects then
        return false;
    end

    local szMainCameraUUID = "{9e484be7-0ad7-4bd9-9e57-a7c4a98d47f3}";
    local tabMainCamera = systemCameraJson.worldObjects[szMainCameraUUID];
    if nil == tabMainCamera or nil == tabMainCamera.comBasic then
        return false;
    end

    --- matrix4X4
    local localMatrix = tabMainCamera.comBasic["actorLocalMatrix"];
    if nil == localMatrix or 16 ~= #localMatrix then
        return false;
    end

    return true, {tonumber(localMatrix[13]), tonumber(localMatrix[14]), tonumber(localMatrix[15])};
end

-- print table
util.printTB = function (t, desc)
    local desc = desc or "**************print table*************\n";
    print(desc)
    local print_r_cache={}
    local function sub_print_r(t,indent)
        if (print_r_cache[tostring(t)]) then
            print(indent.."*"..tostring(t))
        else
            print_r_cache[tostring(t)]=true
            if (type(t)=="table") then
                for pos,val in pairs(t) do
                    if (type(val)=="table") then
                        print(indent.."["..pos.."] => "..tostring(t).." {")
                        sub_print_r(val,indent..string.rep(" ",string.len(pos)+8))
                        print(indent..string.rep(" ",string.len(pos)+6).."}")
                    elseif (type(val)=="string") then
                        print(indent.."["..pos..'] => "'..val..'"')
                    else
                        print(indent.."["..pos.."] => "..tostring(val))
                    end
                end
            else
                print(indent..tostring(t))
            end
        end
    end
    if (type(t)=="table") then
        print(tostring(t).." {")
        sub_print_r(t,"  ")
        print("}")
    else
        sub_print_r(t,"  ")
    end
    print()
end