---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/7/22 16:37
---

UI_ACTOR_ATTRIBUTES_DEMO = "ActorAttributesDemoUI";
local Ui = Ui or class(UI_ACTOR_ATTRIBUTES_DEMO, LUiBase);
_G.UI_ACTOR_ATTRIBUTES_DEMO = UI_ACTOR_ATTRIBUTES_DEMO;

function Ui:ctor()
    self.m_bOpen = false;
    self.m_szName = UI_ACTOR_ATTRIBUTES_DEMO;

    self.m_szWndName = util.a2u8("");
end

function Ui:dtor()
    --
end

function Ui:OnOpen()
    --
end

function Ui:OnClose()
    --
end

function Ui:GameTick()
    --
end

function Ui:GameDraw()
    ImGui.SetNextWindowSize(ImVec2(500, 500), ImGuiCond_.ImGuiCond_Always);

    _, self.m_bOpen = ImGui.Begin(self.m_szWndName, self.m_bOpen, ImGuiWindowFlags_.ImGuiWindowFlags_NoResize);
    self:draw();
    ImGui.End();
end

function Ui:draw()
    local player = g_ActorManager:GetLocalPlayer();
    local attrSet = player:GetAttributeSet();
    print("======================LOCAL PLAYER======================");
    self:drawAttrSet(attrSet, 0);
end

function Ui:drawAttrSet(attrSet, nSpaceNum)
    if attrSet == nil then
        return
    end
    local strSpace = string.rep("-", nSpaceNum);
    print(strSpace, "======ATTR SET======");
    local nAttrNum = attrSet:GetChildAttrNum();
    print(strSpace, "attr number:", nAttrNum);
    for i = 1, nAttrNum do
        local attr = attrSet:GetChildAttrByIdx(i - 1);
        local attrType = attr:GetType();
        if attr:IsEditorVisible() then
            --print("attr"..i..":", attr, attrType);
            if attrType == Core.EOAT_Integer then
                print(strSpace, attr:GetDisplayName(), "=", attr:GetInt());
            elseif attrType == Core.EOAT_Bool then
                print(strSpace, attr:GetDisplayName(), "=", attr:GetBool());
            elseif attrType == Core.EOAT_Float then
                print(strSpace, attr:GetDisplayName(), "=", attr:GetFloat());
            elseif attrType == Core.EOAT_String then
                print(strSpace, attr:GetDisplayName(), "=", attr:GetString());
            elseif attrType == Core.EOAT_Array then
                local objAttrSet = attr:GetChildAttrSet();
                print(strSpace, attr:GetDisplayName(), "=Array");
                self:drawAttrSet(objAttrSet, nSpaceNum + 4);
            elseif attrType == Core.EOAT_Struct then
                local objAttrSet = attr:GetChildAttrSet();
                print(strSpace, attr:GetDisplayName(), "=Struct");
                self:drawAttrSet(objAttrSet, nSpaceNum + 4);
            elseif attrType == Core.EOAT_Object then
                local objAttrSet = attr:GetChildAttrSet();
                print(strSpace, attr:GetDisplayName(), "=Object");
                self:drawAttrSet(objAttrSet, nSpaceNum + 4);
            end
        end
    end
end

UiInst = Ui:new();
