---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by DY.
--- DateTime: 2020/9/10 16:33
---
local ArSettingCfg = ImportScript("ugc_common/script/cases/ar_setting/config.lua").ArSettingCfg;
local Lib = ImportScript("ugc_common/script/base/lib.lua");

UI_AR_SETTING = "ArSettingUi";
local Ui = Ui or class(UI_AR_SETTING, LUiBase);
_G.UI_AR_SETTING = UI_AR_SETTING;

function Ui:ctor()
    self.m_bOpen = false;
    self.m_szName = UI_AR_SETTING

    self.m_szARSetting          = util.a2u8("AR###ARSetting")
    self.m_szSkillList          = util.a2u8("б")
    self.m_szAction             = util.a2u8("")
    self.m_szFilter             = util.a2u8("˾")
    self.m_szLight              = util.a2u8("ƹ")
    self.m_szIllumination       = util.a2u8("")
    self.m_szContinued          = util.a2u8("")
    self.m_szBlur               = util.a2u8("黯")
    self.m_szFilterDefaultValue = util.a2u8("Ĭֵ##Filter")
    self.m_szFilterStrength     = util.a2u8("ǿ")
    self.m_szFilterSoftLight    = util.a2u8("")
    self.m_szFilterHue          = util.a2u8("ɫ")
    self.m_szFilterSaturation   = util.a2u8("Ͷ")
    self.m_szFilterBrightness   = util.a2u8("")
    self.m_szMainLightSwitch    = util.a2u8("ƹܿ")
    self.m_szShowLightPosition  = util.a2u8("ʾƹλ")
    self.m_szResetLightPosition = util.a2u8("õƹ")
    self.m_szResetWindow        = util.a2u8("")
    self.m_szResetCurLight      = util.a2u8("õǰ")
    self.m_szResetAllLight      = util.a2u8("")
    self.m_szCloseLightReset    = util.a2u8("ر")
    self.m_szLightChoose        = util.a2u8("ƹѡ")
    self.m_szLightSwitch        = util.a2u8("ǰƹ")
    self.m_szCurLightTurnOn     = util.a2u8("")
    self.m_szCurLightTurnOff    = util.a2u8("ر")
    self.m_szLightDefaultValue  = util.a2u8("Ĭֵ##Light")
    self.m_szLightColor         = util.a2u8("ɫ")
    self.m_szLightStrength      = util.a2u8("ǿ")
    self.m_szLightRadius        = util.a2u8("뾶")
    self.m_szIlluminationDefaultValue   = util.a2u8("Ĭֵ##Illumination")
    self.m_szIlluminationDirectionX     = util.a2u8("շ(X)")
    self.m_szIlluminationDirectionY     = util.a2u8("շ(Y)")
    self.m_szDiffuseIntensity           = util.a2u8("ǿ")
    self.m_szSpecularIntensity          = util.a2u8("߹ǿ")
    self.m_szDiffuseColor               = util.a2u8("ɫ")
    self.m_szDiffuseColorDefaultValue   = util.a2u8("Ĭֵ##DiffuseColor")
    self.m_szSpecularColor              = util.a2u8("߹ɫ")
    self.m_szSpecularColorDefaultValue  = util.a2u8("Ĭֵ##SpecularColor")
    self.m_szEnvironmentalIntensity     = util.a2u8("ǿ")
    self.m_szEnvironmentalSaturation    = util.a2u8("Ͷ")

    self.m_tbSkillList       = {};
    self.m_tbAniList         = {};
    self.m_nCurSkillSelect   = -1
    self.m_nCurAniSelect     = -1;
    self.m_bPlayMode         = 1; -- once 
    self.m_bEnableContinued  = false;
    self.m_bEnableBlur       = false
    self.m_tbFilterList      = {}
    self.m_nCurFilter        = 1
    self.m_nFilterStrength   = 1.0
    self.m_nFilterSoftLight  = 1.0
    self.m_nFilterHue        = 0.0
    self.m_nFilterSaturation = 0.0
    self.m_nFilterBrightness = 0.0
    --ƹ
    --self.m_nMainLightSwitchState = 2
    self.m_bMarkModelVisible = false
    self.m_tbLightList       = {}
    self.m_nCurLightIndex    = 1
    self.m_nLightSwitchState = {2,2,2,2}
    self.m_tbLightColorList   = {{0.498039216,0.498039216,0.498039216,1},{0.498039216,0.498039216,0.498039216,1},{0.498039216,0.498039216,0.498039216,1},{0.498039216,0.498039216,0.498039216,1}}
    self.m_nLightStrengthList= {25,25,25,25}
    self.m_nLightRadiusList  = {200,200,200,200}
    --
    self.m_nIlluminationDirectionX = 1
    self.m_nIlluminationDirectionY = 1
    self.m_nDiffuseIntensity       = 1
    self.m_nSpecularIntensity      = 1
    self.m_nDiffuseColor           = {1.0,0.941176,0.891096,1.0}
    self.m_nSpecularColor          = {1.0,0.941176,0.891096,1.0}
    self.m_nEnvironmentalIntensity = 1
    self.m_nEnvironmentalSaturation= 1

    self:Init()
end

function Ui:dtor()
    if #self.m_tbFilterList >0 then
        while true do
            local texture = table.remove(self.m_tbFilterList,1)
            if texture then
                texture:Release()
            else break end
        end
    end
end

function Ui:Init()
    self.m_tbFilterList = ArSettingCfg:GenerateTexture()
    for i = 1, 4 do
        self.m_tbLightList[i] = util.a2u8("ƹ")..i
    end
end

function Ui:UnInit()
end

function Ui:OnOpen()
    self.m_tbSkillList = ArSettingCfg:RefreshSkillList();
    self:InitAniList();
end

function Ui:OnClose()
end

function Ui:GameTick()
end

function Ui:InitAniList()
    local lLocalPlayer = g_ActorManager:GetLocalPlayer();
    if lLocalPlayer then
        local strRoleType = lLocalPlayer:GetStrRoleType();
        strRoleType = string.lower(strRoleType);
        self.m_tbAniList = g_SchoolRoleListCfg:GetAniListByRoleType(strRoleType);
    end
end

function Ui:GameDraw()
    ImGui.SetNextWindowSize(ImVec2(800,500),ImGuiCond_.ImGuiCond_FirstUseEver)
    _, self.m_bOpen = ImGui.Begin(self.m_szARSetting, self.m_bOpen,ImGuiWindowFlags_.ImGuiWindowFlags_NoMove);

    ImGui.BeginChild("#SkillList",ImVec2(250,0),true)
    if self.m_tbSkillList ~= nil then
        for szSkillName, szSkillInfo in pairs(self.m_tbSkillList) do
            local bSelected = szSkillName == self.m_nCurSkillSelect;
            if ImGui.Selectable(util.a2u8(szSkillName), bSelected) then
                self.m_nCurSkillSelect = szSkillName;
                self:PlaySkill(szSkillInfo, 1);
            end
        end
    end
    
    ImGui.EndChild()
    ImGui.SameLine()

    ImGui.BeginChild("#Setting",ImVec2(1000,0),true)
    if ImGui.BeginTabBar("#ARSetting",ImGuiTabBarFlags_.ImGuiTabBarFlags_NoTooltip) then
        self:ActionTabItem()
        self:FilterTabItem()
        self:LightTabItem()
        self:IlluminationTabItem()
        ImGui.EndTabBar()
    end
    ImGui.EndChild()
    ImGui.End()
end

function Ui:ActionTabItem()
    if KLImGui.BeginTabItem(self.m_szAction) then
        _, self.m_bEnableContinued = ImGui.Checkbox(self.m_szContinued, self.m_bEnableContinued);
        if self.m_bEnableContinued then
            self.m_bPlayMode = 0; -- loop
        else
            self.m_bPlayMode = 1; -- once
        end

        ImGui.BeginChild("#AniList", ImVec2(500, 0), true)
        if self.m_tbAniList ~= nil then
            for szAniName, szAniInfo in pairs(self.m_tbAniList) do
                local bSelected = szAniName == self.m_nCurAniSelect
                if ImGui.Selectable(util.a2u8(szAniName), bSelected) then
                    self.m_nCurAniSelect = szAniName;
                    self:PlayAni(szAniInfo, self.m_bPlayMode);
                end
            end
        end
        g_TouchEventHandle:ScrollWhenDraggingOnVoid()
        ImGui.EndChild()

        KLImGui.EndTabItem()
    end
end

function Ui:FilterTabItem()
    if KLImGui.BeginTabItem(self.m_szFilter ) then
        ImGui.Columns(4, NULL, true);
        for i = 1,#self.m_tbFilterList do
            if ImGui.GetColumnIndex() == 0 then
                ImGui.Separator()
            end
            local id = self.m_tbFilterList[i].texture:GetId()
            local texID = KLImGui.ToImGuiTextureID(id)
            ImGui.Image(texID,ImVec2(250,200))
            if ImGui.Button(util.a2u8(self.m_tbFilterList[i].name),ImVec2(255,80)) then
                self.m_nCurFilter = i
                KLGameWorld.SetColorGrade(true,i-1,1)
            end
            ImGui.NextColumn()
        end
        ImGui.Columns(1)
        ImGui.Separator()
        self:FilterSetting()

        g_TouchEventHandle:ScrollWhenDraggingOnVoid()

        KLImGui.EndTabItem()
    end
end

function Ui:FilterSetting()
    local bEnableBlur = false
    local bStrengthChanged   = false
    local bSoftLightChanged  = false
    local bHueChanged        = false
    local bSaturationChanged = false
    local bBrightnessChanged = false
    bEnableBlur, self.m_bEnableBlur = ImGui.Checkbox(self.m_szBlur,self.m_bEnableBlur)
    ImGui.SameLine()
    if ImGui.Button(self.m_szFilterDefaultValue,ImVec2(250,65)) then
        self:FilterReset()
    end
    bStrengthChanged ,self.m_nFilterStrength    = ImGui.SliderFloat(self.m_szFilterStrength,self.m_nFilterStrength,1.0,5.0,"%.1f")
    bSoftLightChanged,self.m_nFilterSoftLight   = ImGui.SliderFloat(self.m_szFilterSoftLight,self.m_nFilterSoftLight,1.0,5.0,"%.1f")
    bHueChanged,self.m_nFilterHue               = ImGui.SliderFloat(self.m_szFilterHue,self.m_nFilterHue,-180.0,180.0,"%.1f")
    bSaturationChanged,self.m_nFilterSaturation = ImGui.SliderFloat(self.m_szFilterSaturation,self.m_nFilterSaturation,-100.0,100.0,"%.1f")
    bBrightnessChanged,self.m_nFilterBrightness = ImGui.SliderFloat(self.m_szFilterBrightness,self.m_nFilterBrightness,-100.0,100.0,"%.1f")

    self:SetFilterSetting(bEnableBlur,bStrengthChanged,bSoftLightChanged,bHueChanged,bSaturationChanged,bBrightnessChanged)
end

function Ui:LightTabItem()
    if KLImGui.BeginTabItem(self.m_szLight ) then
        self:MainLightSwitch()
        ImGui.Separator()
        ImGui.Separator()
        -- Light Choose
        if ImGui.BeginCombo(self.m_szLightChoose, self.m_tbLightList[self.m_nCurLightIndex], 1) then
            for idx, char in ipairs(self.m_tbLightList) do
                local bSelected = idx == self.m_nCurLightIndex;
                if ImGui.Selectable(char, bSelected) then
                    self.m_nCurLightIndex = idx
                end
            end
            ImGui.EndCombo();
        end
        self:CurrentLightSwitch()
        self:CurrentLightValueSetting()
        KLImGui.EndTabItem()
    end
end

function Ui:IlluminationTabItem()
    if KLImGui.BeginTabItem(self.m_szIllumination ) then
        local bIlluminationDirectionXChanged = false
        local bIlluminationDirectionYChanged = false
        local bDiffuseIntensity              = false
        local bSpecularIntensity            = false
        local bEnvironmentalIntensity        = false
        local bEnvironmentalSaturation       = false

        if ImGui.Button(self.m_szIlluminationDefaultValue,ImVec2(250,65)) then
            self:IlluminationReset()
        end
        bIlluminationDirectionXChanged,self.m_nIlluminationDirectionX = ImGui.SliderFloat(self.m_szIlluminationDirectionX,self.m_nIlluminationDirectionX,-15.0,15.0,"%.1f")
        bIlluminationDirectionYChanged,self.m_nIlluminationDirectionY = ImGui.SliderFloat(self.m_szIlluminationDirectionY,self.m_nIlluminationDirectionY,-15.0,15.0,"%.1f")
        bDiffuseIntensity,self.m_nDiffuseIntensity                    = ImGui.SliderFloat(self.m_szDiffuseIntensity,self.m_nDiffuseIntensity,1.0,100.0,"%.1f")
        bSpecularIntensity,self.m_nSpecularIntensity                  = ImGui.SliderFloat(self.m_szSpecularIntensity,self.m_nSpecularIntensity,1.0,100.0,"%.1f")
        if ImGui.ColorEdit4(self.m_szDiffuseColor,self.m_nDiffuseColor,ImGuiColorEditFlags_.ImGuiColorEditFlags_Float) then
            KLGameWorld.SetLightDiffuseColor(self.m_nDiffuseColor,#self.m_nDiffuseColor)
        end
        ImGui.Button(self.m_szDiffuseColorDefaultValue,ImVec2(250,65))
        if ImGui.ColorEdit4(self.m_szSpecularColor,self.m_nSpecularColor,ImGuiColorEditFlags_.ImGuiColorEditFlags_Float) then
            KLGameWorld.SetLightSpecularColor(self.m_nSpecularColor,#self.m_nSpecularColor)
        end
        ImGui.Button(self.m_szSpecularColorDefaultValue,ImVec2(250,65))
        bEnvironmentalIntensity,self.m_nEnvironmentalIntensity   = ImGui.SliderInt(self.m_szEnvironmentalIntensity,self.m_nEnvironmentalIntensity,-1,100)
        bEnvironmentalSaturation,self.m_nEnvironmentalSaturation = ImGui.SliderInt(self.m_szEnvironmentalSaturation,self.m_nEnvironmentalSaturation,-1,100)

        if bIlluminationDirectionXChanged or bIlluminationDirectionYChanged then
            KLGameWorld.SetLightDirXY(self.m_nIlluminationDirectionX,self.m_nIlluminationDirectionY,0)
        end

        if bDiffuseIntensity or bSpecularIntensity then
            KLGameWorld.SetLightSetting(self.m_nDiffuseIntensity,1,1,self.m_nSpecularIntensity)
        end

        if bEnvironmentalIntensity or bEnvironmentalSaturation then
            KLGameWorld.SetEnvProb(self.m_nEnvironmentalIntensity,self.m_nEnvironmentalSaturation)
        end

        KLImGui.EndTabItem()
    end
end

function Ui:FilterReset()
    self.m_nCurFilter = 1
    self.m_bEnableBlur = false

    self.m_nFilterStrength   = 1.0
    self.m_nFilterSoftLight  = 1.0
    self.m_nFilterHue        = 0.0
    self.m_nFilterSaturation = 0.0
    self.m_nFilterBrightness = 0.0

    KLGameWorld.SetColorGrade(true,self.m_nCurFilter,1)
    KLGameWorld.EnableDof(self.m_bEnableBlur)
end

function Ui:SetFilterSetting(bEnableBlur,bStrengthChanged,bSoftLightChanged,bHueChanged,bSaturationChanged,bBrightnessChanged)
    if bEnableBlur then
        KLGameWorld.EnableDof(self.m_bEnableBlur)
    end

    if bStrengthChanged then
        KLGameWorld.SetColorGrade(true,self.m_nCurFilter,self.m_nFilterStrength)
    end

    if bSoftLightChanged then
        if self.m_bEnableBlur then
            KLGameWorld.SetDofIntensity(self.m_nFilterSoftLight)
        end
    end

    if bHueChanged then
        KLGameWorld.SetHueOption(self.m_nFilterHue)
    end

    if bSaturationChanged then
        KLGameWorld.SetSaturationOption(self.m_nFilterSaturation)
    end

    if bBrightnessChanged then
        KLGameWorld.SetBrightOption(self.m_nFilterBrightness)
    end
end

function Ui:MainLightSwitch()
    ImGui.Text(self.m_szMainLightSwitch)
    if ImGui.Button(self.m_szShowLightPosition,ImVec2(350,65)) then
        if self.m_bMarkModelVisible then
            g_SceneManager:SetMarkModelVisible(false)
            self.m_szShowLightPosition = util.a2u8("ʾƹλ")
            self.m_bMarkModelVisible = false
        else
            if g_SceneManager:GetPointLightNumber() > 0 then
                g_SceneManager:SetMarkModelVisible(true)
                self.m_szShowLightPosition = util.a2u8("صƹλ")
                self.m_bMarkModelVisible = true
            end
        end
    end

    if ImGui.Button(self.m_szResetLightPosition,ImVec2(350,65)) then
        ImGui.OpenPopup(self.m_szResetWindow)
        ImGui.SetNextWindowSize(ImVec2(265, 400))
    end

    if ImGui.BeginPopupModal(self.m_szResetWindow,true,ImGuiWindowFlags_.ImGuiWindowFlags_NoResize) then
        if ImGui.Button(self.m_szResetCurLight,ImVec2(250,100)) then
            g_SceneManager:TurnOffPointLight(self.m_nCurLightIndex)
            ImGui.CloseCurrentPopup()
        end
        ImGui.Separator()
        if ImGui.Button(self.m_szResetAllLight,ImVec2(250,100)) then
            g_SceneManager:ResetAllPointLight()
            ImGui.CloseCurrentPopup()
        end
        ImGui.Separator()
        if ImGui.Button(self.m_szCloseLightReset,ImVec2(250,100)) then
            ImGui.CloseCurrentPopup()
        end
        ImGui.EndPopup()
    end
end

function Ui:CurrentLightSwitch()
    local bLightTurnOn  = false
    local bLightTurnOff = false
    ImGui.Text(self.m_szLightSwitch)
    ImGui.SameLine()
    bLightTurnOn, self.m_nLightSwitchState[self.m_nCurLightIndex] = ImGui.RadioButton(self.m_szCurLightTurnOn,self.m_nLightSwitchState[self.m_nCurLightIndex],1)
    ImGui.SameLine()
    bLightTurnOff, self.m_nLightSwitchState[self.m_nCurLightIndex] = ImGui.RadioButton(self.m_szCurLightTurnOff,self.m_nLightSwitchState[self.m_nCurLightIndex],2)

    if ImGui.Button(self.m_szLightDefaultValue,ImVec2(250,65)) then
        g_SceneManager:TurnOffPointLight(self.m_nCurLightIndex)
        g_SceneManager:TurnOnPointLight(self.m_nCurLightIndex)
        self.m_tbLightColorList[self.m_nCurLightIndex] = {0.498039216,0.498039216,0.498039216,1}
        self.m_nLightStrengthList[self.m_nCurLightIndex] = 25
        self.m_nLightRadiusList[self.m_nCurLightIndex] = 200
    end

    if bLightTurnOn then
        g_SceneManager:TurnOnPointLight(self.m_nCurLightIndex)
    end
    
    if bLightTurnOff then
        g_SceneManager:TurnOffPointLight(self.m_nCurLightIndex)
    end
end

function Ui:CurrentLightValueSetting()
    local bLightStrengthList = false
    local bLightRadius = false
    if ImGui.ColorEdit4(self.m_szLightColor,self.m_tbLightColorList[self.m_nCurLightIndex]) then
        KLGameWorld.SetPointLightColor(self.m_nCurLightIndex,self.m_tbLightColorList[self.m_nCurLightIndex],#self.m_tbLightColorList[self.m_nCurLightIndex])
    end

    bLightStrengthList, self.m_nLightStrengthList[self.m_nCurLightIndex] = ImGui.SliderInt(self.m_szLightStrength,self.m_nLightStrengthList[self.m_nCurLightIndex],0,50)
    bLightRadius, self.m_nLightRadiusList[self.m_nCurLightIndex]   = ImGui.SliderInt(self.m_szLightRadius,self.m_nLightRadiusList[self.m_nCurLightIndex],0,400)

    if bLightStrengthList then
        KLGameWorld.SetPointLightIntensity(self.m_nCurLightIndex,self.m_nLightStrengthList[self.m_nCurLightIndex])
    end

    if bLightRadius then
        KLGameWorld.SetPointLightRadius(self.m_nCurLightIndex,self.m_nLightRadiusList[self.m_nCurLightIndex])
    end
end

function Ui:IlluminationReset()
    self.m_nIlluminationDirectionX = 0
    self.m_nIlluminationDirectionY = 0
    self.m_nDiffuseIntensity       = 3.5
    self.m_nSpecularIntensity      = 3.5
    self.m_nDiffuseColor           = {1.0,0.941176,0.891096,1.0}
    self.m_nSpecularColor          = {1.0,0.941176,0.891096,1.0}
    self.m_nEnvironmentalIntensity = 1
    self.m_nEnvironmentalSaturation= 1

    KLGameWorld.SetLightDirXY(self.m_nIlluminationDirectionX,self.m_nIlluminationDirectionY,-1)
    KLGameWorld.SetLightSetting(self.m_nDiffuseIntensity, self.m_nSpecularIntensity, 0.5, 0.5);
    KLGameWorld.SetEnvProb(self.m_nEnvironmentalIntensity,self.m_nEnvironmentalSaturation)
    KLGameWorld.SetLightDiffuseColor(self.m_nDiffuseColor,#self.m_nDiffuseColor)
    KLGameWorld.SetLightSpecularColor(self.m_nSpecularColor,#self.m_nSpecularColor)
end

function Ui:PlaySkill(skillInfo, playMode)
    local lLocalPlayer = g_ActorManager:GetLocalPlayer();
    if not lLocalPlayer then
        return;
    end

    lLocalPlayer:RegisterAniEventHandler();

    local tbAni = Lib.SplitStr(skillInfo, ";");
    if tbAni[1] ~= nil then
        lLocalPlayer:LoadAnimation(tbAni[1], playMode);
        table.remove(tbAni, 1);
        if not Lib.TableIsEmpty(tbAni) then
            g_LogicManager:SetSkillQueue(tbAni);
        end
    end    
end

function Ui:PlayAni(aniInfo, playMode)
    local lLocalPlayer = g_ActorManager:GetLocalPlayer();
    if not lLocalPlayer then
        return;
    end

    if playMode == 1 then
        lLocalPlayer:RegisterAniEventHandler();
    end

    lLocalPlayer:LoadAnimation(aniInfo, playMode);
end

UiInst = Ui:new();