---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/5/28 14:23
---

local Config = Config or class("ChangeClothConfig");

local CharacterCfg = {
      -- 
      {
            Name="MatureMale",
            Desc="",
            ConfigPath="ugc_common\\settings\\character\\mesh\\m2\\",
            DefaultModel="data\\source\\player\\M2\\\\Mdl\\M2_Empty.mdl",
            DefaultParts={
                {
                    Part="Head",
                    Model="data\\source\\player\\m2\\\\M2_0000_head.mesh",
                    bHD = false,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\M2\\\\M2_new_face.Mesh",
                    bHD = false,
                },
                {
                    Part="Head",
                    Model="data\\source\\player\\M2\\\\M2_0000_head_HD.mesh",
                    bHD = true,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\M2\\\\M2_new_face_HD.Mesh",
                    bHD = true,
                },
            },
        },
        -- Ů
        {
            Name="MatureFemale",
            Desc="Ů",
            ConfigPath="ugc_common\\settings\\character\\mesh\\f2\\",
            DefaultModel="data\\source\\player\\F2\\\\Mdl\\F2_Empty.mdl",
            DefaultParts={
                {
                    Part="Head",
                    Model="data\\source\\player\\f2\\\\F2_0000_head.mesh",
                    bHD = false,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\F2\\\\f2_new_face.Mesh",
                    bHD = false,
                },
                {
                    Part="Head",
                    Model="data\\source\\player\\f2\\\\F2_0000_head_HD.mesh",
                    bHD = true,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\F2\\\\f2_new_face_HD.Mesh",
                    bHD = true,
                },
            }, 
        },
        -- ̫
        {
            Name="YoungMale",
            Desc="̫",
            ConfigPath="ugc_common\\settings\\character\\mesh\\m1\\",
            DefaultModel="data\\source\\player\\M1\\\\Mdl\\M1_Empty.mdl",
            DefaultParts={
                {
                    Part="Head",
                    Model="data\\source\\player\\m1\\\\M1_0000_head.mesh",
                    bHD = false,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\M1\\\\M1_new_face.Mesh",
                    bHD = false,
                },
                {
                    Part="Head",
                    Model="data\\source\\player\\M1\\\\M1_0000_head_HD.mesh",
                    bHD = true,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\M1\\\\M1_new_face_HD.Mesh",
                    bHD = true,
                },
            },
        },  
        -- 
        {
            Name="YoungFemale",
            Desc="",
            ConfigPath="ugc_common\\settings\\character\\mesh\\f1\\",
            DefaultModel="data\\source\\player\\F1\\\\Mdl\\F1_Empty.mdl",
            DefaultParts={
                {
                    Part="Head",
                    Model="data\\source\\player\\f1\\\\F1_0000_head.mesh",
                    bHD = false,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\F1\\\\f1_new_face.Mesh",
                    bHD = false,
                },
                {
                    Part="Head",
                    Model="data\\source\\player\\f1\\\\F1_0000_head_HD.mesh",
                    bHD = true,
                },
                {
                    Part="Face",
                    Model="data\\source\\player\\F1\\\\f1_new_face_HD.Mesh",
                    bHD = true,
                },
            },
        },
};

local PartCfg = {
    {
        Name = "head",
        Desc = "ͷ",
    },
    {
        Name = "body",
        Desc = "",
    },
    {
        Name = "leg",
        Desc = "",
    },
    {
        Name = "hand",
        Desc = "",
    },
    {
        Name = "belt",
        Desc = "",
    },
    {
        Name = "plait",
        Desc = "",
    },
    {
        Name = "bang",
        Desc = "",
    },
    {
        Name = "face",
        Desc = "",
        BindSocket = "s_face"
    },
    {
        Name = "hat",
        Desc = "ñ",
        BindSocket = "s_hat",
    },
};

function Config:ctor()
    self.m_szName = szUiName;
    self.m_tbCharPartModelList = {};
end

function Config:dtor()
    --
end

function Config:GetPartBindSocket(partIdx)
    if partIdx <= 0 or partIdx > #PartCfg then
        return "";
    end

    return PartCfg[partIdx].BindSocket or "";
end

function Config:GetCharDefaultParts(charIdx, bHD)
    if charIdx <= 0 or charIdx > #CharacterCfg then
        return {};
    end

    local tbResult = {}
    local tbCharCfg = CharacterCfg[charIdx];
    tbResult.DefaultModel = tbCharCfg.DefaultModel;
    tbResult.DefaultParts = {};
    for _, partItem in ipairs(tbCharCfg.DefaultParts) do
        if partItem.bHD == bHD then
            local nPartIdx = self:GetPartIdxByName(partItem.Part);
            LOG_I("[Config:GetCharDefaultParts], ", charIdx, bHD, partItem.Part, nPartIdx);
            if nPartIdx ~= 0 then
                table.insert(tbResult.DefaultParts, {
                    nPartIdx = nPartIdx,
                    szModelPath = partItem.Model,
                })
            end
        end
    end
    return tbResult;
end

function Config:GetCharList()
    local tbCharList = {};
    for _, cfg in ipairs(CharacterCfg) do
        local szUtf8Name = util.a2u8(cfg.Desc); -- Desc for Chinese
        table.insert(tbCharList, szUtf8Name);
    end
    return tbCharList;
end

function Config:GetPartIdxByName(partName)
    partName = string.lower(partName);
    for partIdx, cfg in ipairs(PartCfg) do
        if cfg.Name == partName then
            return partIdx;
        end
    end

    return 0;
end

function Config:GetPartList()
    local tbPartList = {};
    for _, cfg in ipairs(PartCfg) do
        local szUtf8Name = util.a2u8(cfg.Desc); -- Desc for Chinese
        table.insert(tbPartList, szUtf8Name);
    end
    return tbPartList;
end

function Config:GetSuitPartList(charIdx, szSuitKey, bEnableSD, bEnableHD)
    print()
    for partIdx, _ in ipairs(PartCfg) do
        self:loadModelListOfSpecCharPart(charIdx, partIdx);
    end

    local tbSuitPartModel = {}
    local tbPartModelList = self.m_tbCharPartModelList[charIdx];
    for partIdx, modelList in ipairs(tbPartModelList) do
        for _, modelItem in ipairs(modelList) do
            repeat
                local szLowerModelFile = string.lower(modelItem.szPath);
                local bHDModel = string.find(szLowerModelFile, "hd") ~= nil;
                if not bEnableSD and not bHDModel then
                    break;
                end
                if not bEnableHD and bHDModel then
                    break;
                end
                local foundPos = string.find(modelItem.szPath, szSuitKey);
                if foundPos ~= nil then
                    tbSuitPartModel[partIdx] = modelItem.szPath;
                    break
                end
            until true
        end
    end
    return tbSuitPartModel;
end

function Config:GetModelListOfSpecCharPart(charIdx, partIdx)
    self:loadModelListOfSpecCharPart(charIdx, partIdx);
    return self.m_tbCharPartModelList[charIdx][partIdx];
end

function Config:isValidModelFileSuffix(szModelFile, filePattern)
    local _, endIdx = string.find(szModelFile, filePattern);
    if endIdx == nil then
        return false;
    end

    return string.len(szModelFile) == endIdx;
end

function Config:GetSuitKeyOfModelFile(szModelFile)
    local firstPos = string.find(szModelFile, "_");
    if firstPos == nil then
        return;
    end
    local secondPos = string.find(szModelFile, "_", firstPos + 1);
    if secondPos == nil then
        return;
    end
    local szSuitKey = string.sub(szModelFile, firstPos, secondPos);
    if szSuitKey == nil or string.len(szSuitKey) <= 0 then
        return;
    end

    return szSuitKey;
end

function Config:getModelFileNameWithoutExt(szModelFile)
    szModelFile = string.lower(szModelFile);
    local ext = ".mesh";
    local _, endIdx = string.find(szModelFile, ext);
    if endIdx == string.len(szModelFile) then
        return string.sub(szModelFile, 1, string.len(szModelFile) - string.len(ext));
    end
    return szModelFile;
end

function Config:getCharPartConfigFilePath(charIdx, partIdx)
    local tbCharCfg = CharacterCfg[charIdx];
    local tbPartCfg = PartCfg[partIdx];
    if tbCharCfg == nil or tbPartCfg == nil then
        return;
    end

    local szCfgPath = tbCharCfg.ConfigPath..tbPartCfg.Name..".txt";
    --szCfgPath = KLGameWorld.GetWorkDirectory().."\\"..szCfgPath;
    return szCfgPath;
end

function Config:loadModelListOfSpecCharPart(charIdx, partIdx)
    local tbCharCfg = CharacterCfg[charIdx];
    local tbPartCfg = PartCfg[partIdx];
    if tbCharCfg == nil or tbPartCfg == nil then
        return;
    end

    local tbPartModelLists = self.m_tbCharPartModelList[charIdx];
    if tbPartModelLists == nil then
        tbPartModelLists = {};
        self.m_tbCharPartModelList[charIdx] = tbPartModelLists;
    end
    if tbPartModelLists[partIdx] then
        return;
    end

    local szCfgPath = self:getCharPartConfigFilePath(charIdx, partIdx);
    LOG_I("[Config:loadModelListOfSpecCharPart] ", charIdx, partIdx, szCfgPath);
    if szCfgPath == nil then
        return;
    end
    local tabFile = LTabFile:new(szCfgPath);
    if not tabFile:IsValid() then
        return;
    end
    local tbModelFileList = {};
    local nRowCount = tabFile:GetRowCount();
    local nNameColIdx = tabFile:GetColIdxByName("Name");
    local nPathColIdx = tabFile:GetColIdxByName("Path");
    LOG_I("[Config:loadModelListOfSpecCharPart] nRowCount", nRowCount);
    for i = 1, nRowCount do
        local szName = tabFile:GetString(i, nNameColIdx, nil);
        local szPath = tabFile:GetString(i, nPathColIdx, nil);
        if szName ~= nil and szPath ~= nil then
            local tbModelItem = {}
            tbModelItem.szPath = szPath;
            tbModelItem.szUtf8Name = util.a2u8(szName);
            table.insert(tbModelFileList, tbModelItem);
        end
    end
    tbPartModelLists[partIdx] = tbModelFileList;
    return true;
end

Cfg = Config:new();
