
local MODEL_PATH          = FS.Path.Join(FS.GetCwd(), "data/source/Home/building/AREA/JN");
local MODEL_PART_EXT      = ".group";

GetModels = function()
    local models = {};

    FS.Walk(MODEL_PATH, function(current, dirs, files)
        while true do
            local file = table.remove(files, 1);
            if file and string.lower(FS.Path.SplitExt(file)) == MODEL_PART_EXT then
                local path = FS.Path.Join(current, file);
                table.insert(models, path);
            end
            if file == nil then
                break;
            end
            if #models > 1 then
                break;
            end
        end
    end);
    return models;
end
