
local Dataset       = ReLoadScript("ugc_common/script/cases/destruction/dataset.lua");
local Config        = ReLoadScript("ugc_common/script/cases/destruction/config.lua");

_G.UI_DESTRUCTION   = "Destruction";
local Ui            = Ui or class(_G.UI_DESTRUCTION, LUiBase);

function Ui:ctor()
    self.m_bOpen    = false;
    self.m_bVisible = true;
    self.m_szName   = _G.UI_DESTRUCTION;
    self.m_szTitle  = util.a2u8("");
    self.m_tabStyle = {
        size    = ImVec2:new_local(600, 860),
        wndFlag = bit.ors(
            ImGuiWindowFlags_.ImGuiWindowFlags_NoResize,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoCollapse,
            -- ImGuiWindowFlags_.ImGuiWindowFlags_NoTitleBar,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoScrollbar
            -- ImGuiWindowFlags_.ImGuiWindowFlags_NoMove
        ),
    };
end

function Ui:dtor()
    self.m_bOpen = false;
end

function Ui:SetOpenClose(bOpen)
    self.m_bOpen = bOpen or false;
end

function Ui:IsOpen()
    return self.m_bOpen;
end

function Ui:GameDraw()
    if self.m_bVisible then
        DrawUI(self);
    end
end

function DrawUI(self)
    local DISTANCE         = 20.0;
    local window_pos       = ImVec2:new_local(0.0, 20.0);
    local window_pos_pivot = ImVec2:new_local(0.0, 0.0);
    local window_size      = ImVec2:new_local(600, 800);
    local style            = self.m_tabStyle;
    local selected      = nil;

    if (self.m_io) then
        window_pos.x  = self.m_io.DisplaySize.x - DISTANCE;
        window_pos.y  = self.m_io.DisplaySize.y - DISTANCE;
        window_size.x = self.m_io.DisplaySize.x - DISTANCE;
        window_size.y = self.m_io.DisplaySize.y - DISTANCE;
    end

    -- ImGui.SetNextWindowPos(window_pos, ImGuiCond_.ImGuiCond_Always, window_pos_pivot);
    ImGui.SetNextWindowSize(window_size, ImGuiCond_.ImGuiCond_Always);

    _, self.m_bOpen = ImGui.Begin(self.m_szTitle, self.m_bOpen, style.wndFlag);

        if self.m_page and self.m_page.DrawUI then
            self.m_page:DrawUI(self);
        end

        self.m_buildingModels      = Dataset.GetModels();
        selected = DrawModelUI("#building", self.m_buildingModels, ImVec2:new_local(135, 170));

    ImGui.End();
end

---
--- ģб
---
--- @param id string
--- @param models table<string, Modelpath>
--- @param size ImVec2
--- @return LBaseAssemble | nil
---
function DrawModelUI(id, models, size)
    local selected  = nil;
    local nMaxIndex = #models;
    ImGui.Columns(4, id, false);
    for key, model in ipairs(models) do
        if ImGui.Button(FS.Path.SplitFile(model), size) then
            selected = model;
            Config.Cfg:createModel();
        end
        if key < nMaxIndex then
            ImGui.NextColumn();
        end
    end
    ImGui.Columns(1);
    return selected;
end

UiInst = Ui:new();
