
---@class Editing
Editing = Editing or class("Editing");

ResArr = {
    Default = "\\UGCSource\\player\\DefaultModel.actor",
    F1      = "\\UGCSource\\player\\F1_Model.actor",
    F2      = "\\UGCSource\\player\\F2_Model.actor",
    M1      = "\\UGCSource\\player\\M1_Model.actor",
    M2      = "\\UGCSource\\player\\M2_Model.actor"
};



function Editing:ctor()
    ---@type Actor
    self.m_actor = nil;
    self.m_selectedRes = nil;
    self.m_bWantPlace = false;
end

function Editing:dtor()

end

function Editing:GameTick()
    if self.m_bWantPlace == true and self.m_actor then
        -- ---@type ImVec2
        local mousePos = ImGui.GetMousePos();
        local bOK,wx,wy,wz = KLGameWorld.GetRayHitPointFromScreen(mousePos.x, mousePos.y, 0, 0, 0);
        if true == bOK then
            self.m_actor:SetWorldPosition(wx, wy, wz);
        end

        if true == ImGui.IsMouseClicked(ImGuiMouseButton_.ImGuiMouseButton_Left) then
            self:EndPlace();
        elseif true == ImGui.IsMouseClicked(ImGuiMouseButton_.ImGuiMouseButton_Right) then
            self:DiscardPlace();
        end
    end
end

function Editing:RenderTick()
    ImGui.Begin("Objects");
    ImGui.BeginChild("Object List", ImVec2(200, 800), true);
    for k,v in pairs(ResArr) do
        if ImGui.Selectable(k, false) == true then
            print(string.format("%s -> %s", k, v));
            -- Here you should tell the game world enter editing mode.
            self:BeginPlace(v);
        end
    end
    ImGui.EndChild();
    ImGui.End();
end

---@param resPath string
function Editing:BeginPlace(resPath)
    if self.m_selectedRes ~= resPath then
        self.m_actor = g_ActorManager:CreateActor(resPath);
        self.m_actor:SetVisible(true);
        self.m_selectedRes = resPath;
    end
    self.m_bWantPlace = true;
end

function Editing:EndPlace()
    self.m_actor = nil;
    self.m_selectedRes = nil;
    self.m_bWantPlace = false;
end

function Editing:DiscardPlace()
    if nil ~= self.m_actor then
        g_ActorManager:DestroyActor(self.m_actor);
        self.m_actor = nil
    end
    self:EndPlace();
end

Editing.Instance = Editing:new();

