---
--- Date         : 2020-07-13 09:55:47
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-17 10:54:55
--- Description  : 
---
_G.UI_FLIGHT_LIST = "FlightList";
local Ui         = Ui or class(_G.UI_FLIGHT_LIST, LUiBase);
local ModelPanel = ReLoadScript("ugc_common/script/cases/flight_list/model_panel.lua").ModelPanel;
local Dataset    = ReLoadScript("ugc_common/script/cases/flight_list/dataset.lua");

function Ui:ctor()
    self.m_bOpen        = false;
    self.m_szName       = _G.UI_FLIGHT_LIST;
    self.m_szTitle      = util.a2u8("");
    self.m_currentModel = nil;
    self.m_tabModels    = Dataset.GetUserModels();
    self.m_style_table  = {
        size = ImVec2(600, 700),
    };
    self.dataTable = self:GetDataTable();
    self.dataTable.m_lMeshActor = nil;
    self.dataTable.m_lTrailEmitter1 = nil;
    self.dataTable.m_lTrailEmitter2 = nil;
    self.dataTable.m_NitroEmitter = nil;
    self.m_tabUiText  = {
        closeBtn      = util.a2u8("˳"),
        headerTip     = util.a2u8("бѡһʻ"),
        headerSepText = util.a2u8("õķ"),
    };

    self.m_szTrail1EmitterRes = "data/source/other/Ч//Pss//Q_Ṧb.pss";
    self.m_szTrail2EmitterRes = "data/source/other/Ч//Pss//S_˫Ṧβ01.pss";
    self.m_szNitroEmitterRes = "UGCSource/particle/.pss";
end

function Ui:dtor()
    self.m_bOpen = false;
end

function Ui:GetName()
    return self.m_szName;
end

function Ui:OnOpen()
    --
end

function Ui:OnClose()
    --
end

function Ui:UseFlightModel(flight)
    if self.dataTable.m_lMeshActor ~= nil then
        return;
    end
    local lPlayer = g_ActorManager:GetLocalPlayer();
    local _, x, y, z  = lPlayer:GetWorldPosition();
    local pitch, yaw, roll  = lPlayer:GetWorldRotation();
    self.dataTable.m_lMeshActor = g_ActorManager:CreateSimpleFlightActor("data\\source\\item\\prop\\D007393_HD.Mesh");
    self.dataTable.m_lMeshActor:SetWorldPosition(x, y + 300, z);
    self.dataTable.m_lMeshActor:SetWorldRotation(0, yaw, 0);

    self.dataTable.m_lMeshActor:SetCollisionType(Core.QueryAndPhysics);
    self.dataTable.m_lMeshActor:BeginControl();
    lPlayer:AttachToParent(self.dataTable.m_lMeshActor, Core.eAR_SnapToTarget);
    lPlayer:SetLocalPosition(50, 0, 0);
    lPlayer:SetLocalRotation(0, -90, 0);

    local faceDir = KVec3:new_local(1, 0, 0);
    self.dataTable.m_lMeshActor:SetFaceDirection(faceDir);
    KLGameWorld.CameraSwitch("first_person");

    self.dataTable.m_lTrailEmitter1 = g_ActorManager:CreateEmitter(self.m_szTrail1EmitterRes);
    self.dataTable.m_lTrailEmitter1:AttachToParent(self.dataTable.m_lMeshActor);

    self.dataTable.m_lTrailEmitter2 = g_ActorManager:CreateEmitter(self.m_szTrail2EmitterRes);
    self.dataTable.m_lTrailEmitter2:AttachToParent(self.dataTable.m_lMeshActor);
    self.dataTable.m_lTrailEmitter2:Stop();

    self.dataTable.m_NitroEmitter = g_ActorManager:CreateEmitter(self.m_szNitroEmitterRes);
    self.dataTable.m_NitroEmitter:AttachToParent(self.dataTable.m_lMeshActor);
    self.dataTable.m_NitroEmitter:Stop();
    self.dataTable.m_NitroEmitter:SetLocalRotation(0, -90, 0);

    g_EventDispatcherManager:AddEventListener("Flight", "NitroStart", self.OnNitroStart, self);
    g_EventDispatcherManager:AddEventListener("Flight", "NitroEnd", self.NitroEnd, self);

    g_NetWorking:EntityCreated(g_NetWorking.ENTITY_TYPE_FLIGHT, self.dataTable.m_lMeshActor:GetId(), flight.path);
end

function Ui:CloseFlightModel()
    g_EventDispatcherManager:RemoveEventListener("Flight", "NitroStart", self.OnNitroStart, self);
    g_EventDispatcherManager:RemoveEventListener("Flight", "NitroEnd", self.NitroEnd, self);

    if not self.dataTable.m_lMeshActor then
        return;
    end

    local lPlayer = g_ActorManager:GetLocalPlayer();
    self.dataTable.m_lMeshActor:EndControl();
    lPlayer:DetachFromParent();

    local pitch, yaw, roll = lPlayer:GetLocalRotation();
    lPlayer:SetLocalRotation(0, yaw, 0);

    g_NetWorking:EntityDeleted(self.dataTable.m_lMeshActor:GetId());
    g_ActorManager:DestroyActor(self.dataTable.m_lMeshActor);
    self.dataTable.m_lMeshActor = nil;
    if self.dataTable.m_lTrailEmitter1 ~= nil then
        g_ActorManager:DestroyActor(self.dataTable.m_lTrailEmitter1);
        self.dataTable.m_lTrailEmitter1 = nil;
    end
    if self.dataTable.m_lTrailEmitter2 ~= nil then
        g_ActorManager:DestroyActor(self.dataTable.m_lTrailEmitter2);
        self.dataTable.m_lTrailEmitter2 = nil;
    end
    if self.dataTable.m_NitroEmitter ~= nil then
        g_ActorManager:DestroyActor(self.dataTable.m_NitroEmitter);
        self.dataTable.m_NitroEmitter = nil;
    end

    KLGameWorld.CameraSwitch("role");
end

function Ui:OnNitroStart()
    print("OnNitroStart")
    if not self.dataTable.m_lMeshActor then
        return;
    end
    if self.dataTable.m_NitroEmitter ~= nil then
        self.dataTable.m_NitroEmitter:Play(false);
    end

    if self.dataTable.m_lTrailEmitter1 ~= nil then
        self.dataTable.m_lTrailEmitter1:Stop();
    end
    if self.dataTable.m_lTrailEmitter2 ~= nil then
        self.dataTable.m_lTrailEmitter2:Play(true);
    end
end

function Ui:NitroEnd()
    print("NitroEnd")
    if not self.dataTable.m_lMeshActor then
        return;
    end
    if self.dataTable.m_NitroEmitter ~= nil then
        self.dataTable.m_NitroEmitter:Stop();
    end
    if self.dataTable.m_lTrailEmitter1 ~= nil then
        self.dataTable.m_lTrailEmitter1:Play(true);
    end
    if self.dataTable.m_lTrailEmitter2 ~= nil then
        self.dataTable.m_lTrailEmitter2:Stop();
    end
end

function Ui:GameDraw()
    local style_table = self.m_style_table;

    ImGui.SetNextWindowSize(style_table.size, ImGuiCond_.ImGuiCond_Always);
    _, self.m_bOpen = ImGui.Begin(self.m_szTitle, self.m_bOpen, ImGuiWindowFlags_.ImGuiWindowFlags_NoResize);
        if ImGui.Button(self.m_tabUiText.closeBtn, ImVec2(60, 20)) then
            self:CloseFlightModel();
        end
        ImGui.SameLine();
        ImGui.Text(self.m_tabUiText.headerTip);
        ImGui.Separator();
        ModelPanel(self);
    ImGui.End();
end

UiInst = Ui.new();
