---
--- Generated manually.
--- Created by liaogaocan.
--- DateTime: 2020-6-17 19:53:23
---

local Combo = ImportScript("ugc_common/script/core/ui/imguiex/combo.lua").Combo;
local GameSettingConfig = ImportScript("ugc_common/script/cases/game_setting/config.lua").GameSettingConfig

UI_GAME_SETTING = "GameSettingUi";
local Ui = Ui or class(UI_GAME_SETTING, LUiBase);
_G.UI_GAME_SETTING = UI_GAME_SETTING;


function Ui:ctor()
    self.m_bOpen = false;
    self.m_szName = UI_GAME_SETTING

    self.m_szTitle = util.a2u8("");

    self.m_comboMoveSpeed = Combo:new("", 1, {"X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8"});
    self.m_comboKMSCSpeed = Combo:new("KMSCٶ", 5, {"X0", "X0.125", "X0.25", "X0.5", "X1", "X2", "X4", "X8"});
    self.m_comboWeatherType = Combo:new("", 1, {"", "ѩ", ""});
    self.m_comboWeatherIntensity = Combo:new("ǿ", 1, {"", "", ""});
    self.m_comboWindIntensity = Combo:new("", 1, {"", "", "", ""});
    self.m_comboViewDistance = Combo:new("Ӿ", 2, {"200M", "1000M", "8000M", "60000M"});
    self.m_comboShadowQuality = Combo:new("Ӱ", 4, {"", "", "", ""});
    self.m_comboWaterQuality = Combo:new("ˮ", 3, {"", "", ""});
    self.m_comboAA = Combo:new("", 1, {"", ""});

    -- mobile engine options
    self.m_szFog = "EnableFog";
    self.m_szOccludeQuerry = "EnableOccludeQuerry";
    self.m_szTerrain = "RenderTerrain";
    self.m_szTerrainGrid = util.a2u8("");
    self.m_szContainerBox = util.a2u8("");
    self.m_szGBuffer = "RenderGbuffer";
    self.m_szModelStBox = "RenderModelStBox";
    self.m_szModelBox = "RenderModelBox";
    self.m_szBone = "RenderBone";
    self.m_szOccludedBox = "RenderOccludedBox";
    self.m_szPlant = "RenderPlant";
    self.m_szWater = "RenderWater";
    self.m_szPointLight = "RenderPointLight";
    self.m_szPostRender_dof = "PostRenderDof";
    self.m_szPostRender_bloom = "PostRenderBloom";
    self.m_szAO = "EnableAO";
    self.m_szShockWave = "EnableShockWave";
    self.m_szSSR = "EnableSSR";
    self.m_szCpuProfile = "EnableCpuProfile";
    self.m_szMultiThreadRender = "EnableMultiThreadRender";
    
    self.m_szShadowQuality = util.a2u8("Ӱ");
    self.m_tbShadowQuality = {};
    self.m_szFoliageDensity = "FoliageDensity";
    self.m_szCullAngleLimit = "CullAngleLimit";
    self.m_szLodLevel = "LodLevel";
    self.m_szExposure = "Exposure";
    self.m_szSizeLimit = "SizeLimit";
    self.m_szAngleLimit = "AngleLimit";
    self.m_szReloadShader = "ReloadShader";
    self.m_szReloadInspackShader = "ReloadInspackShader";

    self.m_bEnableFog = false;
    self.m_bEnableOccludeQuerry = false;
    self.m_bEnableTerrain = false;
    self.m_bEnableTerrainGrid = false;
    self.m_bEnableContainerBox = false;
    self.m_bEnableGBuffer = false;
    self.m_bEnableModelStBox = false;
    self.m_bEnableModelBox = false;
    self.m_bEnableBone = false;
    self.m_bEnableOccludedBox = false;
    self.m_bEnablePlant = false;
    self.m_bEnableWater = false;
    self.m_bEnablePointLight = false;
    self.m_bEnablePostRenderDof = false;
    self.m_bEnablePostRenderBloom = false;
    self.m_bEnableAO = false;
    self.m_bEnableShockWave = false;
    self.m_bEnableSSR = false;
    self.m_bEnableCpuProfile = false;
    self.m_bEnableMultiThreadRender = false;
    self.m_nShadowQualityIdx = 1;
    self.m_nFoliageDensity = 0;
    self.m_nCullAngleLimit = 0;
    self.m_nLodLevel = 0;
    self.m_nExposure = 0;
    self.m_nSizeLimit = 0;
    self.m_nAngleLimit = 0;
end

function Ui:dtor()
    --
end

function Ui:OnOpen()
    self.m_tbShadowQuality = GameSettingConfig:GetShadowQuality();
    self:GetEngineOptions();
end

function Ui:OnClose()
    --
end

-- ---@return string
-- function Ui:GetName()
--     return self.m_szName;
-- end
-- ---@return table
-- function Ui:GetDataTable()
--     local uiDataTable =  g_dataTable:GetUiTable();
--     if uiDataTable[self.m_szName] == nil then
--         uiDataTable[self.m_szName] = {}
--     end
--     return uiDataTable[self.m_szName];
-- end
-- ---@param bOpen boolean
-- function Ui:SetOpenClose(bOpen)
--     bOpen = bOpen or false;
--     self.m_bOpen = bOpen;
-- end
-- ---@return boolean
-- function Ui:IsOpen()
--     return self.m_bOpen == true;
-- end
-- function Ui:OnOpen()
-- end
-- function Ui:OnClose()
-- end
-- function Ui:GameTick()
-- end

function Ui:GameDraw()
    _, self.m_bOpen = ImGui.Begin(self.m_szTitle, self.m_bOpen);
    
    if PLATFORM_PC then
        self:draw();
    else
        self:RenderEngineOptions();
    end
    
    ImGui.End();
end

function Ui:draw()
    local bChanged, nIdx, itemValue = self.m_comboMoveSpeed:Draw();
    if true == bChanged then
        local player = g_ActorManager:GetLocalPlayer();
        if nil ~= player then
            -- player = tolua.cast(player.m_kSkeletalMeshActor, "Core::ALocalPlayer");
            player:SetMoveSpeedScale(tonumber(itemValue:sub(2)) or 1);
        end
    end

    bChanged, nIdx, itemValue = self.m_comboKMSCSpeed:Draw();
    if true == bChanged then
        KLGameWorld.SetPlotPlayingSpeedScale(tonumber(itemValue:sub(2)) or 1);
    end

    bChanged, nIdx, _ = self.m_comboWeatherType:Draw();
    if true == bChanged then
        self:onWeatherTypeChanged(nIdx);
    end

    bChanged, nIdx, _ = self.m_comboWeatherIntensity:Draw();
    if true == bChanged then
        self:onWeatherIntensityChanged(nIdx);
    end

    bChanged, nIdx, _ = self.m_comboWindIntensity:Draw();
    if true == bChanged then
        self:onWeatherWindSpeedChanged(nIdx);
    end

    bChanged, _, itemValue = self.m_comboViewDistance:Draw();
    if true == bChanged then
        local far = tonumber(itemValue:match("%d+")) or 1000;
        far = far * 100;
        g_CameraController:SetFarPlane(far);
    end

    bChanged, nIdx, _ = self.m_comboShadowQuality:Draw();
    if true == bChanged then
        self:onShadowQualityChanged(nIdx);
    end

    bChanged, nIdx, _ = self.m_comboWaterQuality:Draw();
    if true == bChanged then
        self:onWaterEffectLevelChanged(nIdx);
    end

    bChanged, nIdx, _ = self.m_comboAA:Draw();
    if true == bChanged then
        self:onEnableAAChanged(nIdx);
    end
end

function Ui:onWeatherTypeChanged(nType)
    --·Ͳ·ǿյĻͳһʹĬ
    local bUseMaterial = g_Weather:IsUseMaterial();
    local strMaterialFile = g_Weather:GetMaterialFile();
    local strParticleTexture = g_Weather:GetParticleTexture();
    if ((true == bUseMaterial and "" == strMaterialFile) or
        (false == bUseMaterial and "" == strParticleTexture)) then
        g_Weather:UseMaterial(false);
        g_Weather:SetParticleTexture("data\\public\\stainForDyWeather.dds");
    end

    --0 1ѩ 2
    local speedArr = { 150, 150, 800 };
    local widthArr = { 1, 10, 4 };
    local lengthArr = { 1, 10, 150 };
    local alphaArr = { 0, 0.2, 0.09 };

    local nWeatherType = nType - 1;
    nWeatherType = math.max(nWeatherType, 0);
    nWeatherType = math.min(nWeatherType, 2);

    local bEnableSnowCover = (nWeatherType == 1);
    local bEnableSplash = (nWeatherType == 2);
    local bEnableDropShockWave = (nWeatherType == 2);

    g_Weather:EnableSnowCover(bEnableSnowCover);
    g_Weather:EnableSplash(bEnableSplash);
    g_Weather:EnableDropShockWave(bEnableDropShockWave);
    g_Weather:Enable(nWeatherType ~= 0);
    g_Weather:SetType(nWeatherType);
    g_Weather:SetSpeed(speedArr[nWeatherType+1]);
    g_Weather:SetWidth(widthArr[nWeatherType+1]);
    g_Weather:SetLength(lengthArr[nWeatherType+1]);
    g_Weather:SetAlpha(alphaArr[nWeatherType+1]);

    g_Weather:Apply();
end

function Ui:onWeatherIntensityChanged(nIntensity)
    local nWeatherIntensity = nIntensity;
    nWeatherIntensity = math.max(nWeatherIntensity, 1);
    nWeatherIntensity = math.min(nWeatherIntensity, 3);

    local densityArr = { 0, 3, 6, 10 };
    g_Weather:SetDensity(densityArr[nWeatherIntensity+1]);
    g_Weather:Apply();
end

function Ui:onWeatherWindSpeedChanged(nWindSpeed)
    local nWindSpeed = nWindSpeed;
    nWindSpeed = math.max(nWindSpeed, 0);
    nWindSpeed = math.min(nWindSpeed, 3);

    local windSpeedArr = { 0, 200, 500, 800 };
    g_Weather:SetWind(windSpeedArr[nWindSpeed]);
    g_Weather:Apply();
end

function Ui:onShadowQualityChanged(nShadowQuality)
    local nQuality = nShadowQuality - 1;
    nQuality = math.max(nQuality, 0);
    nQuality = math.min(nQuality, 3);
    g_EngineOption:SetShadowType(nQuality);
    g_EngineOption:Apply();
end

function Ui:onWaterEffectLevelChanged(nWaterEffectLevel)
    local nLevel = 3 - nWaterEffectLevel;
    nLevel = math.max(nLevel, 0);
    nLevel = math.min(nLevel, 2);
    g_EngineOption:SetWaterEffectLevel(nLevel);
    g_EngineOption:Apply();
end

function Ui:onEnableAAChanged(nEnableAA)
    local bEnable = ((nEnableAA - 1) ~= 0);
    g_EngineOption:EnableTXAA(bEnable);
    g_EngineOption:EnableSMAA(bEnable);
    g_EngineOption:Apply();
end

-- Works only on mobile
function Ui:RenderEngineOptions()
    local bCheckedFogBox = false;
    local bCheckedOccludeQuerryBox = false;
    local bCheckedTerrainBox = false;
    local bCheckedTerrainGridBox = false;
    local bCheckedContainerBox = false;
    local bCheckedGBufferBox = false;
    local bCheckedModelStBox = false;
    local bCheckedModelBox = false;
    local bCheckedBoneBox = false;
    local bCheckedOccludedBox = false;
    local bCheckedPlantBox = false;
    local bCheckedWaterBox = false;
    local bCheckedPointLightBox = false;
    local bCheckedPostRenderDofBox = false;
    local bCheckedPostRenderBloomBox= false;
    local bCheckedAOBox = false;
    local bCheckedShockWaveBox = false;
    local bCheckedSSRBox = false;
    local bCheckedCpuProfileBox = false;
    local bCheckedMultiThreadRenderBox = false;
    local bFoliageDensityChanged = false;
    local bCullAngleLimitChanged = false;
    local bLodLevelChanged = false;
    local bExposureChanged = false;
    local bSizeLimitChanged = false;
    local bAngleLimitChanged = false;

    -- boolean
    bCheckedFogBox, self.m_bEnableFog = ImGui.Checkbox(self.m_szFog, self.m_bEnableFog); ImGui.SameLine(500)
    bCheckedOccludeQuerryBox, self.m_bEnableOccludeQuerry = ImGui.Checkbox(self.m_szOccludeQuerry, self.m_bEnableOccludeQuerry);
    bCheckedTerrainBox, self.m_bEnableTerrain = ImGui.Checkbox(self.m_szTerrain, self.m_bEnableTerrain); ImGui.SameLine(500);
    bCheckedTerrainGridBox, self.m_bEnableTerrainGrid = ImGui.Checkbox(self.m_szTerrainGrid, self.m_bEnableTerrainGrid);
    bCheckedContainerBox, self.m_bEnableContainerBox = ImGui.Checkbox(self.m_szContainerBox, self.m_bEnableContainerBox); ImGui.SameLine(500);
    bCheckedGBufferBox, self.m_bEnableGBuffer = ImGui.Checkbox(self.m_szGBuffer, self.m_bEnableGBuffer);
    bCheckedModelStBox, self.m_bEnableModelStBox = ImGui.Checkbox(self.m_szModelStBox, self.m_bEnableModelStBox); ImGui.SameLine(500);
    bCheckedModelBox, self.m_bEnableModelBox = ImGui.Checkbox(self.m_szModelBox, self.m_bEnableModelBox); 
    bCheckedBoneBox, self.m_bEnableBone = ImGui.Checkbox(self.m_szBone, self.m_bEnableBone); ImGui.SameLine(500);
    bCheckedOccludedBox, self.m_bEnableOccludedBox = ImGui.Checkbox(self.m_szOccludedBox, self.m_bEnableOccludedBox);
    bCheckedPlantBox, self.m_bEnablePlant = ImGui.Checkbox(self.m_szPlant, self.m_bEnablePlant); ImGui.SameLine(500);
    bCheckedWaterBox, self.m_bEnableWater = ImGui.Checkbox(self.m_szWater, self.m_bEnableWater); 
    bCheckedPointLightBox, self.m_bEnablePointLight = ImGui.Checkbox(self.m_szPointLight, self.m_bEnablePointLight); ImGui.SameLine(500);
    bCheckedPostRenderDofBox, self.m_bEnablePostRenderDof = ImGui.Checkbox(self.m_szPostRender_dof, self.m_bEnablePostRenderDof);
    bCheckedPostRenderBloomBox, self.m_bEnablePostRenderBloom = ImGui.Checkbox(self.m_szPostRender_bloom, self.m_bEnablePostRenderBloom); ImGui.SameLine(500);
    bCheckedAOBox, self.m_bEnableAO = ImGui.Checkbox(self.m_szAO, self.m_bEnableAO); 
    bCheckedShockWaveBox, self.m_bEnableShockWave = ImGui.Checkbox(self.m_szShockWave, self.m_bEnableShockWave);ImGui.SameLine(500);
    bCheckedSSRBox, self.m_bEnableSSR = ImGui.Checkbox(self.m_szSSR, self.m_bEnableSSR);
    bCheckedCpuProfileBox, self.m_bEnableCpuProfile = ImGui.Checkbox(self.m_szCpuProfile, self.m_bEnableCpuProfile); ImGui.SameLine(500);
    bCheckedMultiThreadRenderBox, self.m_bEnableMultiThreadRender = ImGui.Checkbox(self.m_szMultiThreadRender, self.m_bEnableMultiThreadRender);
    
    if ImGui.BeginCombo(self.m_szShadowQuality, self.m_tbShadowQuality[self.m_nShadowQualityIdx], 0) then
        for idx, char in ipairs(self.m_tbShadowQuality) do
            local bSelected = idx == self.m_nShadowQualityIdx;
            if ImGui.Selectable(char, bSelected) then
                self.m_nShadowQualityIdx = idx;

                local nQuality = self.m_nShadowQualityIdx - 1;
                nQuality = math.max(nQuality, 0);
                nQuality = math.min(nQuality, 3);
                KLGameWorld.SetSomeOptionsVal("shadowmapQuality", nQuality);
            end
        end
        ImGui.EndCombo();
    end

    -- float
    bFoliageDensityChanged, self.m_nFoliageDensity = ImGui.SliderFloat(self.m_szFoliageDensity, self.m_nFoliageDensity, 0.0, 1.0, "%.3f");
    bCullAngleLimitChanged, self.m_nCullAngleLimit = ImGui.SliderFloat(self.m_szCullAngleLimit, self.m_nCullAngleLimit, 0.0, 1.0, "%.3f")
    bLodLevelChanged, self.m_nLodLevel = ImGui.SliderFloat(self.m_szLodLevel, self.m_nLodLevel, 0.0, 99.0, "%.f");
    bExposureChanged, self.m_nExposure = ImGui.SliderFloat(self.m_szExposure, self.m_nExposure, 0.0, 2.0, "%.3f")
    ImGui.Text("ShadowCuller");
    bSizeLimitChanged, self.m_nSizeLimit = ImGui.SliderFloat(self.m_szSizeLimit, self.m_nSizeLimit, 0.0, 100000.0, "%.f");
    bAngleLimitChanged, self.m_nAngleLimit = ImGui.SliderFloat(self.m_szAngleLimit, self.m_nAngleLimit, 0.0, 100000.0, "%.f")

    ImGui.Text("Shader");
    if ImGui.Button(self.m_szReloadShader) then
        KLGameWorld.ReloadShader("reloadShader");
    end
    ImGui.SameLine();
    if ImGui.Button(self.m_szReloadInspackShader) then
        KLGameWorld.ReloadShader("reloadInspackShader");
    end


    self:SetEngineOptions(bCheckedFogBox, bCheckedOccludeQuerryBox, bCheckedTerrainBox, bCheckedTerrainGridBox, bCheckedContainerBox, bCheckedGBufferBox, bCheckedModelStBox,
                          bCheckedModelBox, bCheckedBoneBox, bCheckedOccludedBox, bCheckedPlantBox, bCheckedWaterBox, bCheckedPointLightBox, bCheckedPostRenderDofBox, 
                          bCheckedPostRenderBloomBox, bCheckedAOBox, bCheckedShockWaveBox, bCheckedSSRBox, bCheckedCpuProfileBox, bCheckedMultiThreadRenderBox,
                          bFoliageDensityChanged, bCullAngleLimitChanged, bLodLevelChanged, bExposureChanged, bSizeLimitChanged, bAngleLimitChanged
                          );
     
end

function Ui:GetEngineOptions()
    -- some boolean options
    local nOptionBoolCount = 20;
    local tbOptionsBool = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    KLGameWorld.GetEngineOptions(tbOptionsBool, nOptionBoolCount);
    for idx, flag in ipairs(tbOptionsBool) do
        if flag > 0 then
            tbOptionsBool[idx] = true;
        else
            tbOptionsBool[idx] = false;
        end
    end

    self.m_bEnableFog = tbOptionsBool[1];               self.m_bEnableOccludeQuerry = tbOptionsBool[2];
    self.m_bEnableTerrain = tbOptionsBool[3];           self.m_bEnableTerrainGrid = tbOptionsBool[4];
    self.m_bEnableContainerBox = tbOptionsBool[5];      self.m_bEnableGBuffer = tbOptionsBool[6];
    self.m_bEnableModelStBox  = tbOptionsBool[7];       self.m_bEnableModelBox  = tbOptionsBool[8];
    self.m_bEnableBone = tbOptionsBool[9];              self.m_bEnableOccludedBox = tbOptionsBool[10];
    self.m_bEnablePlant= tbOptionsBool[11];             self.m_bEnableWater  = tbOptionsBool[12];
    self.m_bEnablePointLight = tbOptionsBool[13];       self.m_bEnablePostRenderDof = tbOptionsBool[14];
    self.m_bEnablePostRenderBloom = tbOptionsBool[15];  self.m_bEnableAO = tbOptionsBool[16];
    self.m_bEnableShockWave = tbOptionsBool[17];        self.m_bEnableSSR = tbOptionsBool[18];
    self.m_bEnableCpuProfile = tbOptionsBool[19];       self.m_bEnableMultiThreadRender = tbOptionsBool[20];

    -- some integer/float options
    local nOptionValCount = 7;
    local tbOptionsVal = {0, 0, 0, 0, 0, 0, 0};
    KLGameWorld.GetSomeOptionsVal(tbOptionsVal, nOptionValCount);
    self.m_nShadowQualityIdx = tbOptionsVal[1];
    self.m_nFoliageDensity = tbOptionsVal[2];
    self.m_nCullAngleLimit = tbOptionsVal[3];
    self.m_nLodLevel = tbOptionsVal[4];
    self.m_nExposure = tbOptionsVal[5];
    self.m_nSizeLimit = tbOptionsVal[6];
    self.m_nAngleLimit = tbOptionsVal[7];
end

function Ui:SetEngineOptions(bCheckedFogBox, bCheckedOccludeQuerryBox, bCheckedTerrainBox, bCheckedTerrainGridBox, bCheckedContainerBox, bCheckedGBufferBox, bCheckedModelStBox,
                             bCheckedModelBox, bCheckedBoneBox, bCheckedOccludedBox, bCheckedPlantBox, bCheckedWaterBox, bCheckedPointLightBox, bCheckedPostRenderDofBox, 
                             bCheckedPostRenderBloomBox, bCheckedAOBox, bCheckedShockWaveBox, bCheckedSSRBox, bCheckedCpuProfileBox, bCheckedMultiThreadRenderBox,
                             bFoliageDensityChanged, bCullAngleLimitChanged, bLodLevelChanged, bExposureChanged, bSizeLimitChanged, bAngleLimitChanged
                             )

    if bCheckedFogBox then
        KLGameWorld.SetEngineOptions("bEnableFog", self.m_bEnableFog);
    elseif bCheckedOccludeQuerryBox then
        KLGameWorld.SetEngineOptions("bEnableOccludeQuerry", self.m_bEnableOccludeQuerry);
    elseif bCheckedTerrainBox then
        KLGameWorld.SetEngineOptions("bEnableTerrain", self.m_bEnableTerrain);
    elseif bCheckedTerrainGridBox then
        KLGameWorld.SetEngineOptions("bEnableTerrainGrid", self.m_bEnableTerrainGrid);
    elseif bCheckedContainerBox then
        KLGameWorld.SetEngineOptions("bEnableContainerBox", self.m_bEnableContainerBox);
    elseif bCheckedGBufferBox then
        KLGameWorld.SetEngineOptions("bEnableGBuffer", self.m_bEnableGBuffer);
    elseif bCheckedModelStBox then
        KLGameWorld.SetEngineOptions("bEnableModelStBox", self.m_bEnableModelStBox);
    elseif bCheckedModelBox then
        KLGameWorld.SetEngineOptions("bEnableModelBox", self.m_bEnableModelBox);
    elseif bCheckedBoneBox then 
        KLGameWorld.SetEngineOptions("bEnableBone", self.m_bEnableBone);
    elseif bCheckedOccludedBox then 
        KLGameWorld.SetEngineOptions("bEnableOccludedBox", self.m_bEnableOccludedBox);
    elseif bCheckedPlantBox then 
        KLGameWorld.SetEngineOptions("bEnablePlant", self.m_bEnablePlant);
    elseif bCheckedWaterBox then 
        KLGameWorld.SetEngineOptions("bEnableWater", self.m_bEnableWater);
    elseif bCheckedPointLightBox then
        KLGameWorld.SetEngineOptions("bEnablePointLight", self.m_bEnablePointLight);
    elseif bCheckedPostRenderDofBox then
        KLGameWorld.SetEngineOptions("bEnablePostRenderDof", self.m_bEnablePostRenderDof);
    elseif bCheckedPostRenderBloomBox then
        KLGameWorld.SetEngineOptions("bEnablePostRenderBloom", self.m_bEnablePostRenderBloom);
    elseif bCheckedAOBox then
        KLGameWorld.SetEngineOptions("bEnableAO", self.m_bEnableAO);
    elseif bCheckedShockWaveBox then 
        KLGameWorld.SetEngineOptions("bEnableShockWave", self.m_bEnableShockWave);
    elseif bCheckedSSRBox then 
        KLGameWorld.SetEngineOptions("bEnableSSR", self.m_bEnableSSR);
    elseif bCheckedCpuProfileBox then
        KLGameWorld.SetEngineOptions("bEnableCpuProfile", self.m_bEnableCpuProfile);
    elseif bCheckedMultiThreadRenderBox then
        KLGameWorld.SetEngineOptions("bEnableMultiThreadRender", self.m_bEnableMultiThreadRender);
    elseif bFoliageDensityChanged then
        KLGameWorld.SetSomeOptionsVal("foliageDensity", self.m_nFoliageDensity);
    elseif bCullAngleLimitChanged then
        KLGameWorld.SetSomeOptionsVal("cullAngleLimit", self.m_nCullAngleLimit);
    elseif bLodLevelChanged then
        KLGameWorld.SetSomeOptionsVal("lodLevel", self.m_nLodLevel);
    elseif bExposureChanged then
        KLGameWorld.SetSomeOptionsVal("exposure", self.m_nExposure);
    elseif bSizeLimitChanged then
        KLGameWorld.SetSomeOptionsVal("sizeLimit", self.m_nSizeLimit);
    elseif bAngleLimitChanged then
        KLGameWorld.SetSomeOptionsVal("angleLimit", self.m_nAngleLimit);
    end

end

UiInst = Ui:new();
