---
--- Date         : 2020-07-13 16:24:01
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-07-15 16:41:18
--- Description  : CMD Map table file
--- 这里面最好不要用来实现复杂功能，具体功能请放在具体模块中，这里仅作为命令注册、参数转换的接口
--- 注意每个命令，务必使用 KLGConsole来返回结果到控制台，他会自动格式化好、注入结构化信息、颜色等。
---
CMD_MAP = {
    ---
    --- A demo, which returns the sum of two Numbers.
    ---
    --- @param x number
    --- @param y number
    --- @return string
    ---
    AddDemo = function (x, y)
        local result = tonumber(x) + tonumber(y);
        local message = KLGConsole.Info(string.format(
            "Add result is: %s", result
        ));
        -- !!!
        -- Do something here, call C++ API etc.
        -- message whil be auto inject,like this: [INFO][AddDemo] Add result is: some result".
        -- Available console messages:
        -- KLGConsole.Info(msg); KLGConsole.Warn(msg); KLGConsole.Error(msg);
        return message;
    end,

    ---
    --- @param x number
    --- @param y number
    --- @param z number
    --- @return string
    ---
    MoveTo = function(x, y, z)
        x = tonumber(x) or 0.0;
        y = tonumber(y) or 0.0;
        z = tonumber(z) or 0.0;
        return KLGCommands.MoveTo(x, y, z);
    end,

    ---
    --- @return string
    ---
    ReloadConfig = function()
        return KLGCommands.ReloadConfig();
    end,

    ---
    --- @return string
    ---
    PrintAllCharacterInfo = function()
        return KLGCommands.PrintAllCharacterInfo();
    end,

    ---
    --- @param dwID number
    --- @return string
    ---
    AddMorLiveLink = function(dwID)
        dwID = tonumber(dwID) or 0;
        return KLGCommands.AddMorLiveLink(dwID);
    end,

    ---
    --- @param dwID number
    --- @return string
    ---
    RemoveMorLiveLink = function(dwID)
        dwID = tonumber(dwID) or 0;
        return KLGCommands.AddMorLiveLink(dwID);
    end,

    ---
    --- @param fScale number
    --- @return string
    ---
    SetDynamicWeatherSpeedScale = function(fScale)
        fScale = tonumber(fScale) or 1.0;
        return KLGCommands.SetDynamicWeatherSpeedScale(fScale);
    end,

    ---
    --- @param nMinite number
    --- @return string
    ---
    SetDynamicWeatherStaticTime = function(nMinite)
        nMinite = tonumber(nMinite) or 1;
        return KLGCommands.SetDynamicWeatherStaticTime(nMinite);
    end,

    ---
    --- @param strModelRes string
    --- @param x number
    --- @param y number
    --- @param z number
    --- @return string
    ---
    CreateTestActor = function(strModelRes, x, y, z)
        x = tonumber(x) or 0.0;
        y = tonumber(y) or 0.0;
        z = tonumber(z) or 0.0;
        return KLGCommands.CreateTestActor(strModelRes, x, y, z);
    end,
};