---
--- Date         : 2020-07-16 11:23:51
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-04 10:30:00
--- Description  : 
---

---
--- 修改log颜色
--- @protected
--- @param variable number
--- @param text string
---
local function _ChangeLogText(idx, text)
    local color = nil;
    local has_color = false;
    if string.find(text, "[ERROR]") then
        color = ImVec4(1.0, 0.4, 0.4, 1.0);
        has_color = true;
    end
    if string.find(text, "[INFO]") then
        color = ImVec4(1.0, 0.8, 0.6, 1.0);
        has_color = true;
    end
    if string.find(text, "[WARN]") then
        color = ImVec4(1.0, 0.3, 0.3, 1.0);
        has_color = true;
    end
    if has_color then
        ImGui.PushStyleColor(idx, color);
    end
    ImGui.TextUnformatted(text);
    if has_color then
        ImGui.PushStyleColor(idx, color);
    end
end

---
--- 绘制控制台控件
---
--- @return boolean
---
DrawConsole = function(self)
    ImGui.TextWrapped("This is a mini console, Enter '/h' for help");
    ImGui.Separator();

    if ImGui.Button("Clear Log", ImVec2(80, 20)) then
        self:Clear();
    end
    ImGui.SameLine();
    ImGui.SetNextItemWidth(180);

    -- Filter box
    local search_input_flags = ImGuiInputTextFlags_.ImGuiInputTextFlags_EnterReturnsTrue;
    local filterChar = self.m_szFilterText;
    if KLImGui.InputText("Input KeyWord to filter", filterChar, 128, search_input_flags) then
        local filterStr = filterChar:ToString();
        if not filterChar:IsEmpty() and filterStr ~= "" and not string.find(string.sub(filterStr, 1, 2), "\0") then
            self:Filter(filterChar:ToString());
            filterChar:Clear();
        end
        -- search_input_flags = ImGuiInputTextFlags_.ImGuiInputTextFlags_None;
        ImGui.SetKeyboardFocusHere(-1);
    end

    -- Scroll log range.
    ImGui.Separator();
    local height_reserve = ImGui.GetStyle().ItemSpacing.y + ImGui.GetFrameHeightWithSpacing();
    ImGui.BeginChild("#ScrollingRegion", ImVec2(0, -height_reserve), false,
                    ImGuiWindowFlags_.ImGuiWindowFlags_HorizontalScrollbar);
    if ImGui.BeginPopupContextWindow() then
        if (ImGui.Selectable("Clear")) then
            self:Clear();
        end
        ImGui.EndPopup();
    end
    ImGui.PushStyleVar(ImGuiStyleVar_.ImGuiStyleVar_ItemSpacing, ImVec2(4, 1));
    local tabShowLog = {};
    if #self.m_tabFilterText > 0 then
        tabShowLog = self.m_tabFilterText;
    else
        tabShowLog = self.m_tabLogText;
    end
    for key, item in ipairs(tabShowLog) do
        -- TODO: Colored Log.
        ImGui.TextUnformatted(item);
    end

    if ImGui.GetScrollY() >= ImGui.GetScrollMaxY() then
        ImGui.SetScrollHereY(1.0);
    end
    ImGui.PopStyleVar();
    ImGui.EndChild();
    ImGui.Separator();
    ImGui.SetNextItemWidth(455);

    -- Bottom operate range.
    local cmdChar = self.m_szCmdText;
    local input_text_flags = ImGuiInputTextFlags_.ImGuiInputTextFlags_EnterReturnsTrue;
    if KLImGui.InputText("#CMD_INPUT", cmdChar, 128, input_text_flags) then
        local cmdstr = cmdChar:ToString();
        if not cmdChar:IsEmpty() and cmdstr ~= "" and not string.find(string.sub(cmdstr, 1, 2), "\0") then
            self:Exec(cmdChar:ToString());
            table.insert(self.m_tabCmdHistories, cmdChar:ToString());
            cmdChar:Clear();
        end
        -- input_text_flags = ImGuiInputTextFlags_.ImGuiInputTextFlags_None;
        ImGui.SetKeyboardFocusHere(-1);
    end
    ImGui.SetItemDefaultFocus();
    return true;
end