---
--- Date         : 2020-07-15 16:41:49
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-07-16 11:44:09
--- Description  : CMD List
---

---
--- Draw CMD list panel ui.
---
--- @private
--- @param self Ui
--- @param cmd_names table<number, string>
--- @param cmd_params table<number, string>
--- @return number selected item index
---
DrawCmdList = function(self, cmd_helps)
    ImGui.Text("Registered commands:");
    ImGui.Columns(2, "cmd_list");
    ImGui.Separator();
    ImGui.Text("Command");
    ImGui.NextColumn();
    ImGui.Text("Params");
    ImGui.NextColumn();
    ImGui.Separator();
    local i = 1;
    while i <= #cmd_helps do
        if cmd_helps[i] then
            ImGui.Text(cmd_helps[i].name);
            ImGui.NextColumn();
            ImGui.Text(cmd_helps[i].param);
            ImGui.NextColumn();
        end
        i = i + 1;
    end
    ImGui.Columns(1);
    return true;
end
