---
--- Date         : 2020-06-22 17:00:15
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-04 17:58:36
--- Description  : InGame command panel ui.
---

_G.UI_INGAME_CONSOLE = "InGameConsoleUi";
local Ui = Ui or class(_G.UI_INGAME_CONSOLE, LUiBase);
local Parser = ReLoadScript("ugc_common/script/cases/ingame_console/cmd_parser.lua").Parser;
local DrawCmdList = ReLoadScript("ugc_common/script/cases/ingame_console/list_com.lua").DrawCmdList;
local DrawConsole = ReLoadScript("ugc_common/script/cases/ingame_console/console_com.lua").DrawConsole;

function Ui:ctor()
    self.m_bOpen           = false;
    self.m_szName          = _G.UI_INGAME_CONSOLE;
    self.m_szTitle         = util.a2u8("̨");
    self.m_tabLogText      = {};
    self.m_tabFilterText   = {};
    self.m_nMaxLogSize     = 4096;
    self.m_tabCmdHelps     = Parser.GetCMDStr();
    self.m_szCmdText       = KLString:new_local("");
    self.m_szFilterText    = KLString:new_local("");
    self.m_tabCmdHistories = {};
end

function Ui:dtor()
    self.m_tabCmdHistories = {};
    self.m_tabLogText      = {};
    self.m_tabFilterText   = {};
    self.m_szTitle         = nil;
    self.m_bOpen           = false;
end

function Ui:GetName()
    return self.m_szName;
end

function Ui:SetOpenClose(bOpen)
    self.m_bOpen = not not bOpen;
end

function Ui:IsOpen()
    return self.m_bOpen;
end

function Ui:Clear()
    self.m_tabLogText = {};
end

function Ui:Exec(cmd_str)
    local fnCmd, tabParams, strCmd, strParams = Parser.Parse(cmd_str);
    local strResult = "Nothing return.";
    if fnCmd then
        strResult = fnCmd(unpack(tabParams));
        strResult = string.replace(strResult, "$CMD", strCmd);
    end
    local strLog = string.format(
        [[
<: %s
F: %s
P: %s
>: %s
        ]],
        string.sub(cmd_str, 0, string.find(cmd_str, "\0")),
        strCmd, strParams, strResult
    );
    -- remove first element if too long.
    if #self.m_tabLogText >= self.m_nMaxLogSize then
        table.remove(self.m_tabLogText, 1);
    end
    table.insert(self.m_tabLogText, strLog);
end

function Ui:Filter(filter_str)
    self.m_tabFilterText = {};
    filter_str = string.sub(filter_str, 0, string.find(filter_str, "\0") - 1);
    for key, value in ipairs(self.m_tabLogText) do
        if string.find(value, filter_str) then
            table.insert(self.m_tabFilterText, value);
        end
    end
end

function Ui:GameDraw()
    local wnd_flags = bit.orOp(
        ImGuiWindowFlags_.ImGuiWindowFlags_NoResize,
        ImGuiWindowFlags_.ImGuiWindowFlags_NoCollapse
    );
    local width  = 900;
    local height = 610;

    ImGui.SetNextWindowSize(ImVec2(width, height), ImGuiCond_.ImGuiCond_Always);
    _, self.m_bOpen = ImGui.Begin("Debug Console", self.m_bOpen, wnd_flags);
        -- Left
        ImGui.BeginChild("LeftCmdList", ImVec2(width / 3, height - 35), true);
            DrawCmdList(self, self.m_tabCmdHelps);
        ImGui.EndChild();

        ImGui.SameLine();

        -- Right
        ImGui.BeginChild("RightConsole", ImVec2(width / 3 * 2, height - 35), true);
            DrawConsole(self);
        ImGui.EndChild();
    ImGui.End();
end

UiInst = Ui.new()
