--- 
--- Date         : 2020-07-03 10:37:37
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-07-31 21:40:03
--- Description  : 琵琶模拟器
--- 

_G.UI_LUTE_SIMULATOR = "LuteSimulator";
local Ui = Ui or class(_G.UI_LUTE_SIMULATOR, LUiBase);
local LUTE_SIMULATOR_CFG = ImportScript("ugc_common/script/cases/lute_simulator/configs.lua").LUTE_SIMULATOR_CFG;

local function _GetCFGItemByKeyName(key_name)
    local result = nil;
    for row_key, row_value in pairs(LUTE_SIMULATOR_CFG.KEY_MAP) do
        for col_key, col_value in pairs(row_value) do
            if col_value.Keyboard == string.upper(key_name) then
                result = col_value;
                break;
            end
        end
        if result then break end;
     end
     return result;
end

function Ui:ctor()
    self.m_bOpen          = false;
    self.m_szName         = _G.UI_LUTE_SIMULATOR;
    self.m_szTitle        = util.a2u8("LuteSimulator");
    self.m_szInputKeyCode = nil;
    self.m_keyMap         = LUTE_SIMULATOR_CFG.KEY_MAP;
    self.m_szBnkFileName  = util.a2u8(LUTE_SIMULATOR_CFG.BNK_FILE_NAME);
    self.m_io             = ImGui.GetIO();
    self.m_lastInputKey   = nil;
end

function Ui:dtor()
    self.m_bOpen   = false;
    self.m_szTitle = nil;
end

function Ui:GetName()
    return self.m_szName;
end

function Ui:SetOpenClose(bOpen)
    self.m_bOpen = not not bOpen;
end

function Ui:IsOpen()
    return self.m_bOpen;
end

function Ui:OnOpen()
    --
end

function Ui:OnClose()
    --
end

function Ui:GameTick()
    --
end

function Ui:Clear()
    self.m_tabLogText = {};
end

function Ui:Play(col_value)
    local uChannel     = col_value.uChannel;
    local uMidiNote    = col_value.uMidiNote;
    local uVelocity    = col_value.uVelocity;
    local uFrameOffset = col_value.uFrameOffset;
    local bnkFileName  = self.m_szBnkFileName;

    if self.m_lastInputKey ~= uMidiNote then
        KLGameWorld.PlayMIDI(bnkFileName, uChannel, uMidiNote, uVelocity, uFrameOffset);
    else
        KLGameWorld.StopMIDI(bnkFileName, uChannel, uMidiNote, uVelocity, uFrameOffset);
    end
    self.m_lastInputKey = uMidiNote;
end

function Ui:GameDraw()
    local wnd_flags = bit.orOp(
        ImGuiWindowFlags_.ImGuiWindowFlags_NoResize,
        ImGuiWindowFlags_.ImGuiWindowFlags_NoCollapse
    );
    ImGui.SetNextWindowSize(ImVec2(715, 285), ImGuiCond_.ImGuiCond_Always);
    _, self.m_bOpen = ImGui.Begin(self.m_szTitle, self.m_bOpen, wnd_flags);

    for row_key, row_value in pairs(self.m_keyMap) do
       for col_key, col_value in pairs(row_value) do
            local displayText = col_value.DisplayText;
            local keyboard = col_value.Keyboard;
            local tooltipText = col_value.TooltipText;
            if col_key ~= 1 then
                ImGui.SameLine();
            end
            ImGui.PushID(row_key * col_key);
            ImGui.PushStyleColor(ImGuiCol_.ImGuiCol_Button, ImVec4(1.0, 1.0, 1.0, 0.2));
            ImGui.PushStyleColor(ImGuiCol_.ImGuiCol_ButtonHovered, ImVec4(1.0, 1.0, 1.0, 0.3));
            ImGui.PushStyleColor(ImGuiCol_.ImGuiCol_ButtonActive, ImVec4(1.0, 1.0, 1.0, 0.4));
            if ImGui.Button(string.format("%s (%s)", displayText, keyboard), ImVec2(80, 80)) then
                -- 鼠标点击按钮播放
                self:Play(col_value);
            end
            if ImGui.IsItemHovered() then
                ImGui.SetTooltip(tooltipText);
            end
            ImGui.PopStyleColor(3);
            ImGui.PopID();
       end
    end

    -- 处理键盘按下播放
    local i    = 0;
    local item = nil;
    local iqc  = self.m_io.InputQueueCharacters;
    while i < iqc:size() do
        item = _GetCFGItemByKeyName(string.char(iqc[i]));
        if item then self:Play(item) end;
        i = i + 1;
    end

    ImGui.End();
end

UiInst = Ui.new()
