---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/6/4 9:19
---
local MakeFaceCfg = ImportScript("ugc_common/script/cases/make_face/config.lua").MakeFaceCfg;
local Lib = ImportScript("ugc_common/script/base/lib.lua")

UI_MAKE_FACE = "MakeFaceUi";
local Ui = Ui or class(UI_MAKE_FACE, LUiBase);
_G.UI_MAKE_FACE = UI_MAKE_FACE;

--[[
Ui = {
    m_bOpen = false;
    ...
}
--]]

function Ui:ctor()
    self.m_bOpen = false;
    self.m_szName = UI_MAKE_FACE

    self.m_szWndName = util.a2u8("");
    self.m_szFaceBoneTab  = util.a2u8("");
    self.m_szFaceDecalTab = util.a2u8("ױ");
    self.m_szFaceFileTab = util.a2u8("ʷļ");
    self.m_szFaceRandom = util.a2u8("")
    self.m_szFaceSave = util.a2u8("")

    -- FaceBoneClass
    self.FaceBoneClassName = MakeFaceCfg:GetAllFaceBoneClassName()
    self.FaceBoneNameList = MakeFaceCfg:GetAllFaceBoneName()
    self.FaceBoneDetailRange = MakeFaceCfg:GetFaceBoneDetailRanges()
    -- Interval is [1,51]
    self.m_tbCurFaceBoneValues = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    self.m_tbEyeBoneType   = MakeFaceCfg:GetEyeBoneType()
    self.m_tbEyeBoneName   = MakeFaceCfg:GetEyeBoneName()
    self.m_tbMouthBoneType = MakeFaceCfg:GetMouthBoneType()
    self.m_tbMouthBoneName = MakeFaceCfg:GetMouthBoneName()
    self.m_tbNoseBoneType  = MakeFaceCfg:GetNoseBoneType()
    self.m_tbNoseBoneName  = MakeFaceCfg:GetNoseBoneName()
    self.m_tbFaceBoneType  = MakeFaceCfg:GetFaceBoneType()
    self.m_tbFaceBoneName  = MakeFaceCfg:GetFaceBoneName()

    --FaceDecal
    self.m_tbFaceDecalClassName = MakeFaceCfg:GetAllFaceDecalClassName()
    self.m_tbFaceDecalNameList = MakeFaceCfg:GetFaceDecalList()
    self.m_tbFaceDecalColorID = MakeFaceCfg:GetFaceDecalColorID()
    self.m_tbFaceDecalDefaultRGBA = MakeFaceCfg:GetDefaultRGBA()
    self.m_tbChooseDecal = {}

    --CustomFaceDecal
    self.m_tbCustomDecalNames = {"ɫ","",""}
    self.m_tbCustomDecalRangs = MakeFaceCfg:GetFaceCustomDecalNames()
    -- CustomDecal Test
    -- m_tbCurCustomDecalValues[n][1] : SKINCOLOR
    -- m_tbCurCustomDecalValues[n][1] : SKINGLOSS
    -- m_tbCurCustomDecalValues[n][1] : SKINGRAININESS
    -- m_tbCurCustomDecalValues[n][1] : bUSE
    self.m_tbCurCustomDecalValues = {{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}}

    -- FaceFile
    self.m_tbFaceHistoryFile = {}

    self.m_nCurRoleType = -1
    self.m_nType = 0
    self.m_nShowID = 1
    self.m_nColorID = 0
    self.m_nCurFile = 1
    self.m_szFaceFileName = nil

    self:Init()
end

function Ui:dtor()
end

function Ui:Init()
    self.m_szFaceFileName = KLString:new_local()
    for i = 0, #self.m_tbFaceDecalClassName do
        self.m_tbChooseDecal[i] = {}
    end
end

function Ui:UnInit()
    
end

function Ui:OnOpen()
    if not PLATFORM_PC then 
        local fX,fY,fZ
        local tPlayer = g_ActorManager:GetLocalPlayer()
        _,fX,fY,fZ =tPlayer:GetModelFaceCenter()
        g_CameraController:SetPosition(fX,fY + 15,fZ-80)
        g_CameraController:SetLookDir(fX - 15, fY + 15, 0);

        -- ʱдnRealShowIDnRealColorIDд
        -- Init FaceBonetable
        tPlayer:GetFaceBoneDefinition(self.m_tbCurFaceBoneValues)
        --  Initt FaceDecal and Face FaceColor
        local tbFaceDecal = {0,0,0,0,0,0,0,0,0,0}
        local tbFaceColor = {0,0,0,0,0,0,0,0,0,0}
        tPlayer:GetFaceDecalsDefinition(tbFaceDecal)
        tPlayer:GetFaceColorsDefinition(tbFaceColor)
        for i=0, #tbFaceDecal-1 do
            self.m_tbChooseDecal[i].nRealShowID = tbFaceDecal[i+1]
        end
        for i=0, #tbFaceColor-1 do
            self.m_tbChooseDecal[i].nRealColorID = tbFaceColor[i+1]
        end
        -- Init FaceCustom
        local tbFaceCustomDecal = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
        local nCustomIndex = 1
        tPlayer:GetFaceCustomDecalsDefinition(tbFaceCustomDecal)
        for i=1,#tbFaceCustomDecal,4 do
            self.m_tbCurCustomDecalValues[nCustomIndex][1] = tbFaceCustomDecal[i]
            self.m_tbCurCustomDecalValues[nCustomIndex][2] = tbFaceCustomDecal[i+1]
            self.m_tbCurCustomDecalValues[nCustomIndex][3] = tbFaceCustomDecal[i+2]
            self.m_tbCurCustomDecalValues[nCustomIndex][4] = tbFaceCustomDecal[i+3]
            nCustomIndex = nCustomIndex+1
        end
        -- Init FaceFile
        self.m_tbFaceHistoryFile = MakeFaceCfg:GetHistoryFile()
    end
end

function Ui:OnClose()
    if not PLATFORM_PC then 
        g_CameraController:ResetCamera();
    end
end

function Ui:GameTick()
end

function Ui:GameDraw()
    local buttonSize
    if PLATFORM_PC then
        buttonSize = ImVec2(80,40)
    else
        buttonSize = ImVec2(130,60)
    end
    self:SetCurRoleType()

    ImGui.SetNextWindowSize(ImVec2(500,500),ImGuiCond_.ImGuiCond_FirstUseEver)
    _, self.m_bOpen = ImGui.Begin(self.m_szWndName, self.m_bOpen);

    if ImGui.BeginTabBar("MakeFace",ImGuiTabBarFlags_.ImGuiTabBarFlags_NoTooltip) then
        self:FaceBoneTabItem()
        self:FaceDecalTabItem()
        self:FaceFileTabItem()
        ImGui.EndTabBar()
    end
    ImGui.Separator()
    if ImGui.Button(self.m_szFaceRandom,buttonSize) then
        self:SetRandomFace()
    end
    ImGui.SameLine()
    if ImGui.Button(self.m_szFaceSave,buttonSize) then
        if PLATFORM_PC then
            ImGui.OpenPopup(util.a2u8("ļ\n\n"))
        else
            KLPlatformNative:ShowInput()
        end
    end
    self:ShowPopups()

    ImGui.End();
end

function Ui:SetCurRoleType()
    if self.m_nCurRoleType == -1 then
        local tPlayer = g_ActorManager:GetLocalPlayer()
        if tPlayer ~= nil then
            self.m_nCurRoleType = tPlayer:GetRoleType()
        end
    end
end

function Ui:FaceBoneTabItem()
    if KLImGui.BeginTabItem(self.m_szFaceBoneTab) then
        if ImGui.TreeNode(self.FaceBoneClassName[4]) then
            self:EyesSlidersDraw()
            ImGui.TreePop()
        end
        if ImGui.TreeNode(self.FaceBoneClassName[3]) then
            self:MouthSlidersDraw()
            ImGui.TreePop()
        end
        if ImGui.TreeNode(self.FaceBoneClassName[2]) then
            self:NoseSlidersDraw()
            ImGui.TreePop()
        end
        if ImGui.TreeNode(self.FaceBoneClassName[1]) then
            self:FaceSlidersDraw()
            ImGui.TreePop()
        end
        KLImGui.EndTabItem()
    end
end

function Ui:FaceDecalTabItem()
    if KLImGui.BeginTabItem(self.m_szFaceDecalTab) then
        self:ShowType()
        self:ShowShowID()
        self:ShowColorID()

        if self.m_nType == 0 then
            self:ShowCustomDecal()
        end
              
        KLImGui.EndTabItem()
    end
end

function Ui:FaceFileTabItem()
    if KLImGui.BeginTabItem(self.m_szFaceFileTab) then
        for i=1,#self.m_tbFaceHistoryFile[self.m_nCurRoleType] do
            if ImGui.Selectable(self.m_tbFaceHistoryFile[self.m_nCurRoleType][i],self.m_nCurFile == i) then
                self.m_nCurFile = i
                self:SetHistoryFile(self.m_tbFaceHistoryFile[self.m_nCurRoleType][i])
            end
        end
        
        KLImGui.EndTabItem()
    end
end

function Ui:EyesSlidersDraw()
    local tbEyesChangedState = {}

    for i=1,#self.m_tbEyeBoneName do
        tbEyesChangedState[i], self.m_tbCurFaceBoneValues[self.m_tbEyeBoneType[i] +1] = 
                ImGui.SliderInt(self.FaceBoneNameList[4][i].BoneName,
                                self.m_tbCurFaceBoneValues[self.m_tbEyeBoneType[i] +1],
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbEyeBoneType[i]].ValueMin,
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbEyeBoneType[i]].ValueMax);
    end

    for i=1,#tbEyesChangedState do
        if tbEyesChangedState[i] == true then
            LOG_I("Cur changed Index is : "..self.m_tbEyeBoneType[i])
            self:UpdateFaceBone()
            break
        end
    end
end

function Ui:MouthSlidersDraw()
    local tbMouthChangedState = {}

    for i=1,#self.m_tbMouthBoneName do
        tbMouthChangedState[i], self.m_tbCurFaceBoneValues[self.m_tbMouthBoneType[i] +1] = 
                ImGui.SliderInt(self.FaceBoneNameList[3][i].BoneName,
                                self.m_tbCurFaceBoneValues[self.m_tbMouthBoneType[i] +1],
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbMouthBoneType[i]].ValueMin,
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbMouthBoneType[i]].ValueMax);
    end

    for i=1,#self.m_tbMouthBoneName do
        if tbMouthChangedState[i] == true then
            LOG_I("Cur changed Index is : "..self.m_tbMouthBoneType[i])
            self:UpdateFaceBone()
            break
        end
    end
end

function Ui:NoseSlidersDraw()
    local tbNoseChangedState = {}

    for i=1,#self.m_tbNoseBoneName do
        tbNoseChangedState[i], self.m_tbCurFaceBoneValues[self.m_tbNoseBoneType[i] +1] = 
                ImGui.SliderInt(self.FaceBoneNameList[2][i].BoneName,
                                self.m_tbCurFaceBoneValues[self.m_tbNoseBoneType[i] +1],
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbNoseBoneType[i]].ValueMin,
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbNoseBoneType[i]].ValueMax);
    end

    for i=1,#self.m_tbNoseBoneName do
        if tbNoseChangedState[i] == true then
            LOG_I("Cur changed Index is : "..self.m_tbNoseBoneType[i])
            self:UpdateFaceBone()
            break
        end
    end
end

function Ui:FaceSlidersDraw()
    local tbFaceChangedState = {}

    for i=1,#self.m_tbFaceBoneName do
        tbFaceChangedState[i], self.m_tbCurFaceBoneValues[self.m_tbFaceBoneType[i] +1] = 
                ImGui.SliderInt(self.FaceBoneNameList[1][i].BoneName,
                                self.m_tbCurFaceBoneValues[self.m_tbFaceBoneType[i] +1],
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbFaceBoneType[i]].ValueMin,
                                self.FaceBoneDetailRange[self.m_nCurRoleType][self.m_tbFaceBoneType[i]].ValueMax);
    end

    for i=1,#self.m_tbFaceBoneName do
        if tbFaceChangedState[i] == true then
            LOG_I("Cur changed Index is : "..self.m_tbFaceBoneType[i])
            self:UpdateFaceBone()
            break
        end
    end
end

function Ui:ShowType()
    ImGui.BeginChild("#FaceDecal",ImVec2(320,ImGui.GetWindowHeight()*0.7),true)
    for i=0,#self.m_tbFaceDecalClassName do
        if ImGui.Selectable(util.a2u8(self.m_tbFaceDecalClassName[i]),self.m_nType == i) then
            self.m_nType = i
            self.m_nShowID = self.m_tbChooseDecal[self.m_nType].nRealShowID
        end
    end
    ImGui.EndChild()
end

function Ui:ShowShowID()
    ImGui.SameLine()
    ImGui.BeginChild("#FaceDecalDetail",ImVec2(180,ImGui.GetWindowHeight()*0.7),true,ImGuiWindowFlags_.ImGuiWindowFlags_AlwaysVerticalScrollbar)
    local localPlayer = g_ActorManager:GetLocalPlayer();
    if localPlayer then
        for k,v in pairs(self.m_tbFaceDecalNameList[self.m_nCurRoleType][self.m_nType]) do
            if ImGui.Selectable(v.Name,self.m_nShowID == k) then
                self.m_nShowID = k
                -- Upddate FaceDecal table
                self:UpdateFaceDecal()
            end
        end
    end
    ImGui.EndChild()
end

function Ui:ShowColorID()
    if self.m_tbFaceDecalColorID[self.m_nCurRoleType][self.m_nType][self.m_nShowID].ColorCount > 1 then
        ImGui.SameLine()
        ImGui.BeginChild("#FaceDecalColor",ImVec2(200,ImGui.GetWindowHeight()*0.5),true,ImGuiWindowFlags_.ImGuiWindowFlags_AlwaysVerticalScrollbar)
        local localPlayer = g_ActorManager:GetLocalPlayer();
            if localPlayer then
                for j=0,self.m_tbFaceDecalColorID[self.m_nCurRoleType][self.m_nType][self.m_nShowID].ColorCount-1 do
                    local r,g,b,a
                    if not PLATFORM_PC then
                        if j == 0 then
                            local tColor = Lib.SplitStr(self.m_tbFaceDecalDefaultRGBA[self.m_nCurRoleType][self.m_nType][self.m_nShowID].DefaultRGBA,";")
                            if tColor and #tColor == 4 then
                                r = tonumber(tColor[1]) / 255
                                g = tonumber(tColor[2]) / 255
                                b = tonumber(tColor[3]) / 255
                                a = tonumber(tColor[4]) / 255
                            end
                        else
                            _,r,g,b,a = localPlayer:GetFaceDecalColor(self.m_nCurRoleType,self.m_nType,self.m_nShowID,self.m_tbFaceDecalColorID[self.m_nCurRoleType][self.m_nType][self.m_nShowID]["ColorID"..j])
                        end
                    else
                        r = 0.5;g = 0.5;b = 0.5;a = 1
                    end
                    if ImGui.ColorButton("ColorID"..j, ImVec4(r,g,b,a), ImGuiColorEditFlags_.ImGuiColorEditFlags_NoTooltip or ImGuiColorEditFlags_.ImGuiColorEditFlags__DisplayMask, ImVec2(80, 80)) then
                        self.m_nColorID = self.m_tbFaceDecalColorID[self.m_nCurRoleType][self.m_nType][self.m_nShowID]["ColorID"..j]
                        self:UpdateFaceDecalColor()
                    end
                    if j%2 == 0 or j ==0  then
                        ImGui.SameLine()
                    end
                end
            end
        ImGui.EndChild()
    end
end

function Ui:ShowCustomDecal()
    local tbCustomDecalState = {}
    ImGui.SameLine()
    ImGui.BeginChild("#FaceCustomDecal",ImVec2(510,ImGui.GetWindowHeight()*0.30),true,ImGuiWindowFlags_.ImGuiWindowFlags_NoScrollbar)
    for i=1,#self.m_tbCustomDecalNames do
        tbCustomDecalState[i], self.m_tbCurCustomDecalValues[self.m_nType+1][i] = 
                ImGui.SliderInt(util.a2u8(self.m_tbCustomDecalNames[i]),
                                self.m_tbCurCustomDecalValues[self.m_nType+1][i],
                                self.m_tbCustomDecalRangs[self.m_nCurRoleType][i-1].MIN,
                                self.m_tbCustomDecalRangs[self.m_nCurRoleType][i-1].MAX);
    end

    for i=1,#self.m_tbCustomDecalNames do
        if tbCustomDecalState[i] == true then
            self:UpdateCustomDecal()
            break
        end
    end
    ImGui.EndChild()
end

function Ui:ShowPopups()
    if ImGui.BeginPopup(util.a2u8("ļ\n\n"),ImGuiWindowFlags_.ImGuiWindowFlags_AlwaysAutoResize) then
        KLImGui.InputTextWithHint("##FaceFileName",util.a2u8("ļ"),self.m_szFaceFileName,self.m_szFaceFileName:Capacity())
        if ImGui.Button(util.a2u8("")) then
            self:SaveCurFaceToINI()
            ImGui.CloseCurrentPopup()
        end
        ImGui.SameLine()
        if ImGui.Button(util.a2u8("ر")) then
            ImGui.CloseCurrentPopup()
        end
        ImGui.EndPopup();
    end

    if PLATFORM_PC == false and self:SetFaceFileName() ~= nil then
        self:SaveCurFaceToINI()
    end
end

function Ui:UpdateFaceBone()
    local total = #self.m_tbCurFaceBoneValues
    local tbCurFaceBoneValues = {}
    for i=1, total do
        tbCurFaceBoneValues[i] = self.m_tbCurFaceBoneValues[i]
    end

    if not PLATFORM_PC then
        local tPlayer = g_ActorManager:GetLocalPlayer()
        tPlayer:SetFaceBoneParams(tbCurFaceBoneValues)
    end

end

function Ui:UpdateFaceDecal()
    self.m_tbChooseDecal[self.m_nType].nRealShowID = self.m_nShowID
    -- Pass the self.m_tbChooseDecal table to Engine Here
    if not PLATFORM_PC then
        local tbFaceDecalValues = {}
        local tPlayer = g_ActorManager:GetLocalPlayer()
        for i=0,#self.m_tbChooseDecal do
            tbFaceDecalValues[i+1] = self.m_tbChooseDecal[i].nRealShowID
        end
        tPlayer:SetFaceDecal(self.m_nCurRoleType,tbFaceDecalValues)
    end

end

function Ui:UpdateFaceDecalColor()
    self.m_tbChooseDecal[self.m_nType].nRealColorID = self.m_nColorID
    -- Pass the self.m_tbChooseDecal table to Engine Here
    if not PLATFORM_PC then
        local tbFaceColorValues = {}
        local tPlayer = g_ActorManager:GetLocalPlayer()
        for i=0,#self.m_tbChooseDecal do
            tbFaceColorValues[i+1] = self.m_tbChooseDecal[i].nRealColorID
        end
        tPlayer:SetFaceColor(self.m_nCurRoleType,tbFaceColorValues)
    end
end

function Ui:UpdateCustomDecal()
    local tbCustomDecalValues = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    self.m_tbCurCustomDecalValues[self.m_nType+1][4] = 1
    for i=1,#self.m_tbCurCustomDecalValues do
        for j=1,#self.m_tbCurCustomDecalValues[i] do
            if j <=3 then
                local num = self.m_tbCurCustomDecalValues[i][j]
                num = MakeFaceCfg:ValueScaleConversion(num,j)
                tbCustomDecalValues[(i-1) * 4 + j] = num
            else
                tbCustomDecalValues[(i-1) * 4 + j] = self.m_tbCurCustomDecalValues[i][j]
            end
        end
    end
    -- Pass self.m_tbCurCustomDecalValues to Engine
    if not PLATFORM_PC then
        local tPlayer = g_ActorManager:GetLocalPlayer();
        tPlayer:SetFaceCustomDecal(self.m_nCurRoleType,tbCustomDecalValues)
    end
end

function Ui:SetHistoryFile(fileName)
    local szRoleType = ""
    local szRelPath = "ugc_common\\settings\\FaceHistory\\"
    local szAbsPath = ""
    if self.m_nCurRoleType == 1 then
        szRoleType =  "m2"
    elseif self.m_nCurRoleType == 2 then
        szRoleType =  "f2"
    elseif self.m_nCurRoleType == 5 then
        szRoleType =  "m1"
    elseif self.m_nCurRoleType == 6 then
        szRoleType =  "f1"
    end
    if PLATFORM_PC then
        szAbsPath = FS.Path.Join(FS.GetCwd(), szRelPath,szRoleType,fileName..".ini")
    else
        szAbsPath = MakeFaceCfg:PathJoin_Android(KLPlatformNative:KLGetPlatformIOPath(),"Resource\\ugc_common\\settings\\FaceHistory\\",szRoleType)
        szAbsPath = szAbsPath..fileName..".ini"
    end
    -- Pass the file here
    local tPlayer = g_ActorManager:GetLocalPlayer()
    tPlayer:SetFaceINIFile(szAbsPath)
end

function Ui:SetRandomFace()
    local tab = MakeFaceCfg:GetFaceDefault()
    local tbFaceDefault = tab[self.m_nCurRoleType]
    local nIndex = MakeFaceCfg:Rand(#tbFaceDefault)
    local tPlayer = g_ActorManager:GetLocalPlayer()
    tPlayer:SetRandomFace(tbFaceDefault[nIndex])
end

function Ui:SetFaceFileName()
    self.m_szFaceFileName = KLPlatformNative:GetInputFaceFileName()
    return self.m_szFaceFileName
end

function Ui:SaveCurFaceToINI()
    MakeFaceCfg:SaveCurFace(self.m_nCurRoleType,self.m_szFaceFileName .. ".ini", self.m_tbCurFaceBoneValues,self.m_tbChooseDecal,self.m_tbCurCustomDecalValues)
    self.m_tbFaceHistoryFile = MakeFaceCfg:GetHistoryFile()
end

UiInst = Ui:new();
