
UI_MODEL_LIST_VIEW = "ModelListView";
local Ui = Ui or class(UI_MODEL_LIST_VIEW, LUiBase);
_G.UI_MODEL_LIST_VIEW = UI_MODEL_LIST_VIEW;

function Ui:ctor()
    self.m_bOpen = false;
    self.m_szName = UI_MODEL_LIST_VIEW;
    self.m_currActor = nil;
    self.m_tabResource = {};
    self.m_nLoadSpeed = 100;
    self.m_coLoadResourceTableFile = coroutine.create(self.LoadResourceTableFile);
    -- self:LoadResourceTableFile("ugc_common/settings/Mesh.rt");
end

function Ui:dtor()
    --
end

function Ui:GameTick()
    --
end

function Ui:GameDraw()
    ImGui.SetNextWindowSize(ImVec2(700, 200), ImGuiCond_.ImGuiCond_FirstUseEver);
    _, self.m_bOpen = ImGui.Begin(self.m_szName, self.m_bOpen);
    self:draw();
    ImGui.End();
end

function Ui:draw()
    local status = coroutine.status(self.m_coLoadResourceTableFile);
    if status == "suspended" then
        coroutine.resume(self.m_coLoadResourceTableFile, self, "ugc_common/settings/Mesh.rt");
    end
    self:ShowTreeNode(self.m_tabResource);
end

function Ui:ShowTreeNode(tab)
    for k, v in pairs(tab) do
        if type(v) == 'table' then
            v.bExpanded = ImGui.TreeNode(k);
            if v.bExpanded == true then
                self:ShowTreeNode(v);
                ImGui.TreePop();
            end
        elseif type(v) == 'string' then
            --ImGui.SmallButton(k .. " : " .. v);
            ImGui.SmallButton(k);
            if self.m_currActor and ImGui.IsMouseDown(0) == false then
                self.m_currActor = nil;
            end
            if ImGui.BeginDragDropSource(ImGuiDragDropFlags_.ImGuiDragDropFlags_None) then
                if self.m_currActor == nil then
                    self.m_currActor = g_DataStorage:AddStaticActor(v);
                    local action = LActionEntityInsert:new();
                    action:Init(self.m_currActor);
                    g_UndoRedoManager:AddAction(action);
                end
                local pos = ImGui.GetMousePos();
                local bResult, x, y, z = KLGameWorld.GetRayHitPointFromScreen(pos.x, pos.y, -1, -1, -1);
                if bResult == true then
                    self.m_currActor:SetWorldPosition(x, y, z);
                end
                ImGui.EndDragDropSource();
            end
        end
    end
end

function Ui:LoadResourceTableFile(szFilePath)
    local nTempIndex = 0;

    local vm = g_GetLuaVM();
    local szContent = vm:LoadTextFileToString(szFilePath);
    local lines = string.split(szContent, "\r\n");

    if #lines < 1 then
        LOG_I("[LTabFile:parse] 1, ", #lines)
        return;
    end

    local headers = self:parseLine(lines[1]);
    if headers == nil then
        LOG_I("[LTabFile:parse] 2, ", lines[1])
        return;
    end

    local nShellPath = self:GetIdxByName(headers, "ShellPath");
    local nSourcePath = self:GetIdxByName(headers, "SourcePath");

    local nRowCount = #lines;
    for i = 2, nRowCount do
        local cells = self:parseLine(lines[i]);
        if cells ~= nil then
            local lszShellPath = string.split(cells[nShellPath], "\\");
            local szSourcePath = cells[nSourcePath];
            local itrTable = self.m_tabResource;
            for nPathIndex = 1, #lszShellPath - 1 do
                local szNameTemp = lszShellPath[nPathIndex];
                local itrTemp = itrTable[szNameTemp];
                if itrTemp == nil then
                    itrTable[szNameTemp] = {};
                    itrTable = itrTable[szNameTemp];
                elseif type(itrTemp) == 'table' then
                    itrTable = itrTemp;
                end
            end
            itrTable[lszShellPath[#lszShellPath]] = szSourcePath;
        end
        nTempIndex = nTempIndex + 1;
        if nTempIndex > self.m_nLoadSpeed then
            nTempIndex = 0;
            coroutine.yield();
        end
    end
end

function Ui:parseLine(szLine)
    if string.sub(szLine, 1, 1) == "#" then
        return;
    end

    local cell = ""
    local cells = {}
    local szLas = nil

    for i=1,string.len(szLine) do
        szLas = string.sub( szLine, i, i )
        if szLas == '\t' then
            if string.sub(szLine,i+1,i+1)=='\t' or i == string.len( szLine )then
                if cell ~= "" then
                    table.insert( cells, cell )
                    cell = ""
                end
                table.insert( cells, "" )
            else
                if cell ~= "" then
                    table.insert( cells, cell )
                    cell = ""
                end
            end
        else
            cell = cell .. szLas;
        end
    end
    if cell ~= "" then
        table.insert( cells, cell )
    end

    return cells;
end

function Ui:GetIdxByName(tab, szName)
    for i = 1, #tab do
        if tab[i] == szName then
            return i;
        end
    end
    return 0;
end

UiInst = Ui:new();
