---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by gyz.
--- DateTime: 2020/09/01 14:45
---

local Config = Config or class("SchoolRoleListConfig");
local Lib = ImportScript("ugc_common/script/base/lib.lua");

local SchoolList = {
    "",
    "",
    "",
    "嶾",
    "",
    "ؽ",
    "",
    "",
    "",
    "ؤ",
    "",
    "",
    "Ե",
    "",
    "ѩ",
}

local RoleTypeList = {
    "",
    "Ů",
    "̫",
    "",
}

-- shaolin
local slRoleTypeList = {
    "",
    "̫",
}

-- qixiu 
local qxRoleTypeList = {
    "Ů",
    "̫",
    "",
}

-- use key[schoolListIdx][roleTypeListIdx]. such as [1][1] [1][2] [1][3] [1][4] ...
local SchoolModelInfo = {
    {
        "data/source/player/actor/cy_m2.actor",
        "data/source/player/actor/cy_f2.actor",
        "data/source/player/actor/cy_m1.actor",
        "data/source/player/actor/cy_f1.actor",
    },
    {
        "data/source/player/actor/wh_m2.actor",
        "data/source/player/actor/wh_f2.actor",
        "data/source/player/actor/wh_m1.actor",
        "data/source/player/actor/wh_f1.actor",
    },
    {
        "data/source/player/actor/tm_m2.actor",
        "data/source/player/actor/tm_f2.actor",
        "data/source/player/actor/tm_m1.actor",
        "data/source/player/actor/tm_f1.actor",
    },
    {
        "data/source/player/actor/wd_m2.actor",
        "data/source/player/actor/wd_f2.actor",
        "data/source/player/actor/wd_m1.actor",
        "data/source/player/actor/wd_f1.actor",
    },
    {
        "data/source/player/actor/tc_m2.actor",
        "data/source/player/actor/tc_f2.actor",
        "data/source/player/actor/tc_m1.actor",
        "data/source/player/actor/tc_f1.actor",
    },
    {
        "data/source/player/actor/cj_m2.actor",
        "data/source/player/actor/cj_f2.actor",
        "data/source/player/actor/cj_m1.actor",
        "data/source/player/actor/cj_f1.actor",
    },
    {
        "data/source/player/actor/sl_m2.actor",
        "data/source/player/actor/sl_m1.actor",
    },
    {
        "data/source/player/actor/qx_f2.actor",
        "data/source/player/actor/qx_m1.actor",
        "data/source/player/actor/qx_f1.actor",
    },
    {
        "data/source/player/actor/mj_m2.actor",
        "data/source/player/actor/mj_f2.actor",
        "data/source/player/actor/mj_m1.actor",
        "data/source/player/actor/mj_f1.actor",
    },
    {
        "data/source/player/actor/gb_m2.actor",
        "data/source/player/actor/gb_f2.actor",
        "data/source/player/actor/gb_m1.actor",
        "data/source/player/actor/gb_f1.actor",
    },
    {
        "data/source/player/actor/cangyun_m2.actor",
        "data/source/player/actor/cangyun_f2.actor",
        "data/source/player/actor/cangyun_m1.actor",
        "data/source/player/actor/cangyun_f1.actor",
    },
    {
        "data/source/player/actor/changge_m2.actor",
        "data/source/player/actor/changge_f2.actor",
        "data/source/player/actor/changge_m1.actor",
        "data/source/player/actor/changge_f1.actor",
    },
    {
        "data/source/player/actor/badao_m2.actor",
        "data/source/player/actor/badao_f2.actor",
        "data/source/player/actor/badao_m1.actor",
        "data/source/player/actor/badao_f1.actor",
    },
    {
        "data/source/player/actor/penglai_m2.actor",
        "data/source/player/actor/penglai_f2.actor",
        "data/source/player/actor/penglai_m1.actor",
        "data/source/player/actor/penglai_f1.actor",
    },
    {
        "data/source/player/actor/lxg_m2.actor",
        "data/source/player/actor/lxg_f2.actor",
        "data/source/player/actor/lxg_m1.actor",
        "data/source/player/actor/lxg_f1.actor",
    },
};

local SkillCfgPath = {
    [1] = "ugc_common\\settings\\character\\skill\\m2\\skill_m2.txt",
    [2] = "ugc_common\\settings\\character\\skill\\f2\\skill_f2.txt",
    [5] = "ugc_common\\settings\\character\\skill\\m1\\skill_m1.txt",
    [6] = "ugc_common\\settings\\character\\skill\\f1\\skill_f1.txt",
};

local AniCfgPath = "ugc_common\\settings\\character\\skill\\Ani.tab";


function Config:ctor()
    self.m_tbAniList = {};
end

function Config:dtor()
end

function Config:GetSchoolList()
    local tbSchoolList = {};

    for _, v in ipairs(SchoolList) do
        local szUtf8SchoolName = util.a2u8(v);
        table.insert(tbSchoolList, szUtf8SchoolName);
    end
    return tbSchoolList;
end

function Config:GetRoleTypeList()
    local tbRoleTypeList = {};

    for _, v in ipairs(RoleTypeList) do
        local szUtf8RoleTypeName = util.a2u8(v);
        table.insert(tbRoleTypeList, szUtf8RoleTypeName);
    end
    return tbRoleTypeList;
end

function Config:GetSlRoleTypeList()
    local tbSlRoleTypeList = {};

    for _, v in ipairs(slRoleTypeList) do
        local szUtf8RoleTypeName = util.a2u8(v);
        table.insert(tbSlRoleTypeList, szUtf8RoleTypeName);
    end
    return tbSlRoleTypeList;
end

function Config:GetQxRoleTypeList()
    local tbQxRoleTypeList = {};

    for _, v in ipairs(qxRoleTypeList) do
        local szUtf8RoleTypeName = util.a2u8(v);
        table.insert(tbQxRoleTypeList, szUtf8RoleTypeName);
    end
    return tbQxRoleTypeList;
end

function Config:GetSchoolModelInfo()
    local tbSchoolModelInfo = {};
    local tbIdxModelInfo = {};

    for schoolIdx, schoolModelInfo in ipairs(SchoolModelInfo) do
        tbIdxModelInfo = {};
        for _, v in ipairs(schoolModelInfo) do
            local szUtf8ModelInfo = util.a2u8(v)
            table.insert(tbIdxModelInfo, szUtf8ModelInfo);
        end
        tbSchoolModelInfo[schoolIdx] = tbIdxModelInfo;
    end

    return tbSchoolModelInfo;
end

function Config:GetSkillList(roleType, schoolIdx)
    local szCfgPath = SkillCfgPath[roleType];
    if not szCfgPath then
        return;
    end

    local tabFile = LTabFile:new(szCfgPath);
    if not tabFile:IsValid() then
        return;
    end
    local schoolIdx = tostring(schoolIdx);
    local tbSkillInfoList = {};
    local tbSkillItem = {};
    local nRowCount = tabFile:GetRowCount();
    local nSchoolColIdx = tabFile:GetColIdxByName("School");
    local nNameColIdx = tabFile:GetColIdxByName("Name");
    local nPathColIdx = tabFile:GetColIdxByName("Path");
    local szLastSchool = tabFile:GetString(1, nSchoolColIdx, nil);

    LOG_I("[Config:loadSkillListInfo] nRowCount", nRowCount);
    for i = 1, nRowCount do
        local szSchool = tabFile:GetString(i, nSchoolColIdx, nil);
        local szName = tabFile:GetString(i, nNameColIdx, nil);
        local szPath = tabFile:GetString(i, nPathColIdx, nil);
        if szName ~= nil and szPath ~= nil then
            if szSchool == szLastSchool then
                tbSkillItem[szName] = szPath;
            else
                tbSkillInfoList[szLastSchool] = tbSkillItem;
                tbSkillItem = {};
                tbSkillItem[szName] = szPath;
            end
            szLastSchool = szSchool;
        end
    end
    tbSkillInfoList[szLastSchool] = tbSkillItem;
    
    return tbSkillInfoList[schoolIdx];
end

--[[
    {
        [M2] = {
            "ӵ" = "data\source\player\F1\\F1_M2ӵF1a_.ani",
            "˵" = "Data\source\player\F1\\F1b02dj˵.tani",
            "" = "Data\source\player\F1\\F1b02dj.tani",
        },
        [F2] = {
            "ӵ" = "data\source\player\F1\\F1_M2ӵF1a_.ani",
            "˵" = "Data\source\player\F1\\F1b02dj˵.tani",
            "" = "Data\source\player\F1\\F1b02dj.tani",
        },
        ...
    }
]]

function Config:InitAniTable()
    local szCfgPath = AniCfgPath;
    if not szCfgPath then
        return;
    end

    local tabFile = LTabFile:new(szCfgPath);
    if not tabFile:IsValid() then
        return;
    end

    local tbAniList = {};
    local tbTypeAniList = {};
    local nRowCount = tabFile:GetRowCount();
    local nNameColIdx = tabFile:GetColIdxByName("Name");
    local nPathColIdx = tabFile:GetColIdxByName("SourcePath");
    local szRoleType = "";

    for i = 1, nRowCount do
        local szName = tabFile:GetString(i, nNameColIdx, nil);
        local szPath = tabFile:GetString(i, nPathColIdx, nil);

        if szName ~= nil then
            if string.find(szName, '[', 1, true) ~= nil then
                if not Lib.TableIsEmpty(tbTypeAniList) and szRoleType ~= "" then
                    tbAniList[szRoleType] = tbTypeAniList;
                end 
                szRoleType = "";
                szRoleType = string.sub(szName, 2, -2);
                szRoleType = string.lower(szRoleType);
                tbTypeAniList = {};
            else
                if szPath ~= nil then
                    tbTypeAniList[szName] = szPath;
                end

            end
        end
    end

    self.m_tbAniList = tbAniList;
end

function Config:GetAniListByRoleType(roleType)
    local tbRoleTypeAniList = {};
    if not Lib.TableIsEmpty(self.m_tbAniList) then
        tbRoleTypeAniList = self.m_tbAniList[roleType];
    end

    return tbRoleTypeAniList;
end

_G.g_SchoolRoleListCfg = Config:new();
