---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by gyz.
--- DateTime: 2020/09/01 15:20
---

local Cfg = ImportScript("ugc_common/script/cases/school_role_list/config.lua").g_SchoolRoleListCfg;
local Lib = ImportScript("ugc_common/script/base/lib.lua");

UI_SCHOOL_ROLE_LIST = "SchoolRoleListUi";
local Ui = Ui or class(UI_SCHOOL_ROLE_LIST, LUiBase);
_G.UI_SCHOOL_ROLE_LIST = UI_SCHOOL_ROLE_LIST;

function Ui:ctor()
    self.m_bOpen = false
    self.m_szName = UI_SCHOOL_ROLE_LIST

    self.m_szWndName                 = util.a2u8("ɫ");
    self.m_szSchoolComboName         = util.a2u8("б");
    self.m_szSchoolList              = Cfg:GetSchoolList();
    self.m_selectSchoolIdx           = 0;
    self.m_szRoleTypeComboName       = util.a2u8("")
    self.m_szRoleTypeList            = Cfg:GetRoleTypeList();
    self.m_szSlRoleTypeList          = Cfg:GetSlRoleTypeList();
    self.m_szQxRoleTypeList          = Cfg:GetQxRoleTypeList();
    self.m_selectRoleTypeIdx         = 0;
    self.m_szCreateActor             = util.a2u8("ɫ");
    self.m_szSchoolModelInfo         = Cfg:GetSchoolModelInfo();
    self.m_selectModelInfo           = "";
    self.m_pTexture                  = nil;
    self.m_szCreatedActor            = util.a2u8("ҵĽɫб");
    self.m_szDeleteActor             = util.a2u8("ɾɫ");
    self.m_selectActorName           = "";
    self.m_selectCreatedActorName    = "";
    self.m_tbCreatedActor            = {};
    self.m_curPreViewActor           = nil;
    self.m_szSaveActor               = util.a2u8("");    
end

function Ui:dtor()
end

function Ui:Init()
end

function Ui:UnInit()
end

function Ui:OnOpen()
    self:setSelectedIdxInfo();
    self:createPreViewActor();
    self:initCreatedActorList();
end

function Ui:OnClose()
    if self.m_curPreViewActor ~= nil then
        self.m_curPreViewActor:RemoveModelFromMiniScene();
        g_ActorManager:DestroyActor(self.m_curPreViewActor);
        self.m_curPreViewActor = nil;
    end
end

function Ui:initCreatedActorList()
    if Lib.TableIsEmpty(self.m_tbCreatedActor) then
        local tbActorInfo = g_SaveManager:GetActorInfoFromFile();
        if type(tbActorInfo) == 'table' then
            self.m_tbCreatedActor = tbActorInfo;
        end
    end
end

function Ui:GameTick()
end

function Ui:GameDraw()
    ImGui.SetNextWindowSize(ImVec2(1420, 880),ImGuiCond_.ImGuiCond_Always);
    _, self.m_bOpen = ImGui.Begin(self.m_szWndName, self.m_bOpen, ImGuiWindowFlags_.ImGuiWindowFlags_NoResize);

    self:draw();
    ImGui.End();
end

function Ui:draw()
    local schoolList = self.m_szSchoolList;
    local roleTypeList = self.m_szRoleTypeList;
    
    if #schoolList <= 0 or #roleTypeList <= 0 then
        return
    end

    ------ left ------
    ImGui.BeginChild("left pane", ImVec2(690, 0), true);
    if ImGui.BeginCombo(self.m_szSchoolComboName, schoolList[self.m_selectSchoolIdx], 0) then
        for idx, schoolName in ipairs(schoolList) do
            local bSelected = idx == self.m_selectSchoolIdx;
            if ImGui.Selectable(schoolName, bSelected) then
                self:setSelectedSchoolIdx(idx);
                self:setSelectedIdxInfo();
                self:createPreViewActor();
            end
            if bSelected then
                ImGui.SetItemDefaultFocus();
            end
        end
        ImGui.EndCombo();
    end
    
    if self.m_selectSchoolIdx == 7 then
        roleTypeList = self.m_szSlRoleTypeList;
    end
    if self.m_selectSchoolIdx == 8 then
        roleTypeList = self.m_szQxRoleTypeList;
    end

    if ImGui.BeginCombo(self.m_szRoleTypeComboName, roleTypeList[self.m_selectRoleTypeIdx], 0) then
        for idx, roleTypeName in ipairs(roleTypeList) do
            local bSelected = idx == self.m_selectRoleTypeIdx;
            if ImGui.Selectable(roleTypeName, bSelected) then
                self.m_selectRoleTypeIdx = idx;
                self:setSelectedIdxInfo();
                self:createPreViewActor();
            end
            if bSelected then
                ImGui.SetItemDefaultFocus();
            end
        end
        ImGui.EndCombo();
    end

    if ImGui.Button(self.m_szCreateActor) then
        self:createActor();
    end

    -- س(ʱText)
    ImGui.Text("");
    ImGui.Text("");
    ImGui.Separator();
    ImGui.Text(self.m_szCreatedActor);
    ImGui.SameLine();
    if ImGui.Button(self.m_szDeleteActor) then
        self:deleteActor();
    end
    
    self:drawCreatedActorInfo();
    g_TouchEventHandle:ScrollWhenDraggingOnVoid()
    ImGui.EndChild();

    ImGui.SameLine();
    ------ right ------
    ImGui.BeginChild("right pane", ImVec2(700, 0), true);
    self:drawModelPreView();
    ImGui.EndChild();

end

function Ui:setSelectedSchoolIdx(schoolIdx)
    if self.m_selectSchoolIdx == schoolIdx then
        return;
    end
    self.m_selectSchoolIdx = schoolIdx;
end

function Ui:setSelectedIdxInfo()
    local schoolList = self.m_szSchoolList;
    local roleTypeList = self.m_szRoleTypeList;
    
    if self.m_selectSchoolIdx == 7 then
        roleTypeList = self.m_szSlRoleTypeList;
        if self.m_selectRoleTypeIdx > 2 then
            self.m_selectRoleTypeIdx = 2;
        end
    end
    if self.m_selectSchoolIdx == 8 then
        roleTypeList = self.m_szQxRoleTypeList;
        if self.m_selectRoleTypeIdx > 3 then
            self.m_selectRoleTypeIdx = 3;
        end
    end

    if #schoolList <= 0 or #roleTypeList <= 0 then
        return
    end

    if self.m_selectSchoolIdx <= 0 or self.m_selectSchoolIdx > #schoolList then
        self:setSelectedSchoolIdx(1);
    end 
    if self.m_selectRoleTypeIdx <= 0 or self.m_selectRoleTypeIdx > #roleTypeList then
        self.m_selectRoleTypeIdx = 1;
    end

    self.m_selectModelInfo = self.m_szSchoolModelInfo[self.m_selectSchoolIdx][self.m_selectRoleTypeIdx];
    self.m_selectActorName = self:getActorName(self.m_selectModelInfo);
end

function Ui:createPreViewActor()
    -- ȫΨһԤģ,ÿξ´
    if self.m_curPreViewActor ~= nil then
        self.m_curPreViewActor:RemoveModelFromMiniScene();
        g_ActorManager:DestroyActor(self.m_curPreViewActor);
        self.m_curPreViewActor = nil;
    end
    
    local lPreViewActor = g_ActorManager:CreateSkeletalMeshActor(self.m_selectModelInfo);
    lPreViewActor:AddModelToMiniScene();
    lPreViewActor:SetWorldPosition(0, 0, 0);
    lPreViewActor:LookAtEnable(false);

    self.m_curPreViewActor = lPreViewActor;
end

function Ui:drawModelPreView()
    local texId = KLGameWorld.RenderMiniSceneToTexture(680, 780);
    texId = KLImGui.ToImGuiTextureID(texId)
    ImGui.Image(texId, ImVec2(680, 780));
end

function Ui:drawCreatedActorInfo()
    for actorIdx, tbActorInfo in ipairs(self.m_tbCreatedActor) do
        for actorName, info in pairs(tbActorInfo) do
            if actorName ~= nil and actorName == "Name" then
                local szSelectedItem = self.m_selectCreatedActorName == info;
                if ImGui.Selectable(info, szSelectedItem) then
                    if info ~= self.m_selectCreatedActorName then
                        self.m_selectCreatedActorName = info;
                        self:changeCreatedActor(actorIdx);
                    end
                    
                end
            end
        end
    end
end
--[[----------------------------------------------------------------
jsondef:
{
    {
	 	Name = "cy_M2_2607",
	 	Path = "data/source/player/actor/cy_M2_2607.actor",
        Json = "",
        School = "",
    },
    ...
}

--]]
function Ui:generateModelInfo()
    local tbTmpCreatedActorInfo = {};
    local lLocalPlayer = g_ActorManager:GetLocalPlayer();
    if lLocalPlayer ~= nil then
        tbTmpCreatedActorInfo["Name"] = self.m_selectActorName;
        tbTmpCreatedActorInfo["Path"] = self.m_selectModelInfo;
        tbTmpCreatedActorInfo["Json"] = g_ActorManager:GetActorJsonString(lLocalPlayer);
        tbTmpCreatedActorInfo["School"] = self.m_selectSchoolIdx;
        tbTmpCreatedActorInfo["RoleType"] = lLocalPlayer:GetRoleType();
    end

    return tbTmpCreatedActorInfo;
end

-- 
function Ui:createActor()
    local bExist = self:IsExistActor(self.m_selectActorName);

    if not bExist then
        local bARMode = KLPlatformNative:IsARMode();
        self:createNewActor(self.m_selectModelInfo, self.m_selectSchoolIdx, bARMode);
        
        -- ɴ浵Ϣ
        local tbTmpCreatedActorInfo = {};
        tbTmpCreatedActorInfo = self:generateModelInfo();
        table.insert(self.m_tbCreatedActor, tbTmpCreatedActorInfo);
        self.m_selectCreatedActorName = self.m_selectActorName;
        
        -- save by the way
        g_SaveManager:SaveActorInfoToFile(self.m_tbCreatedActor);
    end
end

-- ɾ
function Ui:deleteActor() 
    for actorIdx, tbActorInfo in ipairs(self.m_tbCreatedActor) do
        for actorName, info in pairs(tbActorInfo) do
            if actorName ~= nil and actorName == 'Name' then
                if self.m_selectCreatedActorName == info then
                    table.remove(self.m_tbCreatedActor, actorIdx);
                    
                    local lLocalPlayer = g_ActorManager:GetLocalPlayer();
                    lLocalPlayer:RemoveModelFromScene();
                    g_ActorManager:DestroyActor(lLocalPlayer);

                    g_SaveManager:SaveActorInfoToFile(self.m_tbCreatedActor);
                end
            end
        end
    end
end

function Ui:createNewActor(actorInfo, schoolIdx, bARMode)
    local lLocalPlayer = g_ActorManager:GetLocalPlayer();
    if lLocalPlayer then
        if not bARMode then
            lLocalPlayer:RemoveModelFromScene();
            g_ActorManager:DestroyActor(lLocalPlayer);
        else
            lLocalPlayer:SetAdditionnalObjectVisibal("ѡЧa003.sfx", false);
        end
    end

    local lCreateActor = g_ActorManager:CreateSkeletalMeshActor(actorInfo);
    lCreateActor:AddModelToScene();
    lCreateActor:SetWorldPosition(0, 0, 0);
    g_ActorManager:SetLocalPlayer(lCreateActor);
    lCreateActor:SetSchoolIdx(schoolIdx);

    if bARMode then 
        lCreateActor:SetAdditionnalObjectVisibal("ѡЧa003.sfx", true);
    end
end

-- л
function Ui:changeCreatedActor(actorIdx, actorName)
    local actorSchoolIdx = self.m_tbCreatedActor[actorIdx]["School"];
    local selectActorInfo = self.m_tbCreatedActor[actorIdx]["Path"];
    local roleType = self.m_tbCreatedActor[actorIdx]["RoleType"];
    local lLocalPlayer = g_ActorManager:GetLocalPlayer();
    local lLocalRoleType = 0;
    local lLocalSchoolIdx = 0;
    if lLocalPlayer then
        lLocalRoleType = lLocalPlayer:GetRoleType();
        lLocalSchoolIdx = lLocalPlayer:GetSchoolIdx();
    end
    
    if actorSchoolIdx ~= lLocalSchoolIdx or roleType ~= lLocalRoleType then
        local bARMode = KLPlatformNative:IsARMode(); 
        self:createNewActor(selectActorInfo, actorSchoolIdx, bARMode);
    end
end

function Ui:getActorName(actorPath) 
    local path = string.reverse(actorPath);
    local length = string.len(path);
    local start = 1
    local strend = -1

    if string.find(path, '/', 1, true) ~= nil then
        start = length - string.find(path, '/', 1, true) + 2;
    end
    if string.find(path, '.', 1, true) ~= nil then
        strend = length - string.find(path, '.', 1, true);
    end

    return string.sub(actorPath, start, strend);
end

function Ui:IsExistActor(nameInfo)
    local bExist = false;

    for actorIdx, tbActorInfo in ipairs(self.m_tbCreatedActor) do
        for actorName, info in pairs(tbActorInfo) do
            if actorName == 'Name' and info == nameInfo then
                bExist = true;
            end
        end
    end

    return bExist;
end

UiInst = Ui:new();