---
--- Date         : 2020-08-13 10:22:49
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-14 11:42:32
--- Description  : DetailPage
---
local LBaseVehiclePage = ImportScript("ugc_common/script/cases/vehicle/base.page.lua").LBaseVehiclePage;
local Dataset          = ReLoadScript("ugc_common/script/cases/vehicle/dataset.lua");

---
--- ģϸҳ
---
--- @class DetailPage
---
DetailPage = DetailPage or class("DetailPage", LBaseVehiclePage);

function DetailPage:ctor()
    self.m_model = nil;
    self.m_uiText = {
        drive    = util.a2u8("ʻ"),
        assemble = util.a2u8("װ"),
        back     = util.a2u8(""),
        propTip  = util.a2u8(""),
        inrtoTip = util.a2u8("޽"),
        tip      = util.a2u8("ؾϢ"),
    };
    self.m_styles = {
        modelCardSize       = ImVec2:new_local(135, 170),
        cardChildWndSize    = ImVec2:new_local(150, 175),
        propChildWndSize    = ImVec2:new_local(350, 200),
        introChildWndSize   = ImVec2:new_local(450, 485),
        operateChildWndSize = ImVec2:new_local(450, 40),
        operateButtonSize   = ImVec2:new_local(75, 35),
    };
end

function DetailPage:dtor() end

---
--- ò
---
--- @param params table
--- @param params.model LBaseAssemble
--- @return void
---
function DetailPage:SetParams(params)
    if params and params.model then
        self.m_model = params.model;
    end
end

function DetailPage:Nav(parent, operate)
    if operate == "DRIVE" then
        parent:To(parent.m_pages.Driving, {
            model = self.m_model
        });
        parent:Hidden();
        self.m_model:CreateActor();
    end
    if operate == "ASSEMBLE" then
        parent:To(parent.m_pages.Assemble, {
            model = self.m_model
        });
        self.m_model:CreateActor();
    end
    if operate == "BACK" then
        parent:To(parent.m_pages.ModelList);
    end
end

function DetailPage:DrawUI(parent)
    local styles  = self.m_styles;
    local operate = nil;

    -- Line 1
    ImGui.Text(self.m_uiText.tip);
    ImGui.Separator();
    ImGui.BeginChild("ModelCard", styles.cardChildWndSize, false);
        ImGui.Button(self.m_model.m_strName, styles.modelCardSize);
    ImGui.EndChild();
    ImGui.SameLine();
    ImGui.BeginChild("Property", styles.propChildWndSize, false);
        ImGui.Text(self.m_uiText.propTip);
    ImGui.EndChild();

    -- Line 2
    ImGui.Separator();
    ImGui.BeginChild("Intro", styles.introChildWndSize, false);
        ImGui.Text(self.m_uiText.inrtoTip);
    ImGui.EndChild();
    ImGui.Separator();
    ImGui.BeginChild("Operate", styles.operateChildWndSize, false);
        if ImGui.Button(self.m_uiText.back, styles.operateButtonSize) then
            operate = "BACK";
        end
        ImGui.SameLine(100);
        if ImGui.Button(self.m_uiText.drive, styles.operateButtonSize) then
            operate = "DRIVE";
        end
        ImGui.SameLine(200);
        if ImGui.Button(self.m_uiText.assemble, styles.operateButtonSize) then
            operate = "ASSEMBLE";
        end
    ImGui.EndChild();
    self:Nav(parent, operate);
end
