---
--- Date         : 2020-08-13 10:22:49
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-20 11:30:37
--- Description  : DrivingPage
---
local LBaseVehiclePage = ImportScript("ugc_common/script/cases/vehicle/base.page.lua").LBaseVehiclePage;
local Dataset          = ImportScript("ugc_common/script/cases/vehicle/dataset.lua");

---
--- ģϸҳ
---
--- @class DrivingPage
---
DrivingPage = DrivingPage or class("DrivingPage", LBaseVehiclePage);

function DrivingPage:ctor()
    self.m_model  = nil;
    self.m_io     = ImGui.GetIO();
    self.m_cameraType = "role";
    self.m_uiText = {
        closeBtn     = util.a2u8("˳ʻ"),
        viewAngleBtn = util.a2u8("лӽ"),
    };
    self.m_styles = {
        mainSize  = ImVec2:new_local(200, 200),
        speedSize = ImVec2:new_local(150, 50),
        btnSize   = ImVec2:new_local(80, 80),
        mainWndFlags = bit.ors(
            ImGuiWindowFlags_.ImGuiWindowFlags_NoResize,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoCollapse,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoTitleBar,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoScrollbar,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoMove
        ),
        speedWndFlags = bit.ors(
            ImGuiWindowFlags_.ImGuiWindowFlags_NoResize,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoCollapse,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoTitleBar,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoScrollbar,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoMove
        ),
    };
end

function DrivingPage:dtor() end

---
--- ò
---
--- @param params table
--- @param params.model LBaseAssemble
--- @return void
---
function DrivingPage:SetParams(params)
    if params and params.model then
        self.m_model = params.model;
    end
end

function DrivingPage:DrawUI(parent)
    local styles           = self.m_styles;
    local DISTANCE         = 10.0;
    local window_pos       = ImVec2:new_local(10.0, 10.0);
    local window_pos_pivot = ImVec2:new_local(1.0, 1.0);

    if (self.m_io) then
        window_pos.x = self.m_io.DisplaySize.x - DISTANCE;
        window_pos.y = self.m_io.DisplaySize.y - DISTANCE;
    end

    ImGui.SetNextWindowPos(window_pos, ImGuiCond_.ImGuiCond_Always, window_pos_pivot);
    ImGui.SetNextWindowSize(styles.mainSize, ImGuiCond_.ImGuiCond_Always);
    ImGui.SetNextWindowBgAlpha(0.35);

    _, self.m_bOpen = ImGui.Begin("#DrivingMode", self.m_bOpen, styles.mainWndFlags);
        -- ImGui.BeginChild("#SpeedPanel", styles.speedSize, false, styles.speedWndFlags);
            
        -- ImGui.EndChild();
        if ImGui.Button(self.m_uiText.viewAngleBtn, styles.btnSize) and self.m_model then
            local cameraType = "role";
            if self.m_cameraType == "role" then
                cameraType = "first_person";
            end
            self.m_cameraType = cameraType;
            KLGameWorld.CameraSwitch(cameraType);
        end
        ImGui.SameLine(100);
        if ImGui.Button(self.m_uiText.closeBtn, styles.btnSize) and self.m_model then
            self.m_model:DestroyActor();
            parent:Show();
            parent:To(parent.m_pages.Detail, {
                model = self.m_model
            });
            KLGameWorld.CameraSwitch("role");
        end
        ImGui.Separator();
        if type(self.m_model.DrawControlTipWidget) == "function" then
            self.m_model:DrawControlTipWidget();
        end
    ImGui.End();
end
