---
--- Date         : 2020-08-13 10:22:49
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-18 17:55:33
--- Description  : ModelsPage
---
local LBaseVehiclePage = ImportScript("ugc_common/script/cases/vehicle/base.page.lua").LBaseVehiclePage;
local Dataset          = ReLoadScript("ugc_common/script/cases/vehicle/dataset.lua");

---
--- ģѡtabҳ
---
--- @class ModelsPage
---
ModelsPage = ModelsPage or class("ModelsPage", LBaseVehiclePage);

function ModelsPage:ctor()
    self.m_bFlightTabItem = true;
    self.m_bCarTabItem    = true;
    self.m_flightModels   = Dataset.GetModels(Dataset.LAssembleRegistered.LSimpleFlightAssemble);
    self.m_carModels      = Dataset.GetModels(Dataset.LAssembleRegistered.LWheeledVehicleAssemble);
    self.m_uiText         = {
        car    = util.a2u8(""),
        flight = util.a2u8(""),
    };
    self.m_styles = {
        modelCardSize = ImVec2:new_local(135, 170)
    };
end
function ModelsPage:dtor() end
function ModelsPage:SetParams(...) end

function ModelsPage:ReLoadModels()
    self.m_flightModels = Dataset.GetModels(Dataset.LAssembleRegistered.LSimpleFlightAssemble);
    self.m_carModels    = Dataset.GetModels(Dataset.LAssembleRegistered.LWheeledVehicleAssemble);
end

function ModelsPage:DrawUI(parent)
    local tab_bar_flags = ImGuiTabBarFlags_.ImGuiTabBarFlags_None;
    local tab_itm_flags = ImGuiTabItemFlags_.ImGuiTabItemFlags_NoCloseWithMiddleMouseButton;
    local styles        = self.m_styles;
    local selected      = nil;
    if ImGui.BeginTabBar("VehicleTab", tab_bar_flags) then
        if ImGui.BeginTabItem(self.m_uiText.car, self.m_bCarTabItem, tab_itm_flags) then
            selected = DrawModelUI("#car", self.m_carModels, styles.modelCardSize);
            ImGui.EndTabItem();
        end
        if ImGui.BeginTabItem(self.m_uiText.flight, self.m_bFlightTabItem, tab_itm_flags) then
            selected = DrawModelUI("#flight", self.m_flightModels, styles.modelCardSize);
            ImGui.EndTabItem();
        end
        ImGui.EndTabBar();
    end

    if selected then
        parent:To(parent.m_pages.Detail, {
            model = selected
        });
    end
end

---
--- ģб
---
--- @param id string
--- @param models table<number, LBaseAssemble>
--- @param size ImVec2
--- @return LBaseAssemble | nil
---
function DrawModelUI(id, models, size)
    local selected  = nil;
    local nRemoveK  = -1;
    local nMaxIndex = #models;
    ImGui.Columns(4, id, false);
    for key, model in ipairs(models) do
        if ImGui.Button(model.m_strName, size) then
            selected = model;
        end
        if ImGui.BeginPopupContextItem(id .. "@" .. model.m_strName) then
            if ImGui.Selectable("Delete") then
                nRemoveK = key;
            end
            ImGui.EndPopup();
        end
        if key < nMaxIndex then
            ImGui.NextColumn();
        end
    end
    ImGui.Columns(1);
    if nRemoveK > 0 then
        Dataset.RemoveModel(table.remove(models, nRemoveK));
    end
    return selected;
end