---
--- Date         : 2020-07-13 09:55:47
--- Author       : LICHAO7
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-14 13:10:40
--- Description  : ؾ߿ܣؾ߼Ҫҳ֮л״̬
---
_G.UI_VEHICLE       = "Vehicle";
local Ui            = Ui or class(_G.UI_VEHICLE, LUiBase);
local Dataset       = ReLoadScript("ugc_common/script/cases/vehicle/dataset.lua");
local ModelsPage    = ReLoadScript("ugc_common/script/cases/vehicle/models.page.lua").ModelsPage;
local DetailPage    = ReLoadScript("ugc_common/script/cases/vehicle/detail.page.lua").DetailPage;
local AssemblePage  = ReLoadScript("ugc_common/script/cases/vehicle/assemble.page.lua").AssemblePage;
local DrivingPage   = ReLoadScript("ugc_common/script/cases/vehicle/driving.page.lua").DrivingPage;

function Ui:ctor()
    self.m_bOpen    = false;
    self.m_bVisible = true;
    self.m_szName   = _G.UI_VEHICLE;
    self.m_szTitle  = util.a2u8("ؾ");
    self.m_pages    = {
        ModelList = ModelsPage:new(),
        Detail    = DetailPage:new(),
        Assemble  = AssemblePage:new(),
        Driving   = DrivingPage:new(),
    };
    self.m_page       = self.m_pages.ModelList;
    self.m_tabUiText  = {

    };
    self.m_tabStyle = {
        size    = ImVec2:new_local(600, 860),
        wndFlag = bit.ors(
            ImGuiWindowFlags_.ImGuiWindowFlags_NoResize,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoCollapse,
            -- ImGuiWindowFlags_.ImGuiWindowFlags_NoTitleBar,
            ImGuiWindowFlags_.ImGuiWindowFlags_NoScrollbar
            -- ImGuiWindowFlags_.ImGuiWindowFlags_NoMove
        ),
    };
end

function Ui:dtor()
    self.m_bOpen = false;
end

function Ui:SetOpenClose(bOpen)
    self.m_bOpen = bOpen or false;
end

function Ui:IsOpen()
    return self.m_bOpen;
end

function Ui:GameDraw()
    if self.m_bVisible then
        DrawUI(self);
    elseif self.m_page == self.m_pages.Driving then
        self.m_page:DrawUI(self);
    end
end

function Ui:To(page, params)
    local bRetCode = false;
    for key, value in pairs(self.m_pages) do
        if value == page then
            self.m_page = page;
            self.m_page:SetParams(params);
            bRetCode = true;
            break;
        end
    end
    return bRetCode;
end

function Ui:Hidden()
    self.m_bVisible = false;
end

function Ui:Show()
    self.m_bVisible = true;
end

---
--- UI draw
---
--- @param self Ui
--- @return number
---
function DrawUI(self)
    local DISTANCE         = 20.0;
    local window_pos       = ImVec2:new_local(0.0, 20.0);
    local window_pos_pivot = ImVec2:new_local(0.0, 0.0);
    local window_size      = ImVec2:new_local(600, 800);
    local style            = self.m_tabStyle;

    if (self.m_io) then
        window_pos.x  = self.m_io.DisplaySize.x - DISTANCE;
        window_pos.y  = self.m_io.DisplaySize.y - DISTANCE;
        window_size.x = self.m_io.DisplaySize.x - DISTANCE;
        window_size.y = self.m_io.DisplaySize.y - DISTANCE;
    end

    -- ImGui.SetNextWindowPos(window_pos, ImGuiCond_.ImGuiCond_Always, window_pos_pivot);
    ImGui.SetNextWindowSize(window_size, ImGuiCond_.ImGuiCond_Always);

    _, self.m_bOpen = ImGui.Begin(self.m_szTitle, self.m_bOpen, style.wndFlag);
        if self.m_page and self.m_page.DrawUI then
            self.m_page:DrawUI(self);
        end
    ImGui.End();
end

UiInst = Ui:new();
