ImportScript("ugc_common/script/core/ui/ui_manager.lua")
ImportScript("ugc_common/script/core/event/event_dispatcher.lua");
ImportScript("ugc_common/script/core/game_state/game_state_manager.lua");

if PLATFORM_PC then
    ImportScript("ugc_common/script/net/protocol_handler.lua")
end

---@class LuaApp
LuaApp = LuaApp or class("LuaApp");

function LuaApp:ctor()
    --
end

function LuaApp:dtor()
    --
end

function LuaApp:Init(bDebug)
    if not PLATFORM_PC then
        local glsl_version = "#version 300 es";
        
        ImGui.CreateContext(nil);
        local io = ImGui.GetIO();
        local fonts = io.Fonts;
        local glyp = fonts:GetGlyphRangesChineseFull();
        fonts:AddFontFromFileTTF("data/font/fz.ttf", 50.0, nil, glyp);
    
        ImGui_ImplGlfw_InitForOpenGL(nil, true);
        ImGui_ImplOpenGL3_Init(glsl_version);
    end

    self.m_bDebug = bDebug or false;
    g_GameStateManager:Init();
end

function LuaApp:UnInit()
    if not PLATFORM_PC then
        ImGui_ImplOpenGL3_Shutdown();
        ImGui_ImplGlfw_Shutdown();
        ImGui.DestroyContext();
    end

    g_GameStateManager:UnInit();
end

function LuaApp:IsPC()
    return PLATFORM_PC or false;
end

function LuaApp:IsDebug()
    return self.m_bDebug or false;
end

function LuaApp:GameTick()
    local func = function ()
        g_GameStateManager:GameTick();
        g_uiManager:GameTick();
        if g_NetWorking then
            g_NetWorking:GameTick();
        end
    end
    xpcall(func, Traceback)
end

function bool2Int(v)
    if v then
        return 1;
    else
        return 0;
    end
end

function LuaApp:GameDraw()
    if not PLATFORM_PC then
        ImGui_ImplOpenGL3_NewFrame();

        local engineCore = X3D.GetEngineCoreInterface();
        local looppasttime = X3D.GetLoopPastTime();
        local touchState = engineCore:GetTouchState();
        local width = engineCore:GetScreenWidth();
        local height = engineCore:GetScreenHeight();
        local bTouch = bool2Int(touchState == KTOUCH_EVENT.TOUCH_MOVE_EVENT or touchState == KTOUCH_EVENT.TOUCH_DOWN_EVENT or touchState == KTOUCH_EVENT.TOUCH_RIGHT_MOVE_EVENT);
        local touchX = engineCore:GetTouchX();
        local touchY = engineCore:GetTouchY();
        local curStyle = ImGuiStyle:new_local()
        curStyle = ImGui.GetStyle()
        curStyle.ScrollbarSize = 30.0
        ImGui_ImplGlfw_NewFrame(width, height, looppasttime, bTouch, touchX, touchY);
    
        ImGui.NewFrame();

        g_LogicManager:Update();
    end
    
    local func = function ()
        g_uiManager:GameDraw();
    end

    if not PLATFORM_PC then
        if not KLPlatformNative:IsRecording() then
            xpcall(func, Traceback)
        end
    else
        xpcall(func, Traceback)
    end

    if not PLATFORM_PC then
        ImGui.Render();
        ImGui_ImplOpenGL3_RenderDrawData(ImGui.GetDrawData());
    end
end

function LuaApp:OnEvent(moduleName, eventType, eventData)
    LOG_I("[LuaApp:OnEvent] ", moduleName, eventType, eventData);
    xpcall(g_EventDispatcherManager.DispatchEvent, Traceback, g_EventDispatcherManager, moduleName, eventType, eventData);
end

function LuaApp:NetMsgProc(msgType, msgLen, msgData)
    --LOG_I("[LuaApp:NetMsgProc] ", msgType, msgLen, string.len(msgData));
    --print("msg Len :: " .. msgLen .. " ; " .. string.len(msgData));
    local data = string.sub(msgData,1,msgLen) 
    g_NetProtoHandler:MsgProc(msgType, data);
end

function LuaApp:ReloadModule(module)
    local func = function ()
        LOG_I("ReloadModule: ", module);
        ReLoadScript(module);
    end
    xpcall(func, Traceback)
end

_G.g_App = LuaApp:new();
