---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by luojunxin.
--- DateTime: 2020/7/6 11:11
---

LDataStorage = LDataStorage or class("LDataStorage");

function LDataStorage:ctor()
    self.m_actors = {};
    --self.m_selected = {};
    self.m_currID = 0;
    ImportScript("ugc_common/script/core/data_layer/undo_redo/undo_redo_manager.lua");
end

function LDataStorage:dtor()
end

function LDataStorage:AddStaticActor(szMeshPath)
    local lActor = g_ActorManager:CreateStaticMeshActor(util.u82a(szMeshPath));
    if lActor ~= nil then
        local lstPath = string.split(szMeshPath, "\\");
        local szFileName = lstPath[#lstPath];
        lActor:SetName(szFileName);
        self.m_actors[tostring(lActor.m_id)] = lActor;
        return lActor;
    end
end

function LDataStorage:DestroyActor(id)
    local szID;
    local actor;
    if type(id) == "number" then
        szID = tostring(id);
    elseif type(id) == "string" then
        szID = id;
    end
    actor = self.m_actors[szID];
    if actor ~= nil then
        g_ActorManager:DestroyActor(actor);
    end
    self.m_actors[szID] = nil;
end

function LDataStorage:GetCurrentID()
    return self.m_currID;
end

function LDataStorage:SetCurrentID(id)
    if type(id) == "number" then
        self.m_currID = tostring(id);
    elseif type(id) == "string" then
        self.m_currID = id;
    end
end

function LDataStorage:GetCurrentEntity()
    return self.m_actors[self.m_currID];
end

function LDataStorage:Save()
    local szMapName = self:GetCurrentMapName();
    local szFilePath = "UGCSource\\custom\\" .. szMapName .. "\\" .. szMapName .. "_custom_scene.json";
    local json = {};
    json["version"] = "MiniClient Save File 0.1";
    json["entities"] = self:SaveEntities();
    local jsonContent = cjson.encode(json);
    self:MakePath(szFilePath);
    local file, error = io.open(szFilePath, "w+b");
    if file ~= nil then
        file:write(jsonContent);
        io.close(file);
    end
end

function LDataStorage:MakePath(szFilePath)
    local szParentPath = FS.Path.SplitDir(szFilePath);
    if FS.Path.Exists(szParentPath) == false then
        self:MakePath(szParentPath);
        FS.MakeDir(szParentPath);
    end
end

function LDataStorage:Load()
    local func = function ()
        local szMapName = self:GetCurrentMapName();
        local szFilePath = "UGCSource\\custom\\" .. szMapName .. "\\" .. szMapName .. "_custom_scene.json";
        local file, error = io.open(szFilePath, "rb");
        if file ~= nil then
            local jsonContent = file:read("*a");
            io.close(file);
            local json = cjson.decode(jsonContent);
            self:LoadEntities(json["entities"]);
        end
    end
    xpcall(func, Traceback)
end

function LDataStorage:GetCurrentMapName()
    if self.m_szCurrMapName == nil then
        local szFilePath = g_GameStateManager.m_szMapPath;
        szFilePath = string.replace(szFilePath, ".", "\\");
        local tabPaths = string.split(szFilePath, "\\");
        self.m_szCurrMapName = tabPaths[#tabPaths - 1];
    end
    return self.m_szCurrMapName;
end

function LDataStorage:SaveEntities()
    local tabEntities = {};
    for k,v in pairs(self.m_actors) do
        local tabEntity = {};
        tabEntity["name"] = v:GetName();
        tabEntity["file"] = util.a2u8(v:GetMeshRes());
        local bResult, fTempX, fTempY, fTempZ = v:GetLocalPosition();
        if bResult == true then
            tabEntity["position"] = fTempX .. "," .. fTempY .. "," .. fTempZ;
        end
        bResult, fTempX, fTempY, fTempZ = v:GetLocalRotation();
        if bResult == true then
            tabEntity["rotation"] = fTempX .. "," .. fTempY .. "," .. fTempZ;
        end
        bResult, fTempX, fTempY, fTempZ = v:GetLocalScale();
        if bResult == true then
            tabEntity["scale"] = fTempX .. "," .. fTempY .. "," .. fTempZ;
        end
        tabEntity["collision_type"] = v:GetCollisionType();
        tabEntity["simulate_physics"] = v:IsSimulatePhysics();
        table.insert(tabEntities, tabEntity)
    end
    return tabEntities;
end

function LDataStorage:LoadEntities(tabEntities)
    for k,v in pairs(self.m_actors) do
        self:DestroyActor(k);
    end
    for k,tabEntity in pairs(tabEntities) do
        local lActor = self:AddStaticActor(tabEntity["file"]);
        lActor:SetName(tabEntity["name"]);
        local vec3 = string.split(tabEntity["position"], ",");
        lActor:SetLocalPosition(tonumber(vec3[1]), tonumber(vec3[2]), tonumber(vec3[3]));
        vec3 = string.split(tabEntity["rotation"], ",");
        lActor:SetLocalRotation(tonumber(vec3[1]), tonumber(vec3[2]), tonumber(vec3[3]));
        vec3 = string.split(tabEntity["scale"], ",");
        lActor:SetLocalScale(tonumber(vec3[1]), tonumber(vec3[2]), tonumber(vec3[3]));
        lActor:SetCollisionType(tonumber(tabEntity["collision_type"]));
        lActor:SetSimulatePhysics(tabEntity["simulate_physics"] == "true");
    end
end

_G.g_DataStorage = LDataStorage:new();