---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/6/15 14:42
---

---@class LTabFile
local LTabFile = LTabFile or class("LTabFile");

function LTabFile:ctor(szFilePath)
    LOG_I("[LTabFile:ctor]", szFilePath);
    self.m_szFilePath = szFilePath;
    self.m_tabHeaders = {}
    self.m_tabCells = {}    -- 
    self.m_bSuc = self:parse();
    if self.m_bSuc ~= true then
        LOG_I("[LTabFile:ctor] load or parse file failed, ", szFilePath);
    end
end

function LTabFile:dtor()
    --
end

function LTabFile:parseLine(szLine)
    if string.sub(szLine, 1, 1) == "#" then
        return;
    end

    local cell = ""
    local cells = {}
    local szLas = nil

    for i=1,string.len(szLine) do
        szLas = string.sub( szLine, i, i )
        if szLas == '\t' then
            if string.sub(szLine,i+1,i+1)=='\t' or i == string.len( szLine )then
                if cell ~= "" then
                    table.insert( cells, cell )
                    cell = ""
                end
                table.insert( cells, "" )
            else
                if cell ~= "" then
                    table.insert( cells, cell )
                    cell = ""
                end
            end
        else
            cell = cell .. szLas;
        end
    end
    if cell ~= "" then
        table.insert( cells, cell )
    end
    
    return cells;
end

function LTabFile:parse()
    local vm = g_GetLuaVM();
    local szContent = vm:LoadTextFileToString(self.m_szFilePath);
    local lines = string.split(szContent, "\r\n");

    if #lines < 1 then
        LOG_I("[LTabFile:parse] 1, ", #lines)
        return;
    end

    local headers = self:parseLine(lines[1]);
    if headers == nil then
        LOG_I("[LTabFile:parse] 2, ", lines[1])
        return;
    end

    self.m_tabHeaders = headers;
    local nColCount = #self.m_tabHeaders;
    local nRowCount = #lines;
    for i = 2, nRowCount do
        local cells = self:parseLine(lines[i]);
        if cells ~= nil then
            table.insert(self.m_tabCells, cells);
        end
    end
    return true;
end

---@return boolean
function LTabFile:IsValid()
    return self.m_bSuc;
end

---@return number
function LTabFile:GetRowCount()
    return #self.m_tabCells;
end

---@return number
function LTabFile:GetColCount()
    return #self.m_tabHeaders;
end

---@param szColName string
---@return number
function LTabFile:GetColIdxByName(szColName)
    for i = 1, #self.m_tabHeaders do
        if self.m_tabHeaders[i] == szColName then
            return i;
        end
    end
    return 0;
end

---@param nRow number
---@param col number or string
---@param nDefault number
---@return number
function LTabFile:GetNumber(nRow, col, nDefault)
    local nCol = col;
    if type(col) == "string" then
        nCol = self:GetColIdxByName(col);
    end
    if nRow > #self.m_tabCells or nRow <= 0 then
        return nDefault;
    end
    if nCol > #self.m_tabHeaders or nCol <= 0 then
        return szDefault;
    end
    local tabLineCells = self.m_tabCells[nRow];
    if nCol > #tabLineCells then
        return nDefault;
    end
    return tonumber(tabLineCells[nCol]);
end

---@param nRow number
---@param col number or string
---@param szDefault string
---@return number
function LTabFile:GetString(nRow, col, szDefault)
    local nCol = col;
    if type(col) == "string" then
        nCol = self:GetColIdxByName(col);
    end
    if nRow > #self.m_tabCells or nRow <= 0 then
        return szDefault;
    end
    if nCol > #self.m_tabHeaders or nCol <= 0 then
        return szDefault;
    end
    local tabLineCells = self.m_tabCells[nRow];
    if nCol > #tabLineCells then
        return szDefault;
    end
    return tabLineCells[nCol];
end

_G.LTabFile = LTabFile;
