---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by HUAFEI2.
--- DateTime: 2020/5/27 16:11
---

---@class LUiManager
local LUiManager = LUiManager or class("LUiManager", nil);

--[[
LUiManager = {
    m_uiSet = {
        ["uiName"] = uiInst, ...
    },
}
--]]

--- Add any universal UI here.
--- @field table
local UiList = {
    "ugc_common/script/cases/main_menu_bar/ui.lua",
    "ugc_common/script/cases/change_cloth/ui.lua",
    "ugc_common/script/cases/make_face/ui.lua",
    "ugc_common/script/cases/game_setting/ui.lua",
}

if PLATFORM_PC then
    -- Add some PC specific UI here.
    table.insert(UiList, "ugc_common/script/cases/ingame_console/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/lute_simulator/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/vehicle/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/destruction/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/flight_list/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/entity_list_view/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/entity_property_view/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/model_list_view/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/actor_attributes_demo/ui.lua");
else
    -- Add some Mobile specific UI here.
    table.insert(UiList, "ugc_common/script/cases/general_setting/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/school_role_list/ui.lua");
    table.insert(UiList, "ugc_common/script/cases/ar_setting/ui.lua");
end

function LUiManager:ctor()
    self.m_uiSet = {};
    self:Init()
end

function LUiManager:dtor()
    self:UnInit()
end

function LUiManager:Init()
    for _, script in ipairs(UiList) do
        local uiModule = ReLoadScript(script);
        local uiInst = uiModule.UiInst;
        local uiName = uiInst:GetName();
        LOG_I("[LUiManager:Init] ", uiInst, uiName)
        if self.m_uiSet[uiName] then
            LOG_I("[Error] found same name ui inst: "..uiName..", script: "..script)
        else
            self.m_uiSet[uiName] = uiInst;
            LOG_I("LUiManager:Init: ", uiName, script)
        end
    end
end

function LUiManager:UnInit()
    --
end

function LUiManager:GameTick()
    for _, uiInst in pairs(self.m_uiSet) do
        if uiInst:IsOpen() then
            uiInst:GameTick();
        end
    end
end

function LUiManager:GameDraw()
    for _, uiInst in pairs(self.m_uiSet) do
        if uiInst:IsOpen() then
            uiInst:GameDraw();
            if not uiInst:IsOpen() then
                uiInst:OnClose();
            end
        end
    end
end

---@param szUiName string
---@return string
function LUiManager:GetOpenClose(szUiName)
    local UiInst = self.m_uiSet[szUiName];
    if UiInst == nil then
        return false;
    end

    return UiInst:IsOpen();
end

---@param szUiName string
---@param bOpen boolean
function LUiManager:SetOpenClose(szUiName, bOpen)
    local UiInst = self.m_uiSet[szUiName];
    LOG_I("LUiManager:SetOpenClose", szUiName, bOpen, UiInst);
    if UiInst == nil then
        return;
    end

    local bOldOpen = UiInst:IsOpen();
    UiInst:SetOpenClose(bOpen);
    local bNewOpen = UiInst:IsOpen();
    if not bOldOpen and bNewOpen then
        UiInst:OnOpen();
    elseif bOldOpen and not bNewOpen then
        UiInst:OnClose();
    end
end

_G.g_uiManager = LUiManager:new();
