---
--- Date         : 2020-06-24 15:35:42
--- Author       : HuaFei2
--- LastEditors  : LICHAO7
--- LastEditTime : 2020-08-14 16:03:17
--- Description  : Main
---
PLATFORM_PC = false
RUN_TEST    = false;

-- package.cpath = package.cpath .. ";c:/Users/Kingsoft/.vscode/extensions/tangzx.emmylua-1.0.0/debugger/emmy/windows/x64/?.dll"
-- local dbg = require("emmy_core")
-- dbg.tcpListen("localhost", 9966)

---
--- Global scripts.
---
--- @type table
---
TabExecuteScriptFile = {
    "ugc_common/script/base/utils.lua",
    "ugc_common/script/base/string.lua",
    "ugc_common/script/base/bit.lua",
    "ugc_common/script/base/os.lua",
    "ugc_common/script/base/fs.lua",
    "ugc_common/script/base/class.lua",
    "ugc_common/script/base/class_usage.lua",
    "ugc_common/script/base/loader.lua",
    "ugc_common/script/base/log.lua",
    "ugc_common/script/base/array.lua",
    "ugc_common/script/base/table.lua",
    "ugc_common/script/base/json.lua",
    "ugc_common/script/math/include.lua",
};

---
--- Any platform scripts.
---
--- @type table
---
TabAnyPlatformScriptFile = {
    "ugc_common/script/core/file/tabfile.lua",
    "ugc_common/script/core/define.lua",
    "ugc_common/script/core/global_table.lua",
    "ugc_common/script/core/event/event_dispatcher.lua",
    "ugc_common/script/core/ui/ui_base.lua",
    "ugc_common/script/core/data_layer/data_storage.lua",
    "ugc_common/script/core/environment/base_weather.lua",
    "ugc_common/script/core/base_engine_option.lua",
};

---
--- PC platform scripts.
---
--- @type table
---
TabPCScriptFile = {
    "ugc_common/script/pc/hbui/event.lua",
    "ugc_common/script/pc/hbui/dispatcher.lua",
    "ugc_common/script/pc/actor/actor_impl.lua",
    "ugc_common/script/pc/actor/static_mesh_actor_impl.lua",
    "ugc_common/script/pc/actor/emitter_impl.lua",
    "ugc_common/script/pc/actor/skeletal_mesh_actor_impl.lua",
    "ugc_common/script/pc/actor/actor_manager_impl.lua",
    "ugc_common/script/pc/scene/scene_manager_impl.lua",
    "ugc_common/script/pc/camera/camera_controller.lua",
    "ugc_common/script/pc/game_state/game_state_manager_impl.lua",
    "ugc_common/script/net/proto/protocol.lua",
    "ugc_common/script/net/networking.lua",
    "ugc_common/script/pc/environment/weather.lua",
    "ugc_common/script/pc/engine_option.lua",
};

---
--- Mobile platform scripts.
---
--- @type table
---
TabMobileScriptFile = {
    "ugc_common/script/mobile/actor/actor_impl.lua",
    "ugc_common/script/mobile/actor/actor_manager_impl.lua",
    "ugc_common/script/mobile/actor/skeletal_mesh_actor_impl.lua",
    "ugc_common/script/mobile/actor/static_mesh_actor_impl.lua",
    "ugc_common/script/mobile/camera/camera_controller.lua",
    "ugc_common/script/mobile/main_logic/save_manager.lua",
    "ugc_common/script/cases/school_role_list/role_list_manager.lua",
    "ugc_common/script/mobile/game_state/game_state_manager_impl.lua",
    "ugc_common/script/mobile/scene/scene_manager_impl.lua",
    "ugc_common/script/mobile/gesture/touch_controller.lua",
    "ugc_common/script/mobile/gesture/touch_event_handle.lua",
    "ugc_common/script/mobile/main_logic/logic_manager.lua",
};

---
--- Test scripts.
---
--- @return void
---
function RunTest()
    if RUN_TEST then
        local Test = ImportScript("ugc_common/script/test/run.lua");
        Test.AnyStart();
        Test.PCStart();
        Test.MobileStart();
    end
end

---
--- Main.
---
--- @param bPC boolean
--- @return void
---
function Main(bPC)
    PLATFORM_PC = bPC

    local vm = g_GetLuaVM();
    print("[Main] Loading scriptlist..", proto);

    -- Global scripts.
    for index, script in ipairs(TabExecuteScriptFile) do
        vm:ExecuteScriptFile(script);
    end

    -- Any platform scripts.
    for index, script in ipairs(TabAnyPlatformScriptFile) do
        ImportScript(script);
    end

    -- PC or mobile scripts.
    local platformScript = TabPCScriptFile;
    if not bPC then
        platformScript = TabMobileScriptFile;
    end
    for index, script in ipairs(platformScript) do
        ImportScript(script);
    end

    -- Core App.
    ImportScript("ugc_common/script/core/app.lua");

    -- Run Testcase if RUN_TEST else skip.
    RunTest();
end
