---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by gyz.
--- DateTime: 2020/6/29 14:42
---

local LBaseActor = ImportScript("ugc_common/script/core/actor/actor.lua").LBaseActor;

---@class LActor
LActor = LActor or class("LActor", LBaseActor);

---@param kActor KActorModelHelper
function LActor:ctor(kActor)
    self.m_kActor = kActor 
    self.m_name = self:ToString(); --"LActor0"
    self.m_id = self.m_kActor:GetId();
end

function LActor:dtor()
    print("LActor:dtor()", self.m_name, self.m_kActor);
    self.m_id = nil;
end

---@return KActorModelHelper
function LActor:GetKActor()
    return self.m_kActor;
end

---@return number
function LActor:GetId()
    if self.m_kActor ~= nil then
        return self.m_kActor:GetId();
    end
    return 0;
end

---@return string
function LActor:GetType()
    return "LActor";
end

---@return boolean
function LActor:IsValid()
    return false
    --return KLActorManager.IsValidActor(self.m_id);
end

---@return boolean
---@param fX number
---@param fY number
---@param fZ number
function LActor:SetWorldPosition(fX, fY, fZ)
    self.m_kActor:SetWorldPosition(fX, fY, fZ);
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetWorldPosition()
    print("LActor:GetWorldPosition: ", self.m_name, self.m_kActor, self.m_kActor.GetId)
    return true, self.m_kActor:GetWorldPosition(0, 0, 0);
end

---@return boolean
---@param fYaw number
---@param fPitch number
---@param fRoll number
function LActor:SetWorldRotation(fYaw, fPitch, fRoll)
    self.m_kActor:SetWorldRotation(fYaw, fPitch, fRoll);
    return true;
end

---@return boolean
---@return number fPitch
---@return number fYaw
---@return number fRoll
function LActor:GetWorldRotation()
    return true, self.m_kActor:GetWorldRotation(0, 0, 0);
end

---@return boolean
---@param fX number
---@param fY number
---@param fZ number
function LActor:SetWorldScale(fX, fY, fZ)
    self.m_kActor:SetWorldScale(fX, fY, fZ);
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetWorldScale()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetWorldScale(0, 0, 0);
end

---@return boolean
---@param fX number
---@param fY number
---@param fZ number
function LActor:SetLocalPosition(fX, fY, fZ)
    self.m_kActor:SetLocalPosition(fX, fY, fZ);
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetLocalPosition()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetLocalPosition(0, 0, 0);
end

---@return boolean
---@param fPitch number
---@param fYaw number
---@param fRoll number
function LActor:SetLocalRotation(fPitch, fYaw, fRoll)
    self.m_kActor:SetLocalRotation(fPitch, fYaw, fRoll)
    return true;
end

---@return boolean
---@return number fYaw
---@return number fPitch
---@return number fRoll
function LActor:GetLocalRotation()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetLocalRotation(0, 0, 0);
end

---@return boolean
---@param fX number
---@param fY number
---@param fZ number
function LActor:SetLocalScale(fX, fY, fZ)
    self.m_kActor:SetLocalScale(fX, fY, fZ)
    return true;
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LActor:GetLocalScale()
    if not self:IsValid() then
        return false;
    end
    return true, self.m_kActor:GetLocalScale(0, 0, 0);
end

---@return boolean
---@param bVisible boolean
function LActor:SetVisible(bVisible)
    if bVisible == nil then
        return
    end
    return self.m_kActor:SetVisible(bVisible);
end

---@return boolean
function LActor:IsVisible()
    return self.m_kActor:IsVisible();
end

-----------------------------------------ATTACHMENT ABOUT-----------------------------------------

---@return boolean
function LActor:IsUsingAbsolutePosition()
    return self.m_kActor:IsUsingAbsolutePosition();
end

---@return boolean
function LActor:IsUsingAbsoluteRotation()
    return self.m_kActor:IsUsingAbsoluteRotation();
end

---@return boolean
function LActor:IsUsingAbsoluteScale()
    return self.m_kActor:IsUsingAbsoluteScale();
end

---@return boolean
---@param bAbsolutePosition boolean
---@param bAbsoluteRotation boolean
---@param bAbsoluteScale boolean
function LActor:SetAbsolute(bAbsolutePosition, bAbsoluteRotation, bAbsoluteScale)
    return self.m_kActor:SetAbsolute(bAbsolutePosition, bAbsoluteRotation, bAbsoluteScale);
end

---@return LBaseActor
function LActor:GetAttachParent()
    local kActor = self.m_kActor:GetAttachParent();
    if kActor == nil then
        return nil;
    end
    local actorId = kActor:GetId();
    return g_ActorManager:GetActorById(actorId);
end

---@return boolean
---@param lActor LBaseActor
---@param szBoneName string
---@param eAttachRule number
function LActor:AttachToBone(lActor, szBoneName, eAttachRule)
    local kActor = lActor:GetKActor();
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToBone(kActor, szBoneName, eAttachRule);
end

---@return boolean
---@param lActor LBaseActor
---@param szSocketName string
---@param eAttachRule number
function LActor:AttachToSocket(lActor, szSocketName, eAttachRule)
    local kActor = lActor:GetKActor();
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToSocket(kActor, szSocketName, eAttachRule);
end

---@return boolean
---@param lActor LBaseActor
---@param szAnchorPointName string
---@param eAttachRule number
function LActor:AttachToAnchorPoint(lActor, szAnchorPointName, eAttachRule)
    local kActor = lActor:GetKActor();
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToAnchorPoint(kActor, szAnchorPointName, eAttachRule);
end

---@return boolean
---@param lActor LBaseActor
---@param eAttachRule number
function LActor:AttachToParent(lActor, eAttachRule)
    local kActor = lActor:GetKActor();
    LOG_I("[LActor:AttachToParent] ", kActor, lActor.m_kActor, eAttachRule);
    if kActor == nil then
        return false;
    end
    return self.m_kActor:AttachToParent(kActor, eAttachRule);
end

---@return boolean
function LActor:DetachFromParent()
    return self.m_kActor:DetachFromParent();
end

---@return boolean
function LActor:AddModelToScene()
    local curActorModel = self.m_kActor:GetActorModel()
    if not curActorModel then
        LOG_I("[actor_impl:AddModelToScene]curActoeModel is nil")
    end
    if curActorModel then
        KLGameWorld.AddModelToScene(curActorModel)
    end

    return true;
end

---@return boolean
function LActor:RemoveModelFromScene()
    local curActorModel = self.m_kActor:GetActorModel()
    if not curActorModel then
        LOG_I("[actor_impl:RemoveModelFromScene]curActoeModel is nil")
    end
    if curActorModel then
        KLGameWorld.RemoveModelFromScene(curActorModel)
    end

    return true;
end

---@return boolean
function LActor:AddModelToMiniScene()
    local curActorModel = self.m_kActor:GetActorModel()
    if not curActorModel then
        LOG_I("[actor_impl:AddModelToScene]curActoeModel is nil")
    end
    if curActorModel then
        KLGameWorld.AddModelToMiniScene(curActorModel)
    end

    return true;
end

---@return boolean
function LActor:RemoveModelFromMiniScene()
    local curActorModel = self.m_kActor:GetActorModel()
    if not curActorModel then
        LOG_I("[actor_impl:RemoveModelFromScene]curActoeModel is nil")
    end
    if curActorModel then
        KLGameWorld.RemoveModelFromMiniScene(curActorModel)
    end

    return true;
end

---@return number
function LActor:GetRoleType()
    return self.m_kActor:GetRoleType();
end

---@return string
function LActor:GetStrRoleType()
    return self.m_kActor:GetStrRoleType();
end

---@return boolean
function LActor:InitLookAt()
    self.m_kActor:InitLookAt();
    return true;
end

---@return boolean
function LActor:LookAtTarget(fX, fY, fZ)
    self.m_kActor:LookAtTarget(fX, fY, fZ);
    return true;
end

---@return boolean
function LActor:LookAtEnable(bEnable)
    self.m_kActor:LookAtEnable(bEnable);
    return true;
end

_G.LActor = LActor;
