---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by gyz.
--- DateTime: 2020/6/29 14:43
---

local LBaseActorManager = ImportScript("ugc_common/script/core/actor/actor_manager.lua").LBaseActorManager;
local LSkeletalMeshActor = ImportScript("ugc_common/script/mobile/actor/skeletal_mesh_actor_impl.lua").LSkeletalMeshActor;
local LStaticMeshActor = ImportScript("ugc_common/script/mobile/actor/static_mesh_actor_impl.lua").LStaticMeshActor;
local LLocalPlayer = ImportScript("ugc_common/script/mobile/actor/local_player_impl.lua").LLocalPlayer;


---@class LActorManager
LActorManager = LActorManager or class("LActorManager", LBaseActorManager);

function LActorManager:ctor()
    self.m_actors = {};
    table.insert(self.m_actors, self.localPlayer);
end

function LActorManager:dtor()
    self.m_actors = nil;
end

---@return LLocalPlayer
function LActorManager:CreateLocalPlayer(szMeshPath)
    local kActor = KLActorManager.CreateActorByFile(szMeshPath);
    if not kActor then
        return nil;
    end

    local fFaceX,fFaceY,fFaceZ = kActor:GetModelFaceCenter(0,0,0)
    local bottomActor = self:CreateAdditionalObject(kActor,"data/source/other/Ч/ϵͳ/sfx/ѡ/ѡЧa003.sfx")
    bottomActor:SetWorldPosition(fFaceX, 0, fFaceZ)
    bottomActor:SetWorldScale(0.5,0.5,0.5)
    bottomActor:SetVisible(false)

    LOG_I("LActorManager:CreateLocalPlayer", kActor, LSkeletalMeshActor, LSkeletalMeshActor.GetId, LSkeletalMeshActor.__cname);
    local lActor = LLocalPlayer:new(kActor);
    local actorId = lActor:GetId();
    lActor:InsertAdditionnalObject(bottomActor,"data/source/other/Ч/ϵͳ/sfx/ѡ/ѡЧa003.sfx")
    LOG_I("LActorManager:CreateLocalPlayer", actorId, lActor);
    self.m_actors[actorId] = lActor;
    self.localPlayer = lActor;
    
    return lActor;
end

---@return LSkeletalMeshActor
---@param szMeshPath string
function LActorManager:CreateSkeletalMeshActor(szMeshPath)
    if not szMeshPath then
        return;
    end
    local kActor = KLActorManager.CreateActorByFile(szMeshPath);
    if not kActor then
        return nil;
    end
    LOG_I("LActorManager:CreateSkeletalMeshActor begin", kActor, szMeshPath);

    local fFaceX,fFaceY,fFaceZ = kActor:GetModelFaceCenter(0,0,0)
    local bottomActor = self:CreateAdditionalObject(kActor,"data/source/other/Ч/ϵͳ/sfx/ѡ/ѡЧa003.sfx")
    bottomActor:SetWorldPosition(fFaceX, 0, fFaceZ)
    bottomActor:SetWorldScale(0.5,0.5,0.5)
    bottomActor:SetVisible(false)

    local lActor = LSkeletalMeshActor:new(kActor);
    local actorId = lActor:GetId();
    lActor:InsertAdditionnalObject(bottomActor,"data/source/other/Ч/ϵͳ/sfx/ѡ/ѡЧa003.sfx")
    LOG_I("LActorManager:CreateSkeletalMeshActor mid", actorId, lActor);
    self.m_actors[actorId] = lActor;
    return lActor;
end

---@return LStaticMeshActor
---@param szMeshPath string
function LActorManager:CreateStaticMeshActor(szMeshPath)
    if not szMeshPath then
        return;
    end

    local kActor = KLActorManager.CreateActorByFile(szMeshPath);
    if not kActor then
        return nil;
    end
    LOG_I("LActorManager:CreateStaticMeshActor begin", kActor, szMeshPath);

    local lActor = LStaticMeshActor:new(kActor);
    local actorId = lActor:GetId();
    LOG_I("LActorManager:CreateStaticMeshActor mid", actorId, lActor);
    self.m_actors[actorId] = lActor;
    return lActor;
end

---@return
function LActorManager:CreateAdditionalObject(kActor,meshPath)
    local AoActor = KLActorManager.CreateMeshModel(meshPath)
    local AoModel = AoActor:GetActorModel()
    if kActor then
        AoModel:BindToNone(kActor:GetActorModel())
    end
    return AoActor
end

---@return boolean
---@param lActor LActor
function LActorManager:DestroyActor(lActor)
    LOG_I("LActorManager:DestroyActor: ", lActor);
    
    if not lActor then
        return
    end

    local actorId = lActor:GetId();
    LOG_I("LActorManager:DestroyActor: ", actorId);
    local actorInst = lActor:GetKActor();
    lActor:UnInit()
    KLActorManager.DestroyActor(actorInst);

    if self.m_actors[actorId] == self.localPlayer then
        self.localPlayer = nil;
    end
    self.m_actors[actorId] = nil;
end

---@return LActor
function LActorManager:GetActorById(actorId)
    return self.m_actors[actorId]
end

---@return boolean
function LActorManager:SetLocalPlayer(lActor)
    if not lActor then
        return 
    end
    
    self.localPlayer = lActor
end

---@return LSkeletalMeshActor
function LActorManager:GetLocalPlayer()
    return self.localPlayer;
end

---@return boolean
function LActorManager:DestroyAllActor()
    for _, v in pairs(self.m_actors) do
        v:RemoveModelFromScene();
        self:DestroyActor(v)
    end
end

---@return boolean
function LActorManager:ResetActorCreatedInfo()
    for _, v in pairs(self.m_actors) do
        if v ~= self.localPlayer then
            v:RemoveModelFromScene();
            self:DestroyActor(v)
        end
    end
end

function LActorManager:GetActorJsonString(actor)
    if not actor then
        return;
    end

    local kActor = actor:GetKActor();
    if not kActor then
        return;
    end

    local strJson = kActor:GetActorJsonString();
    return strJson;
end

function LActorManager:LoadActorFromJson(strJson)
    if type(strJson) ~= "string" then
        return;
    end
   
    local kActor = KLActorManager.LoadActorFromJsonString(strJson);
    if not kActor then
        return nil;
    end
    LOG_I("LActorManager:LoadActorFromJson begin");

    local lActor = LSkeletalMeshActor:new(kActor);
    local actorId = lActor:GetId();
    LOG_I("LActorManager:LoadActorFromJson mid", actorId, lActor);
    self.m_actors[actorId] = lActor;
    return lActor;

end


_G.g_ActorManager = LActorManager:new();
