---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by gyz.
--- DateTime: 2020/6/11 14:43
---

local LBaseSkeletalMeshActor = ImportScript("ugc_common/script/core/actor/skeletal_mesh_actor.lua").LBaseSkeletalMeshActor;
local LActor = ImportScript("ugc_common/script/mobile/actor/actor_impl.lua").LActor;

---@class LSkeletalMeshActor
LSkeletalMeshActor = LSkeletalMeshActor or class("LSkeletalMeshActor", LBaseSkeletalMeshActor, LActor);

function LSkeletalMeshActor:ctor(kActor)
    self.m_kSkeletalMeshActor = kActor
    self.m_tbAdditionalMesh = {}
    LOG_I("LSkeletalMeshActor:ctor", self, kActor, self.m_name, self.m_kSkeletalMeshActor)
    self.m_partBinder = self.m_kSkeletalMeshActor;
    self.m_szSchoolIdx = 0;
end

function LSkeletalMeshActor:dtor()
    print("LSkeletalMeshActor:dtor()");
    self.m_partBinder = nil;
end

function LSkeletalMeshActor:UnInit()
    for key, value in pairs(self.m_tbAdditionalMesh) do
        if value.actor then
            local AoActor = value.actor
            KLActorManager.DestroyActor(AoActor)
        end
    end
    self.m_tbAdditionalMesh = nil
end

---@return boolean
---@param szMeshPath string
function LSkeletalMeshActor:SetMeshRes(szMeshPath)
    return false
    --return self.m_kSkeletalMeshActor:SetMeshRes(szMeshPath);
end

---@return boolean
---@param nPartIdx number
---@param szMeshPath string
---@param szBindPoint string
function LSkeletalMeshActor:BindActorPart(nPartIdx, szMeshPath, szBindPoint)
    return self.m_partBinder:BindPartMesh(nPartIdx, szMeshPath, szBindPoint);
end

---@return boolean
---@param nPartIdx number
function LSkeletalMeshActor:ExistPartMesh(nPartIdx)
    return self.m_partBinder:ExistPartMesh(nPartIdx);
end

---@return boolean
---@param nPartIdx number
function LSkeletalMeshActor:UnBindActorPart(nPartIdx)
    return self.m_partBinder:UnBindPartMesh(nPartIdx);
end

function LSkeletalMeshActor:GetBoxSize()
    return self.m_partBinder:GetBoxSize(0,0,0)
end

function LSkeletalMeshActor:GetModelPosition()
    return self.m_partBinder:GetModelPosition(0,0,0)
end

function LSkeletalMeshActor:SetWorldRotation(fYaw, fPitch, fRoll)
    return self.m_partBinder:SetWorldRotation(fYaw, fPitch, fRoll)
end

---@param nRoleType number
---@param nType number
---@param nID number
---@param nColorID number
---@return number R
---@return number G
---@return number B
---@return number A
function LSkeletalMeshActor:GetFaceDecalColor(nRoleType,nType,nID,nColorID)
    return true,self.m_partBinder:GetFaceDecalColor(nRoleType,nType,nID,nColorID,0,0,0,0);
end

---@return boolean
---@return number fX
---@return number fY
---@return number fZ
function LSkeletalMeshActor:GetModelFaceCenter()
    return true,self.m_partBinder:GetModelFaceCenter(0,0,0);
end

---@param tbFaceBoneValueChoosed table
function LSkeletalMeshActor:GetFaceBoneDefinition(tbFaceBoneValueChoosed)
    return true,self.m_partBinder:GetFaceBoneDefinition(tbFaceBoneValueChoosed,#tbFaceBoneValueChoosed)
end

---@param tbFaceDecalsValueChoosed table
function LSkeletalMeshActor:GetFaceDecalsDefinition(tbFaceDecalsValueChoosed)
    return true,self.m_partBinder:GetFaceDecalsDefinition(tbFaceDecalsValueChoosed,#tbFaceDecalsValueChoosed)
end

---@param tbFaceColorValueChoosed table
function LSkeletalMeshActor:GetFaceColorsDefinition(tbFaceColorValueChoosed)
    return true,self.m_partBinder:GetFaceColorsDefinition(tbFaceColorValueChoosed,#tbFaceColorValueChoosed)
end

---@param tbFaceCustomDecalValueChoosed table
function LSkeletalMeshActor:GetFaceCustomDecalsDefinition(tbFaceCustomDecalValueChoosed)
    return true,self.m_partBinder:GetFaceCustomDecalsDefinition(tbFaceCustomDecalValueChoosed,#tbFaceCustomDecalValueChoosed)
end

---@param tbFaceBoneValues table
function LSkeletalMeshActor:SetFaceBoneParams(tbFaceBoneValues)
    return true,self.m_partBinder:SetFaceBoneParams(tbFaceBoneValues,#tbFaceBoneValues);
end

---@param nRoleType number
---@param tbFaceDecalValues table
function LSkeletalMeshActor:SetFaceDecal(nRoleType,tbFaceDecalValues)
    return true,self.m_partBinder:SetFaceDecal(nRoleType,tbFaceDecalValues,#tbFaceDecalValues);
end

---@param nRoleType number
---@param tbFaceColorValues table
function LSkeletalMeshActor:SetFaceColor(nRoleType,tbFaceColorValues)
    return true,self.m_partBinder:SetFaceColor(nRoleType,tbFaceColorValues,#tbFaceColorValues);
end

---@param nRoleType number
---@param tbFaceCustomDecalValues table
function LSkeletalMeshActor:SetFaceCustomDecal(nRoleType,tbFaceCustomDecalValues)
    return true,self.m_partBinder:SetFaceCustomDecal(nRoleType,tbFaceCustomDecalValues,#tbFaceCustomDecalValues);
end

---@param szFilePath string
function LSkeletalMeshActor:SetRandomFace(szFilePath)
    return true,self.m_partBinder:SetRandomFace(szFilePath);
end

---@param szFilePath string
function LSkeletalMeshActor:SetFaceINIFile(szFilePath)
    return true,self.m_partBinder:SetFaceINIFile(szFilePath);
end


---@return boolean
function LSkeletalMeshActor:ClearActorPart()
    return self.m_partBinder:ClearPartMesh();
end

---@return boolean
function LSkeletalMeshActor:LoadDefaultAnimation()
    return self.m_partBinder:LoadDefaultAnimation()
end

---@return boolean
---@param szFileName string
---@param nPlayMode number
function LSkeletalMeshActor:LoadAnimation(szFileName, nPlayMode)
    return self.m_partBinder:LoadAnimation(szFileName, nPlayMode)
end

---@return boolean
function LSkeletalMeshActor:RegisterAniEventHandler()
    return self.m_partBinder:RegisterEventHandler()
end

---@return boolean
function LSkeletalMeshActor:UnregisterAniEventHandler()
    return self.m_partBinder:UnregisterEventHandler()
end

function LSkeletalMeshActor:InsertAdditionnalObject(AoActor,AoPath)
    local str = string.split(AoPath,"/")
    local AoName = str[#str]
    if not self.m_tbAdditionalMesh then
        self.m_tbAdditionalMesh = {}
    end

    if not self.m_tbAdditionalMesh[AoName] then
        self.m_tbAdditionalMesh[AoName] = {}
    end

    local model = AoActor:GetActorModel()
    model:AddRef()
    self.m_tbAdditionalMesh[AoName].actor = AoActor
    self.m_tbAdditionalMesh[AoName].visible = false
end

function LSkeletalMeshActor:RemoveAdditionnalObject(AoPath)
    local str = string.split(AoPath,"/")
    local AoName = str[#str]
    if self.m_tbAdditionalMesh[AoName] then
        self.m_tbAdditionalMesh[AoName] = nil
    end
end

---@return KActorModelHelper*
---@param AoName string
function LSkeletalMeshActor:GetAdditionnalObject(AoName)
    if self.m_tbAdditionalMesh[AoName] then
        return self.m_tbAdditionalMesh[AoName].actor
    end
    return nil
end

function LSkeletalMeshActor:SetAdditionnalObjectVisibal(AoName,bVisible)
    if self.m_tbAdditionalMesh[AoName] then
        local AoActor = self.m_tbAdditionalMesh[AoName].actor
        AoActor:SetVisible(bVisible)
        self.m_tbAdditionalMesh[AoName].visible = bVisible
    end
end

function LSkeletalMeshActor:ConverseAdditionnalObjectVisibal(AoName)
    if self.m_tbAdditionalMesh[AoName] then
        local actor = self.m_tbAdditionalMesh[AoName].actor
        self.m_tbAdditionalMesh[AoName].visible = not self.m_tbAdditionalMesh[AoName].visible
        actor:SetVisible(self.m_tbAdditionalMesh[AoName].visible)
    end
end

function LSkeletalMeshActor:SetSchoolIdx(schoolIdx)
    self.m_szSchoolIdx = schoolIdx;
end

function LSkeletalMeshActor:GetSchoolIdx()
    return self.m_szSchoolIdx;
end
