-- main logic
local LLogicManager = LLogicManager or class("LLogicManager");
local Lib = ImportScript("ugc_common/script/base/lib.lua");

function LLogicManager:ctor()
    self.m_tbSkill = {};
end


function LLogicManager:dtor()
end

function LLogicManager:Init()

end

function LLogicManager:UnInit()

end

function LLogicManager:OnPlayAnimationFinish(nId)

    if nId > 0 then
        local lPlayer = g_ActorManager:GetActorById(nId)
        if not Lib.TableIsEmpty(self.m_tbSkill) then
            if self.m_tbSkill[1] ~= nil then
                lPlayer:LoadAnimation(self.m_tbSkill[1], 1);
                table.remove(self.m_tbSkill, 1);
            end
        else
            self.m_tbSkill = {};
            lPlayer:LoadDefaultAnimation();
            lPlayer:UnregisterAniEventHandler()
        end
    end
end

function LLogicManager:SetSkillQueue(tbSkillInfo)
    self.m_tbSkill = {};
    
    if type(tbSkillInfo) == 'table' then
        self.m_tbSkill = tbSkillInfo;
    end
end

function LLogicManager:UpdateLookAt()
    local fX = 0;
    local fY = 0;
    local fZ = 0;

    local lPlayer = g_ActorManager:GetLocalPlayer();
    if lPlayer then
        _, fX, fY, fZ = g_CameraController:GetPosition();
        lPlayer:LookAtTarget(fX, fY, fZ);
    end
end

function LLogicManager:Update()
	self:UpdateLookAt();
end


_G.g_LogicManager = LLogicManager:new();


