-- save manager
local LSaveManager = LSaveManager or class("LSaveManager");
local Lib = ImportScript("ugc_common/script/base/lib.lua");

function LSaveManager:ctor()
    self.MODELS_DIR = "Models"
    self.MODELS_FILE = "modellist.dat"
end

function LSaveManager:dtor()
end

function LSaveManager:Init()
end

function LSaveManager:UnInit()
end

function LSaveManager:GetModelDir()
    local strDir = KLPlatformNative:KLGetPlatformIOPath() .."/"..self.MODELS_DIR;

    if not KLPlatformNative:KLExist(strDir) then
        KLPlatformNative:KLRecursiveCreate(strDir);
    end

    return strDir;
end

--[[
Simple example:
local g_SaveActorInfo =
{
    {
	 	Name = "cy_M2_2607",
	 	Path = "data/source/player/actor/cy_M2_2607.actor",
        Json = "",
        School = "",
    },
    ...
}

SaveActorInfoToFile(g_SaveActorInfo);
--]]

function LSaveManager:SaveActorInfoToFile(tbActorJsonInfo)
    local saveFilePath = self:GetModelDir() .. "/" .. self.MODELS_FILE;
    KLPlatformNative:KLWriteFile(saveFilePath, Lib.Val2Str(tbActorJsonInfo));
end


function LSaveManager:GetActorInfoFromFile()
    local saveFilePath = self:GetModelDir() .. "/" .. self.MODELS_FILE;
    local actorInfo = KLPlatformNative:KLReadFile(saveFilePath);
    KLPlatformNative:ClearFileBuffer();
    local validLenth = KLPlatformNative:GetFileLen(saveFilePath);
    local tbActorInfo = {};

    if actorInfo then
        local len = string.len(actorInfo);
        if validLenth < len and validLenth > 0 then
            actorInfo = string.sub(actorInfo, 1, validLenth);
        end
        tbActorInfo = Lib.Str2Val(actorInfo);
    end

    return tbActorInfo;
end


_G.g_SaveManager = LSaveManager:new();


