---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by gyz.
--- DateTime: 2020/6/30 11:30
---

local LBaseSceneManager = ImportScript("ugc_common/script/core/scene/scene_manager.lua").LBaseSceneManager;

---@class LSceneManager
local LSceneManager = LSceneManager or class("LSceneManager", LBaseSceneManager);

function LSceneManager:ctor()
    self.m_tbPointLightMarkModel = {}
end

function LSceneManager:dtor()
    --
end

function LSceneManager:UnInit()
    for key, value in pairs(self.m_tbPointLightMarkModel) do
        if value then
            KLActorManager.DestroyActor(value)
        end
    end
    self.m_tbAdditionalMesh = nil
end

---@param szResPath string
---@param szPlotPath string
---@return boolean
function LSceneManager:BrowseMapByResPath(szResPath, szPlotPath)
    if not szPlotPath then
        szPlotPath = "";
    end

    return KLGameWorld.BrowseMapByResPath(szResPath);
end

---@return boolean
function LSceneManager:CreateMiniScene(szResPath)
    return KLGameWorld.CreateMiniScene(szResPath);
end

---@return boolean
function LSceneManager:DestroyCurMap()
    self:UnInit()
    return KLGameWorld.DestroyCurMap();
end

---@return number
function LSceneManager:GetModelFromScenePos(nPosX, nPosY)
    return KLGameWorld.GetModelFromScenePos(nPosX, nPosY)
end

function LSceneManager:GetScenePosFromPlanePos()
    local x,y,z = KLGameWorld.GetScenePosFromPlanePos(0,0,0)
    return x,y,z
end

function LSceneManager:CheckIsInModelShadowFromScenePos(lPlayer, nPosX, nPosY)
    local bCheck = false;

    if lPlayer then
        local lKActor = lPlayer:GetKActor();
        local curActorModel = lKActor:GetActorModel()
        bCheck = KLGameWorld.CheckIsInModelShadowFromScenePos(curActorModel, nPosX, nPosY);
    end

    return bCheck;
end

function LSceneManager:TurnOnPointLight(nIdx)
    -- οԴٱһ
    if self.m_tbPointLightMarkModel[nIdx] then
        return
    end

    local mdMarkModelActor
    local tPlayerActor = g_ActorManager:GetLocalPlayer()
    local fSelectX,fSelectY,fSelectZ = tPlayerActor:GetBoxSize(0,0,0)
    local fX, fY, fZ = tPlayerActor:GetModelPosition(0,0,0)
    -- ԴĬλ
    if nIdx == 1 then
        fY = fSelectY
        fZ = fSelectZ - 90
    elseif nIdx == 2 then
        fY = fY + 10
        fZ = fSelectZ - 90
    elseif nIdx == 3 then
        fX = fSelectX - 140
        fY = fSelectY / 2.0
        fZ = fSelectZ - 100
    elseif nIdx == 4 then
        fX = fSelectX - 85
        fY = fSelectY / 2.0
        fZ = fSelectZ - 90
    end

    KLGameWorld.AddPointLight(nIdx,fX, fY, fZ)
    mdMarkModelActor = KLActorManager.CreateMeshModel("data/source/other/Ч/ϵͳ/sfx//ɫ̾.sfx")
    mdMarkModelActor:SetWorldPosition(fX, fY, fZ)
    mdMarkModelActor:SetWorldScale(0.5,0.5,0.5)
    mdMarkModelActor:SetVisible(false)

    self.m_tbPointLightMarkModel[nIdx] = mdMarkModelActor
    local mdMarkModel = mdMarkModelActor:GetActorModel()
    if mdMarkModel then
        KLGameWorld.AddModelToScene(mdMarkModel)
    end
end

function LSceneManager:TurnOffPointLight(nIdx)
    if self.m_tbPointLightMarkModel[nIdx] then
        self.m_tbPointLightMarkModel[nIdx]:SetVisible(false)
        KLActorManager.DestroyActor(self.m_tbPointLightMarkModel[nIdx])
        KLGameWorld.RemovePointLight(nIdx)
        self.m_tbPointLightMarkModel[nIdx] = nil
    end
end

function LSceneManager:SetMarkModelVisible(bVisible)
    for k,v in pairs(self.m_tbPointLightMarkModel) do
        v:SetVisible(bVisible)
    end
end

function LSceneManager:ResetAllPointLight()
    for k,v in pairs(self.m_tbPointLightMarkModel) do
        self:TurnOffPointLight(k)
    end
end

function LSceneManager:GetPointLightNumber()
    local num = 0
    for k,v in pairs(self.m_tbPointLightMarkModel) do
        num = num +1
    end
    return num
end

_G.g_SceneManager = LSceneManager:new();
